//////////////////////////////////////////////////////////
//
//	MglDirectMusicBase  v0.10.51 05/01/29
//		- DirectMusicNX
//
//	v0.10.50 04/12/26
//	EFX
//
//	v0.10.51 05/01/29
//	E[vĐ̃WbN[Ƃ΂
//
//////////////////////////////////////////////////////////

#ifndef __MglDirectMusicBase_H__
#define __MglDirectMusicBase_H__

//	DirectShow
#include <DShow.h>/*
#ifdef _DEBUG
	#pragma comment(lib, "Strmbasd.lib")
#else
	#pragma comment(lib, "Strmbase.lib")
#endif//_DEBUG*/

//#include "MyuStringNameMap.h"

//	NX錾
class DLL_EXP CMglDirectMusicBase
{
private:
	IDirectMusicLoader8* m_pLoader;
	IDirectMusicPerformance8* m_pPerformance;
	//IDirectMusicSegment8 *segments[256];

	typedef map<string,IDirectMusicSegment8*> SEG_TYPE;
	typedef SEG_TYPE::iterator SEG_ITR;
	SEG_TYPE m_segments;

	BOOL m_flgEnable; // <-- RCcbaseɂׂȂCc
	
	//CMyuStringNameMap m_segments;

	//	݃`FbN
	void InitCheck() {
		if ( m_pLoader == NULL || m_pPerformance == NULL )
			Init();
	}
	BOOL IsExist( const char* szSegmentName )
	{
		SEG_ITR itr = m_segments.find( szSegmentName );
		if ( itr == m_segments.end() )
			return FALSE;
		else
			return TRUE;
	}
	void ExistChk( const char* szSegmentName )
	{
		if ( IsExist(szSegmentName) == FALSE )
			MyuThrow( 0, "CMglDirectMusicBase  m_segments[%s]݂͑ȂA܂͐Ă܂B", szSegmentName );
	}

public:
	CMglDirectMusicBase();
	virtual ~CMglDirectMusicBase();
	void InitEx( HWND hWnd, const char *szBaseDirectory, DWORD dwDefaultPathType, DWORD dwPerformanceChannelCount, DWORD dwFlags=DMUS_AUDIOF_ALL );
	void Init( HWND hWnd, const char *szBaseDirectory="" ){
		InitEx( hWnd, szBaseDirectory, DMUS_APATH_DYNAMIC_STEREO, 64 );}
	void Init( const char *szBaseDirectory="" ){ Init( NULL, szBaseDirectory ); }
	void Release();

	void Load( const char* szAudioFile, const char* szAlias=NULL );
	void PlaySegment( const char* szSegmentName );
	void Play( const char* szSegmentName ){PlaySegment(szSegmentName);}
	void LoopPlay( const char* szSegmentName, DWORD dwLoopCount=DMUS_SEG_REPEAT_INFINITE ){
		LoopPlaySegment(szSegmentName,dwLoopCount); }
	void LoopPlaySegment( const char* szSegmentName, DWORD dwLoopCount=DMUS_SEG_REPEAT_INFINITE );
	void StopSegment( const char* szSegmentName );
	void StopSegment( IDirectMusicSegment* pSegment );
	void Stop( const char* szSegmentName );

	void SetVolume( int nVolume=0 );

	void Disable(){
		/*
			SĂ̍Đ~B
			AĐĂȂZOgStopSegment()ƂǂȂ邩͕sB
		*/
		m_flgEnable = FALSE;
	}
	void Enable(){ m_flgEnable = TRUE; }

	//	
	//void PauseSegment( const char* szSegmentName ){}

	IDirectMusicSegment8* GetSegmentPtr( const char* szSegmentName );
};

#endif//__MglDirectMusicBase_H__