unit BucketListC5;

interface

uses Classes;

type
  TBucketList = class
  private
    list_: TList;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    function Add(anItem, aData: Pointer): Pointer;
    function Remove(anItem: Pointer): Pointer;
    function Find(anItem: Pointer; out aData: Pointer): Boolean;
    function Exists(anItem: Pointer): Boolean;
  end;

implementation

type
  PListElement = ^TListElement;
  TListElement = record
    key_: Pointer;
    value_: Pointer;
  end;

{ TBucketList }

constructor TBucketList.Create;
begin
  list_ := TList.Create;
end;

destructor TBucketList.Destroy;
begin
  Clear;
  list_.Free;
  inherited;
end;

function TBucketList.Add(anItem, aData: Pointer): Pointer;
var
  element: PListElement;
begin
  if Exists(anItem) then
    raise EListError.Create('ACe͊ɓo^Ă܂.');

  New(element);
  element.key_ := anItem;
  element.value_ := aData;
  list_.Add(element);
  Result := aData;
end;

procedure TBucketList.Clear;
var
  i: Integer;
begin
  for i := list_.Count - 1 downto 0 do
    Dispose(list_[i]);
  list_.Clear;
end;

function TBucketList.Find(anItem: Pointer; out aData: Pointer): Boolean;
var
  i: Integer;
  element: PListElement;
begin
  Result := False;
  for i := 0 to list_.Count - 1 do begin
    element := PListElement(list_[i]);
    if element^.key_ = anItem then begin
      Result := True;
      aData := element^.value_;
      Break;
    end;
  end;
end;

function TBucketList.Remove(anItem: Pointer): Pointer;
var
  i: Integer;
  element: PListElement;
begin
  Result := Nil;
  for i := 0 to list_.Count - 1 do begin
    element := PListElement(list_[i]);
    if element^.key_ = anItem then begin
      list_.Delete(i);
      Result := element.value_;
      Dispose(element);
      Break;
    end;
  end;
end;

function TBucketList.Exists(anItem: Pointer): Boolean;
var
  value: Pointer;
begin
  Result := Find(anItem, value);
end;

end.
