unit TestCaseTLinkedComponent;

interface

uses
  Classes, Forms, TestFrameWork, MSGSnatchers;

type
  TTestCaseLinkedComponent = class(TTestCase)
  private
    c1_, c2_, c3_: TLinkedComponent;
  protected
    procedure Setup; override;
    procedure TearDown; override;
  published
    procedure TestInsertAfter;
    procedure TestInsertBefore;
    procedure TestRemoveFromLink;
  end;


implementation

{ TTestCaseLinkedComponent }

procedure TTestCaseLinkedComponent.Setup;
begin
  inherited;
  c1_ := TLinkedComponent.Create(Nil);
  c2_ := TLinkedComponent.Create(Nil);
  c3_ := TLinkedComponent.Create(Nil);
end;

procedure TTestCaseLinkedComponent.TearDown;
begin
  inherited;
  c1_.Free;
  c2_.Free;
  c3_.Free;
end;

procedure TTestCaseLinkedComponent.TestInsertAfter;
begin
  c2_.InsertAfter(c1_);
  Check(c1_.Next = c2_);
  Check(c1_ = c2_.Prev);
end;

procedure TTestCaseLinkedComponent.TestInsertBefore;
begin
  c2_.InsertBefore(c1_);
  Check(c2_.Next = c1_);
  Check(c2_ = c1_.Prev);
end;

procedure TTestCaseLinkedComponent.TestRemoveFromLink;
begin
  c2_.InsertAfter(c1_);
  c3_.InsertAfter(c2_);
  c2_.RemoveFromLink;
  Check(c1_.Next = c3_);
  Check(c1_ = c3_.Prev);
end;

initialization
  TestFramework.RegisterTest(TTestCaseLinkedComponent.Suite);
end.
 