unit TestCaseTBucketList_C5;

// $Id: TestCaseTBucketList_C5.pas,v 1.1 2002/05/07 13:19:43 takao Exp $

interface

uses
  Classes, BucketListC5, TestFrameWork;

type
  TTestTBucketList = class(TTestCase)
  private
    list_: TBucketList;
    key_, value_: PInteger;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestAdd;
    procedure TestFind;
    procedure TestRemove;
    procedure TestExists;
    procedure TestDoubleAdd;
  end;


implementation

uses
  SysUtils;

{ TTestTBucketList }

procedure TTestTBucketList.SetUp;
begin
  list_ := TBucketList.Create;
  New(key_);
  New(value_);
end;

procedure TTestTBucketList.TearDown;
begin
  Dispose(value_);
  Dispose(key_);
  list_.Free;
end;

procedure TTestTBucketList.TestAdd;
begin
  Check(list_.Add(key_, value_) = value_);
end;

procedure TTestTBucketList.TestDoubleAdd;
var
  e: TObject;
begin
  e := Nil;
  list_.Add(key_, value_);
  try
    list_.Add(key_, value_);
  except
    on Exception do e := AcquireExceptionObject;
  end;
  Check(e is EListError, 'double addition permitted');
  e.Free;
end;

procedure TTestTBucketList.TestExists;
begin
  list_.Add(key_, value_);
  Check(list_.Exists(key_), 'element not exist');
end;

procedure TTestTBucketList.TestFind;
var
  found: Pointer;
begin
  list_.Add(key_, value_);
  Check(list_.Find(key_, found), 'element not found');
  Check(found = value_, 'unknown element found');
end;

procedure TTestTBucketList.TestRemove;
var
  found: Pointer;
begin
  list_.Add(key_, value_);
  Check(list_.Remove(key_) = value_, 'element not removed');
  Check(not list_.Find(key_, found), 'removed element found');
end;

initialization
  TestFramework.RegisterTest(TTestTBucketList.Suite);
end.
