//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"

#include "DataObjects.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "OleDnD"
#pragma link "MSGSnatchers"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DFItem_CF_HDROP_Drop(TObject *aSender,
	  TDragContext &aContext)
{
	MemoCFHDrop->Clear();
	GetFileList(aContext.DataObject, MemoCFHDrop->Lines);
	PageControl1->ActivePage = TabSheetCFHDrop;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DFItem_CF_TEXT_Drop(TObject *aSender,
	  TDragContext &aContext)
{
	MemoCFText->Text = ::GetText(aContext.DataObject);
	PageControl1->ActivePage = TabSheetCFText;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DFItem_CF_BITMAP_Drop(TObject *aSender,
	  TDragContext &aContext)
{
	GetBitmap(aContext.DataObject, ImageCFBitmap->Picture->Bitmap);
	ImageCFBitmap->Refresh();
	PageControl1->ActivePage = TabSheetCFBitmap;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DFItem_RichTextFormat_Drop(TObject *aSender,
      TDragContext &aContext)
{
	GetRichText(aContext.DataObject, RichEditCFRichText->Lines);
	PageControl1->ActivePage = TabSheetCFRichText;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FileDropTarget1FileDragEnter(TObject *aSender,
	  TDragContext &aContext)
{
	MemoFileDrag->Clear();
	MemoFileDrag->Lines->Add("DragEnter");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FileDropTarget1FileDragOver(TObject *aSender,
	  TDragContext &aContext)
{
	MemoFileDrag->Lines->Add("DragOver");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FileDropTarget1FileDragLeave(TObject *aSender,
	  HRESULT &aResult)
{
	MemoFileDrag->Lines->Add("DragLeave");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FileDropTarget1FileDrop(TObject *aSender,
	  TDragContext &aContext)
{
	MemoFileDrag->Lines->Add("Drop");
	MemoFileDrag->Lines->Add(FileDropTarget1->DroppedFiles->Text);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AddFormatEtc(const TFormatEtc& aFormat)
{
	ListBoxFormats->Items->Add(GetCFName(aFormat.cfFormat));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OleDropTarget1DragEnter(TObject *aSender,
	  TDragContext &aContext)
{
	ListBoxFormats->Clear();
	TDataObjectReader* reader = new TDataObjectReader(aContext.DataObject);
	try{
		reader->GetFormats(AddFormatEtc);
	} __finally{
		delete reader;
	}
}
//---------------------------------------------------------------------------

