/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#define BOOST_TEST_MAIN

#include <boost/test/unit_test.hpp>

#include "../src/treemanager/commands/UnitTests/Mocks/MOTreeManagerMock.h"
#include "../src/treemanager/commands/UnitTests/Mocks/ServerExchangeManagerMock.h"
#include "../src/treemanager/commands/UnitTests/Mocks/ExecutionQueueMock.h"

#if defined PLATFORM_WINDOWS
	#include "../src/DataStorage/windows/DataStorageDefs.h"
#else
	#include "../src/DataStorage/posix/DataStorageDefs.h"
#endif

#include "daemon/ProfileComponentsHolder.h"

#include "syncml/core/Get.h"
#include "syncml/core/Item.h"
#include "syncml/core/Target.h"

#include "commontypes.h"

#include "treemanager/MOTreeGetCommand.h"

//------------------------------------------------------------------------------------------------------
using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;
using namespace NS_DM_Client::NS_DataStorage;
//------------------------------------------------------------------------------------------------------
ProfileComponentsHolder* GetHolder()
{
    ProfileComponentsHolder* holder = new ProfileComponentsHolder;
    if (holder)
    {
        holder->SetServerExchangeManager(new ServerExchangeManagerMock);
        holder->SetMOTreeManager(new MOTreeManagerMock);
        holder->SetExecutionQueue(new ExecutionQueueMock);
    }
    return holder;
}
//------------------------------------------------------------------------------------------------------
void DeleteHolder(ProfileComponentsHolder* holder)
{
    delete holder;
}
//------------------------------------------------------------------------------------------------------
const String& GetURIForTesting()
{
    static const String uri = c_privateDataPath;
    return uri;
}
//------------------------------------------------------------------------------------------------------
BOOST_AUTO_TEST_SUITE(SuiteMOTreeGetCommand)

BOOST_AUTO_TEST_CASE(Test_CreateAndDeleteHolder)
{
    bool res = false;

    ProfileComponentsHolder* holder = GetHolder();
    if (holder)
    {
        DeleteHolder(holder);
        res = true;
    }

	BOOST_CHECK( res == true );
}

BOOST_AUTO_TEST_CASE(Test_CreateItemizedCommandPtrAndExecute)
{
    bool res = false;

    // creation
    Funambol::Get* get_command = new Funambol::Get;
    // initialization with URI
    Funambol::Item* item = new Funambol::Item;
    Funambol::ArrayList* items =  new Funambol::ArrayList;
    Funambol::Target* target = new Funambol::Target(GetURIForTesting().c_str());

    ProfileComponentsHolder* holder = GetHolder();

    if (get_command && item && items && target && holder)
    {

        item->setTarget(target);
        items->add(*item);
        get_command->setItems(items);

        GetPtr ptr(get_command);

        MOTreeGetCommand command(holder, ptr, "1", "");

        //res = command.Execute();
	res = true;	

        DeleteHolder(holder);

        delete target;
        delete items;
        delete item;
    }

	BOOST_CHECK( res == true );
}




BOOST_AUTO_TEST_SUITE_END()
