/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "MOTreeManagerMock.h"

#include "Errors.h"

namespace NS_DM_Client
{

bool MOTreeManagerMock::Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch)
{
    return true;
}

bool MOTreeManagerMock::Start()
{
    return true;
}

bool MOTreeManagerMock::Stop()
{
    return true;
}

void MOTreeManagerMock::Release()
{

}


//------------------------------------------------------------------------------------------------------
StatusCode MOTreeManagerMock::Get(const URI& uri, Funambol::Item& item, const char* serverId)
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::GetValue(const URI& uri, String& value, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::GetPropertyValue(const URI& uri, const String& property_name, String& value, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::GetChildren(const URI& uri, ChildrenPaths& children, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::GetAttributeStructData(const URI& uri, Funambol::ArrayList& items, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::Add(const URI& uri, const Funambol::Item& item, const char* serverId, bool isUpdateRequired)
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Delete(const URI& uri, const char* serverId)
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Replace(const URI& uri, const Funambol::Item& item, const char* serverId, bool isUpdateRequired)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::ReplacePropertyValue(const URI& uri, const String& property_name, const String& new_value, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::Copy(const URI& source, const URI& dest, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::ExecPermitted(const URI& path, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::SetPropertyValue(const URI& uri, const String& property_name, const String& value)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::StartTransaction()
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Rollback()
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Commit()
{
    return e_Ok;
}

//------------------------------------------------------------------------------------------------------
}
