/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <base/util/Enumeration.h>
#include <syncml/formatter/Formatter.h>
#include "serverexchange/wrappers/SResultsCommand.h"


using namespace NS_DM_Client::NS_SyncMLCommand;


SResultsCommand::SResultsCommand()
{
}


SResultsCommand::~SResultsCommand()
{
}


void SResultsCommand::createItemizedCommand()
{
	Funambol::Results *pResults = new Funambol::Results();
	m_ptrItemizedCommand.reset(pResults);

	pResults->setMsgRef(GetMsgRef());
	pResults->setCmdRef(GetCmdRef());

	Funambol::Enumeration &e = m_mapResults.getProperties();
	Funambol::ArrayList results; // list with Funambol::Item* instances
	while (e.hasMoreElement())
	{
		Funambol::ArrayElement* el = e.getNextElement();
		Funambol::KeyValuePair *pair = dynamic_cast<Funambol::KeyValuePair*>(el);

		if (pair && pair->getKey().c_str())
		{
			Funambol::Source source(pair->getKey().c_str());
			Funambol::ComplexData data(pair->getValue().c_str());
			Funambol::Item item(NULL/*target*/, &source, NULL/*meta*/, &data, false);

			// fill Meta info for the item
			Funambol::Meta meta;
			Funambol::StringBuffer format = m_mapFormats.readPropertyValue(pair->getKey());
			if (format.c_str() != NULL && format.length())
			{
				meta.setFormat(format.c_str());
			}

			Funambol::StringBuffer type = m_mapTypes.readPropertyValue(pair->getKey());
			if (type.c_str() != NULL && type.length())
			{
				meta.setType(type.c_str());
			}

			if (format.length() || type.length())
				item.setMeta(&meta);

			results.add(item);
		}
	}

	if (results.size())
		pResults->setItems(&results);
}


void SResultsCommand::AddResult(const char *key, const char * value)
{
	AddResult(key, value, NULL, NULL);
}


void SResultsCommand::AddResult(const char *key, const char * value, const char *format, const char *type)
{
	if (key)
	{
		if (value)
			m_mapResults.setPropertyValue(key, value);
		else
			m_mapResults.setPropertyValue(key, "");

		if (format)
			m_mapFormats.setPropertyValue(key, format);

		if (type)
			m_mapTypes.setPropertyValue(key, type);
	}
}


Funambol::Results * SResultsCommand::GetResults()
{
	return this_results();
}


Funambol::StringBuffer * SResultsCommand::ToString()
{
	if (m_ptrItemizedCommand.get())
		return Funambol::Formatter::getResults(this_results());
	else
		return SCommandAdapter::ToString();
}

