/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "IConfigurationParser.h"
#include "serverexchange/firmware/DDProcessor.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;

#define MIME_OCTET_STREAM   "application/octet-stream"

DDProcessor::DDProcessor() :
	m_isOctet(false), m_buffsize(2*1024), m_storedbytes(0), m_buffer(new char[m_buffsize])
{
	m_buffer[0] = '\0';
}


DDProcessor::~DDProcessor()
{
	SAFE_DELETE_ARR(m_buffer);
}


int DDProcessor::AppendBuffer(void *buffer, int size)
{
	if (m_buffsize > m_storedbytes + size + 1)
	{
		memcpy(m_buffer + m_storedbytes, buffer, size);
		m_storedbytes += size;
		m_buffer[m_storedbytes] = '\0';
		return size;
	}
	return 0;
}


void DDProcessor::Parse()
{
	IConfigurationParser* parser = IConfigurationParser::GetInstance(IConfigurationParser::e_XML);

	parser->Init(m_buffer, "media");
	parser->GetProperty("objectURI", objectURI);
	parser->GetProperty("installNotifyURI", installNotifyURI);

	String mime;
	parser->GetProperty("type", mime);
	m_isOctet = strstr(mime.c_str(), MIME_OCTET_STREAM) != NULL;

	parser->Release();
}

