/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "commontypes.h"
#include "executionqueue/ExecutionQueue.h"
#include "executionqueue/ICommand.h"
#include "executionqueue/QueueCommandRouter.h"
#include "executionqueue/CommandQueuePool.h"
#include "executionqueue/MOTreeCommandsQueue.h"
#include "executionqueue/ServerExchangeCommandsQueue.h"

#include <memory>

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_ExecutionQueue;

using std::auto_ptr;

ExecutionQueue::ExecutionQueue(void)
: m_logger(0),
m_QPool(0),
m_CmdDispatcher(0)
{
}


ExecutionQueue::~ExecutionQueue(void)
{
    if (m_QPool)
    {
        delete m_QPool;
        m_QPool = NULL;
    }

    if (m_CmdDispatcher)
    {
        delete m_CmdDispatcher;
        m_CmdDispatcher = NULL;
    }
}


bool ExecutionQueue::Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch)
{
    m_logger = &NS_Logging::GetLogger(loggerInstance.c_str());

    if (!m_QPool)
    {
        auto_ptr<MOTreeCommandsQueue> MOTreeCmdQ(new MOTreeCommandsQueue(*m_logger));
        if (!MOTreeCmdQ.get() || !MOTreeCmdQ->Init())
        {
            LOG_ERROR_(*m_logger, "instantiate MOTreeCommandsQueue failed. ");
            return false;
        }

        auto_ptr<ServerExchangeCommandsQueue> SerXchgCmdQ(new ServerExchangeCommandsQueue(*m_logger));
        if (!SerXchgCmdQ.get() || !SerXchgCmdQ->Init())
        {
            LOG_ERROR_(*m_logger, "instantiate ServerExchangeCommandsQueue failed. ");
            return false;
        }

        auto_ptr<CommandQueuePool> QPool(new CommandQueuePool(*MOTreeCmdQ.get(), *SerXchgCmdQ.get()));
        if (!QPool.get())
        {
            LOG_ERROR_(*m_logger, "instantiate CommandsQueuePool. ");
            return false;
        }
        MOTreeCmdQ.release();
        SerXchgCmdQ.release();

        if (!m_CmdDispatcher)
        {
            m_CmdDispatcher = new QueueCommandRouter(*QPool.get());
            if (!m_CmdDispatcher)
            {
                LOG_ERROR_(*m_logger, "instantiate QueueCommandRouter. ");
                return false;
            }

            m_QPool = QPool.get();
            QPool.release();
        }
    }

    LOG_DEBUG_(*m_logger, "Init result=%d. ", isInitialized());
    return isInitialized();
}


bool ExecutionQueue::Start()
{
    LOG_DEBUG_(*m_logger, "result=%d. ", isInitialized());
    return isInitialized();
}


bool ExecutionQueue::Stop()
{
    // TODO : also change ICommandDispatcher to instance that always failes to add the command
    // E.g. NulCommandRouter
    // See also ExecutionQueue::isInitialized()
    bool brc = m_QPool->StopCommandQueues();
    LOG_DEBUG_(*m_logger, "result=%d. ", brc);
    return brc;
}


void ExecutionQueue::Release()
{
    LOG_DEBUG_(*m_logger, "THIS=%p. ", this);
}


bool ExecutionQueue::Add(ICommand& cmd)
{
    bool brc = cmd.Visit(*m_CmdDispatcher);
    LOG_DEBUG_(*m_logger, "Command %p. brc=%d", &cmd, brc);
    return brc;
}


bool    ExecutionQueue::isInitialized() const
{
    return m_CmdDispatcher != 0;
}
