/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "NotificationListener/NotificationMessage.h"
#include "NotificationListener/NotificationMessageHdr.h"
#include "Utils.h"

#include <cstring>

using namespace NS_DM_Client::NS_NotificationListener;
using namespace NS_DM_Client;


NotificationMessage::NotificationMessage(void)
#ifdef PLT_BIG_ENDIAN
:m_header(m_message)
#endif
{
}

NotificationMessage::~NotificationMessage(void)
{
}

bool    NotificationMessage::SetMessage(const void*  msg, size_t size)
{
    m_message.resize(size);
    if (m_message.size() < size
        || size < HEADER_SIZE)
    {
        return false;
    }

    memcpy(&m_message[0], msg, size);

#ifdef PLT_LITTLE_ENDIAN
    const size_t header_size = HEADER_SIZE;
    m_header.reserve(header_size);
    if (m_header.capacity() < header_size)
    {
        return false;
    }

    buffer_t::const_pointer ptr = &m_message[0];
    buffer_t::const_pointer stop = &m_message[header_size];
    do
    {
        m_header.push_back(*ptr);
    }while(++ptr < stop);

    // swap bytes in trigger header
    size_t offset = 16; // after diggest
    unsigned long swaped = *(unsigned long*)&m_header[offset];
    m_header[offset+3] = (unsigned char)swaped;
    swaped >>= CHAR_BIT;
    m_header[offset+2] = (unsigned char)swaped;
    swaped >>= CHAR_BIT;
    m_header[offset+1] = (unsigned char)swaped;
    swaped >>= CHAR_BIT;
    m_header[offset+0] = (unsigned char)swaped;
    swaped = *(unsigned long*)&m_header[offset];

    offset = 21; // session ID
    unsigned short swaped_wd = *(unsigned short*)&m_header[offset];
    m_header[offset+1] = (unsigned char)swaped_wd;
    swaped_wd >>= CHAR_BIT;
    m_header[offset+0] = (unsigned char)swaped_wd;
    swaped_wd = *(unsigned short*)&m_header[offset];

#endif // PLT_LITTLE_ENDIAN

    char buf[256] = {0};
    char* p = buf;
    for (size_t i = 0; i < m_header.size(); ++i)
    {
        __sprintf(p, "%02X ", (unsigned char)m_header[i]);
        p += 3;
    }

    m_server_id.assign(getServerIDRef(), getServerIDLength());

    return true;
}

bool    NotificationMessage::CheckDiggest() const
{
    return false;
}

int     NotificationMessage::GetVersion() const
{
    const NOTIFICATION_MESSAGE_HDR* hdr = reinterpret_cast<const NOTIFICATION_MESSAGE_HDR*>(&m_header[0]);
    return hdr->version;
}

NotificationMessage::EnumUIMode    NotificationMessage::GetUIMode() const
{
    const NOTIFICATION_MESSAGE_HDR* hdr = reinterpret_cast<const NOTIFICATION_MESSAGE_HDR*>(&m_header[0]);
    return static_cast<EnumUIMode>(hdr->ui_mode);
}


NotificationMessage::EnumInitiator   NotificationMessage::GetInitiator() const
{
    const NOTIFICATION_MESSAGE_HDR* hdr = reinterpret_cast<const NOTIFICATION_MESSAGE_HDR*>(&m_header[0]);
    return static_cast<EnumInitiator>(hdr->initiator);
}


NotificationMessage::session_id_t    NotificationMessage::GetSessionID() const
{
    const NOTIFICATION_MESSAGE_HDR* hdr = reinterpret_cast<const NOTIFICATION_MESSAGE_HDR*>(&m_header[0]);
//    unsigned short swaped_wd = *(unsigned short*)&m_header[21];
    unsigned id = (hdr->session_id_high << CHAR_BIT) | hdr->session_id_low;
    return id;
}

bool            NotificationMessage::GetSessionID(String& sessionID) const
{
// 	the binary session ID value from the trigger message, in the unsigned hexadecimal range of 1 through FFFF,
// 	SHALL be mapped to a string of hexadecimal digits (chosen from the numeric digits "0"-"9" 
// 	and the upper-case letters "A"-"F") of between one and four characters in length, inclusive, 
// 	and placed in the SessionID element of the OMA DM message. Leading zeros MUST NOT be included. 

    char buf[32] = { 0 };
    __sprintf(buf, "%X", GetSessionID());
    sessionID = buf;

    return !sessionID.empty();
}


const char*     NotificationMessage::GetServerID() const
{
    return m_server_id.c_str();
}


const char*     NotificationMessage::getServerIDRef() const
{
    return &m_message[HEADER_SIZE];
}

size_t          NotificationMessage::getServerIDLength() const
{
    const NOTIFICATION_MESSAGE_HDR* hdr = reinterpret_cast<const NOTIFICATION_MESSAGE_HDR*>(&m_header[0]);
    return hdr->server_id_len;
}

