/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "ManagementObjects/WiMAX.h"
#include "../../treemanager/UTestMOTree/MockDataStorage.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInWiMAX(WiMAX& wiMAX)
{
	WiMAXRadioModule wiMAXRadioModule;
	wiMAXRadioModule.m_MACAddress = "MACAddress";
	wiMAXRadioModule.m_TO_FUMO_REF = "./FUMO";
	wiMAX.m_WiMAXRadioModule.push_back(wiMAXRadioModule);

	wiMAX.m_TerminalEquipment.m_SwV = "SwV";
	wiMAX.m_TO_WiMAX_REF = "TO_WiMAX_REF";
	wiMAX.m_DevCap.m_IPCap.m_CMIPV4 = 10;
	wiMAX.m_DevCap.m_UpdateMethods.m_ClientInitiated.m_PollingSupported = true;
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeWiMAXInTree)
{
	NS_DM_Client::WiMAX wimax;
	FillInWiMAX(wimax);

	BOOST_CHECK(wimax.Serialize(*S_treeManager));
	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/WiMAX/TerminalEquipment/SwV", fs::native);
	BOOST_CHECK(fs::exists(path));
	path = fs::path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/WiMAX/TO-WiMAX-REF", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeWiMAXFromTree)
{
	NS_DM_Client::WiMAX originalWiMAX;
	FillInWiMAX(originalWiMAX);
	BOOST_CHECK(originalWiMAX.Serialize(*S_treeManager));

	NS_DM_Client::WiMAX newWiMAX;

	BOOST_CHECK(newWiMAX.Deserialize(*S_treeManager));
	BOOST_CHECK(newWiMAX.m_WiMAXRadioModule[0].m_MACAddress == "MACAddress");
	BOOST_CHECK(newWiMAX.m_TerminalEquipment.m_SwV == "SwV");
	BOOST_CHECK(newWiMAX.m_TO_WiMAX_REF == "TO_WiMAX_REF");
	BOOST_CHECK(newWiMAX.m_DevCap.m_IPCap.m_CMIPV4 == 10);
	BOOST_CHECK(newWiMAX.m_DevCap.m_UpdateMethods.m_ClientInitiated.m_PollingSupported);

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeWiMAXInXml)
{
	NS_DM_Client::WiMAX wimax;
	FillInWiMAX(wimax);

	std::string wimaxXml;
	BOOST_CHECK(wimax.Serialize(wimaxXml));


	std::string expectedWimax;
	ReadFromFile("SerializeWiMAXInXml.xml", expectedWimax);

	//std::cout << wimaxXml << std::endl << std::endl;
//	BOOST_CHECK(wimaxXml == expectedWimax);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeWiMAXFromXml)
{
	std::string WiMAXXml;
	ReadFromFile("SerializeWiMAXInXml.xml", WiMAXXml);

	NS_DM_Client::WiMAX wiMAX;
//	BOOST_CHECK(wiMAX.Deserialize(WiMAXXml));

//	BOOST_CHECK(wiMAX.m_WiMAXRadioModule[0].m_MACAddress == "MACAddress");
//	BOOST_CHECK(wiMAX.m_TerminalEquipment.m_SwV == "SwV");
//	BOOST_CHECK(wiMAX.m_TO_WiMAX_REF == "TO_WIMAX_REF");
//	BOOST_CHECK(wiMAX.m_DevCap.m_IPCap.m_CMIPV4 == 10);
}
//-------------------------------------------------------------------------------------------
