/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "WiMAXSupp.h"
#include "Common.h"
#include "TNDSMgmtTree/TNDSCreator.h"
#include "TNDSMgmtTree/TNDSExtractor.h"
#include "treemanager/IMOTreeManager.h"

namespace NS_DM_Client
{
	enum WiMAXSuppEnum
	{
		e_Operator = 0
	};

	const String WiMAXSuppFieldPath[] =
	{
		"./WiMAXSupp"
	};
	//-------------------------------------------------------------------------------------------

	const String WiMAXSuppFieldName[] =
	{
		"Operator"
	};
	//-------------------------------------------------------------------------------------------

	enum OperatorEnum
	{
		e_NetworkParameters = 0,
		e_SubscriptionParameters,
		e_RootCA,
		e_Contacts,
		e_TO_IP_REF
	};

	const char* OperatorFieldName[] =
	{
		"NetworkParameters",
		"SubscriptionParameters",
		"RootCA",
		"Contacts",
		"TO-IP-REF"
	};
	//-------------------------------------------------------------------------------------------

	enum NetworkParametersEnum
	{
		e_H_NSP = 0,
		e_CAPL,
		e_RAPL,
		e_ChannelPlan,
		e_OperatorName,
		e_PollingInterval,
		e_H_NSP_ID
	};

	const char* NetworkParametersFieldName[] =
	{
		"H-NSP",
		"CAPL",
		"RAPL",
		"ChannelPlan",
		"OperatorName",
		"PollingInterval",
		"H-NSP-ID"
	};
	//-------------------------------------------------------------------------------------------

	enum CAPLEnum
	{
		e_CAPLEntries = 0,
		e_CAPLAny
	};

	const char* CAPLFieldName[] =
	{
		"Entries",
		"Any"
	};
	//-------------------------------------------------------------------------------------------

	enum CAPLEntriesEnum
	{
		e_NAP_ID = 0,
		e_CAPLPriority,
		e_ChPlanRefIds,
		e_RefId
	};

	const char* CAPLEntriesFieldName[] =
	{
		"NAP-ID",
		"Priority",
		"ChPlanRefIds",
		"RefId",
	};
	//-------------------------------------------------------------------------------------------

	enum RAPLEnum
	{
		e_RAPLEntries = 0,
		e_RAPLAny
	};

	const char* RAPLFieldName[] =
	{
		"Entries",
		"Any"
	};
	//-------------------------------------------------------------------------------------------

	enum RAPLEntriesEnum
	{
		e_V_NSP_ID = 0,
		e_RAPLPriority
	};

	const char* RAPLEntriesFieldName[] =
	{
		"V-NSP-ID",
		"Priority"
	};
	//-------------------------------------------------------------------------------------------

	enum ChannelPlanEnum
	{
		e_CPEntries = 0,
		e_BW,
		e_FFTSize,
		e_DuplexMode
	};

	const char* ChannelPlanFieldName[] =
	{
		"Entries",
		"BW",
		"FFTSize",
		"DuplexMode"
	};
	//-------------------------------------------------------------------------------------------

	enum ChannelPlanEntriesEnum
	{
		e_Id = 0,
		e_FirstFreq,
		e_LastFreq,
		e_NextFreqStep,
		e_Preambles,
		e_CPEBW,
		e_CPEFFTSize,
		e_CPEDuplexMode
	};

	const char* ChannelPlanEntriesFieldName[] =
	{
		"Id",
		"FirstFreq",
		"LastFreq",
		"NextFreqStep",
		"Preambles",
		"BW",
		"FFTSize",
		"DuplexMode"
	};
	//-------------------------------------------------------------------------------------------

	enum SubscriptionParametersEntriesEnum
	{
		e_SPPrimary = 0,
		e_OtherSubscriptions
	};

	const char* SubscriptionParametersFieldName[] =
	{
		"Primary",
		"OtherSubscriptions"
	};
	//-------------------------------------------------------------------------------------------

	enum PrimaryEnum
	{
		e_Name = 0,
		e_Activated,
		e_EAP
	};

	const char* PrimaryFieldName[] =
	{
		"Name",
		"Activated",
		"EAP"
	};
	//-------------------------------------------------------------------------------------------

	enum EAPEnum
	{
		e_METHOD_TYPE = 0,
		e_VENDOR_ID,
		e_VENDOR_TYPE,
		e_UserIdentity,
		e_PROVISIONED_PSEUDO_IDENTITY,
		e_PASSWORD,
		e_REALM,
		e_USE_PRIVACY,
		e_ENCAPS,
		e_VFY_SERVER_REALM,
		e_SERVER_REALMS,
		e_SERVER_REALM,
		e_EAP_AKA,
		e_USE_CHECKCODE,
		e_CERT
	};

	const char* EAPFieldName[] =
	{
		"METHOD-TYPE",
		"VENDOR-ID",
		"VENDOR-TYPE",
		"UserIdentity",
		"PROVISIONED-PSEUDO-IDENTITY",
		"PASSWORD",
		"REALM",
		"USE-PRIVACY",
		"ENCAPS",
		"VFY-SERVER-REALM",
		"SERVER-REALMS",
		"SERVER-REALM",
		"EAP-AKA",
		"USE-CHECKCODE",
		"CERT"
	};
	//-------------------------------------------------------------------------------------------

	enum CERTEnum
	{
		e_CERT_TYPE = 0,
		e_SER_NUM,
		e_THUMBPRINT
	};

	const char* CERTFieldName[] =
	{
		"CERT-TYPE",
		"SER-NUM",
		"THUMBPRINT"
	};
	//-------------------------------------------------------------------------------------------

	enum OtherSubscriptionsEnum
	{
		e_OSName = 0,
		e_OSActivated,
		e_OSEAP
	};

	const char* OtherSubscriptionsFieldName[] =
	{
		"Name",
		"Activated",
		"EAP"
	};
	//-------------------------------------------------------------------------------------------

	enum RootCAEnum
	{
		e_CertID = 0,
		e_Signature,
		e_Certificate
	};

	const char* RootCAFieldName[] =
	{
		"CertID",
		"Signature",
		"Certificate"
	};
	//-------------------------------------------------------------------------------------------

	enum ContactsEnum
	{
		e_Type = 0,
		e_Trigger,
		e_URI,
		e_Text
	};

	const char* ContactsFieldName[] =
	{
		"Type",
		"Trigger",
		"URI",
		"Text"
	};
	//-------------------------------------------------------------------------------------------

	bool Contacts::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + ContactsFieldName[e_Type], ToString(m_Type), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ContactsFieldName[e_Trigger], m_Trigger, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ContactsFieldName[e_URI], m_URI, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ContactsFieldName[e_Text], m_Text, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Contacts::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + ContactsFieldName[e_Type], m_Type, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ContactsFieldName[e_Trigger], m_Trigger, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ContactsFieldName[e_URI], m_URI, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ContactsFieldName[e_Text], m_Text, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Contacts::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, ContactsFieldName[e_Type], m_Type);
		tree.Append(basePathName, ContactsFieldName[e_Trigger], m_Trigger);
		tree.Append(basePathName, ContactsFieldName[e_URI], m_URI);
		tree.Append(basePathName, ContactsFieldName[e_Text], m_Text);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool Contacts::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, ContactsFieldName[e_Type], m_Type);
		tree.GetValue(basePathName, ContactsFieldName[e_Trigger], m_Trigger);
		tree.GetValue(basePathName, ContactsFieldName[e_URI], m_URI);
		tree.GetValue(basePathName, ContactsFieldName[e_Text], m_Text);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool RootCA::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + RootCAFieldName[e_CertID], m_CertID, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + RootCAFieldName[e_Signature], m_Signature, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + RootCAFieldName[e_Certificate], m_Certificate, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RootCA::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + RootCAFieldName[e_CertID], m_CertID, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + RootCAFieldName[e_Signature], m_Signature, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + RootCAFieldName[e_Certificate], m_Certificate, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RootCA::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, RootCAFieldName[e_CertID], m_CertID);
		tree.Append(basePathName, RootCAFieldName[e_Signature], m_Signature);
		tree.Append(basePathName, RootCAFieldName[e_Certificate], m_Certificate);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool RootCA::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, RootCAFieldName[e_CertID], m_CertID);
		tree.GetValue(basePathName, RootCAFieldName[e_Signature], m_Signature);
		tree.GetValue(basePathName, RootCAFieldName[e_Certificate], m_Certificate);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool OtherSubscriptions::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSName], m_Name, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSActivated], ToString(m_Activated), treeManager, S_intFormat);
		for (size_t i = 0; i != m_EAP.size(); ++i)
		{
			res &= m_EAP[i].Serialize(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSEAP] + S_slash + ToString(i), treeManager);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool OtherSubscriptions::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSName], m_Name, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSActivated], m_Activated, treeManager);

		size_t i = 0;
		String uri(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSEAP] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			EAP eap;
			res &= eap.Deserialize(uri, treeManager);
			m_EAP.push_back(eap);
			uri = basePathName + S_slash + OtherSubscriptionsFieldName[e_OSEAP] + S_slash + ToString(++i);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool OtherSubscriptions::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = false;
		tree.Append(basePathName, OtherSubscriptionsFieldName[e_OSName], m_Name);
		tree.Append(basePathName, OtherSubscriptionsFieldName[e_OSActivated], m_Activated);
		for (size_t i = 0; i != m_EAP.size(); ++i)
		{
			tree.Append(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSEAP], ToString(i));
			res = m_EAP[i].Serialize(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSEAP] + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool OtherSubscriptions::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, OtherSubscriptionsFieldName[e_OSName], m_Name);
		tree.GetValue(basePathName, OtherSubscriptionsFieldName[e_OSActivated], m_Activated);
		bool res = true;
		String uri(basePathName + S_slash + OtherSubscriptionsFieldName[e_OSEAP]);
		m_EAP.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_EAP.size(); ++i)
		{
			res = m_EAP[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CERT::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + CERTFieldName[e_CERT_TYPE], m_CERT_TYPE, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + CERTFieldName[e_SER_NUM], ToString(m_SER_NUM), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + CERTFieldName[e_THUMBPRINT], ToString(m_THUMBPRINT), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CERT::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + CERTFieldName[e_CERT_TYPE], m_CERT_TYPE, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + CERTFieldName[e_SER_NUM], m_SER_NUM, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + CERTFieldName[e_THUMBPRINT], m_THUMBPRINT, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CERT::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, CERTFieldName[e_CERT_TYPE], m_CERT_TYPE);
		tree.Append(basePathName, CERTFieldName[e_SER_NUM], m_SER_NUM);
		tree.Append(basePathName, CERTFieldName[e_THUMBPRINT], m_THUMBPRINT);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool CERT::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, CERTFieldName[e_CERT_TYPE], m_CERT_TYPE);
		tree.GetValue(basePathName, CERTFieldName[e_SER_NUM], m_SER_NUM);
		tree.GetValue(basePathName, CERTFieldName[e_THUMBPRINT], m_THUMBPRINT);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool EAP::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_METHOD_TYPE], ToString(m_METHOD_TYPE), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_VENDOR_ID], ToString(m_VENDOR_ID), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_VENDOR_TYPE], ToString(m_VENDOR_TYPE), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_UserIdentity], m_UserIdentity, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_PROVISIONED_PSEUDO_IDENTITY], m_PROVISIONED_PSEUDO_IDENTITY, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_PASSWORD], m_PASSWORD, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_REALM], m_REALM, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_USE_PRIVACY], ToString(m_USE_PRIVACY), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_ENCAPS], ToString(m_ENCAPS), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_VFY_SERVER_REALM], ToString(m_VFY_SERVER_REALM), treeManager, S_intFormat);
		for (size_t i = 0; i != m_SERVER_REALMS.size(); ++i)
		{
			res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_SERVER_REALMS] + S_slash + ToString(i) + S_slash + EAPFieldName[e_SERVER_REALM], m_SERVER_REALMS[i], treeManager);
		}
		res &= NS_DM_Client::Serialize(basePathName + S_slash + EAPFieldName[e_EAP_AKA] + S_slash + EAPFieldName[e_USE_CHECKCODE], ToString(m_EAP_AKA), treeManager, S_intFormat);
		for (size_t i = 0; i != m_CERT.size(); ++i)
		{
			res &= m_CERT[i].Serialize(basePathName + S_slash + EAPFieldName[e_CERT] + S_slash + ToString(i), treeManager);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool EAP::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_METHOD_TYPE], m_METHOD_TYPE, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_VENDOR_ID], m_VENDOR_ID, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_VENDOR_TYPE], m_VENDOR_TYPE, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_UserIdentity], m_UserIdentity, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_PROVISIONED_PSEUDO_IDENTITY], m_PROVISIONED_PSEUDO_IDENTITY, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_PASSWORD], m_PASSWORD, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_REALM], m_REALM, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_USE_PRIVACY], m_USE_PRIVACY, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_ENCAPS], m_ENCAPS, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_VFY_SERVER_REALM], m_VFY_SERVER_REALM, treeManager);

		size_t i = 0;
		String uri(basePathName + S_slash + EAPFieldName[e_SERVER_REALMS] + S_slash + ToString(i) + S_slash + EAPFieldName[e_SERVER_REALM]);
		while (treeManager.Exist(uri))
		{
			String item;
			res &= NS_DM_Client::Deserialize(uri, item, treeManager);
			m_SERVER_REALMS.push_back(item);
			uri = basePathName + S_slash + EAPFieldName[e_SERVER_REALMS] + S_slash + ToString(++i) + S_slash + EAPFieldName[e_SERVER_REALM];
		}
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + EAPFieldName[e_EAP_AKA] + S_slash + EAPFieldName[e_USE_CHECKCODE], m_EAP_AKA, treeManager);

		i = 0;
		uri = basePathName + S_slash + EAPFieldName[e_CERT] + S_slash + ToString(i);
		while (treeManager.Exist(uri))
		{
			CERT item;
			res &= item.Deserialize(uri, treeManager);
			m_CERT.push_back(item);
			uri = basePathName + S_slash + EAPFieldName[e_CERT] + S_slash + ToString(++i);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool EAP::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, EAPFieldName[e_METHOD_TYPE], m_METHOD_TYPE);
		tree.Append(basePathName, EAPFieldName[e_VENDOR_ID], m_VENDOR_ID);
		tree.Append(basePathName, EAPFieldName[e_VENDOR_TYPE], m_VENDOR_TYPE);
		tree.Append(basePathName, EAPFieldName[e_UserIdentity], m_UserIdentity);
		tree.Append(basePathName, EAPFieldName[e_PROVISIONED_PSEUDO_IDENTITY], m_PROVISIONED_PSEUDO_IDENTITY);
		tree.Append(basePathName, EAPFieldName[e_PASSWORD], m_PASSWORD);
		tree.Append(basePathName, EAPFieldName[e_REALM], m_REALM);
		tree.Append(basePathName, EAPFieldName[e_USE_PRIVACY], (size_t)m_USE_PRIVACY);
		tree.Append(basePathName, EAPFieldName[e_ENCAPS], m_ENCAPS);
		tree.Append(basePathName, EAPFieldName[e_VFY_SERVER_REALM], m_VFY_SERVER_REALM);
		for (size_t i = 0; i != m_SERVER_REALMS.size(); ++i)
		{
			tree.Append(basePathName + S_slash + EAPFieldName[e_SERVER_REALMS], ToString(i));
			tree.Append(basePathName + S_slash + EAPFieldName[e_SERVER_REALMS] + S_slash + ToString(i), EAPFieldName[e_SERVER_REALM], m_SERVER_REALMS[i]);
		}
		tree.Append(basePathName + S_slash + EAPFieldName[e_EAP_AKA], EAPFieldName[e_USE_CHECKCODE], m_EAP_AKA);
		bool res = true;
		for (size_t i = 0; i != m_CERT.size(); ++i)
		{
			tree.Append(basePathName + S_slash + EAPFieldName[e_CERT], ToString(i));
			res &= m_CERT[i].Serialize(basePathName + S_slash + EAPFieldName[e_CERT] + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool EAP::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, EAPFieldName[e_METHOD_TYPE], m_METHOD_TYPE);
		tree.GetValue(basePathName, EAPFieldName[e_VENDOR_ID], m_VENDOR_ID);
		tree.GetValue(basePathName, EAPFieldName[e_VENDOR_TYPE], m_VENDOR_TYPE);
		tree.GetValue(basePathName, EAPFieldName[e_UserIdentity], m_UserIdentity);
		tree.GetValue(basePathName, EAPFieldName[e_PROVISIONED_PSEUDO_IDENTITY], m_PROVISIONED_PSEUDO_IDENTITY);
		tree.GetValue(basePathName, EAPFieldName[e_PASSWORD], m_PASSWORD);
		tree.GetValue(basePathName, EAPFieldName[e_REALM], m_REALM);
		tree.GetValue(basePathName, EAPFieldName[e_USE_PRIVACY], m_USE_PRIVACY);
		tree.GetValue(basePathName, EAPFieldName[e_ENCAPS], m_ENCAPS);
		tree.GetValue(basePathName, EAPFieldName[e_VFY_SERVER_REALM], m_VFY_SERVER_REALM);

		String uri(basePathName + S_slash + EAPFieldName[e_SERVER_REALMS]);
		m_SERVER_REALMS.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_SERVER_REALMS.size(); ++i)
		{
			tree.GetValue(uri + S_slash + ToString(i), EAPFieldName[e_SERVER_REALM], m_SERVER_REALMS[i]);
		}
		tree.GetValue(basePathName + S_slash + EAPFieldName[e_EAP_AKA], EAPFieldName[e_USE_CHECKCODE], m_EAP_AKA);

		bool res = true;
		uri = basePathName + S_slash + EAPFieldName[e_CERT];
		m_CERT.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_CERT.size(); ++i)
		{
			res = m_CERT[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Primary::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + PrimaryFieldName[e_Name], m_Name, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + PrimaryFieldName[e_Activated], ToString(m_Activated), treeManager, S_intFormat);
		for (size_t i = 0; i != m_EAP.size(); ++i)
		{
			res &= m_EAP[i].Serialize(basePathName + S_slash + PrimaryFieldName[e_EAP] + S_slash + ToString(i), treeManager);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Primary::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + PrimaryFieldName[e_Name], m_Name, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + PrimaryFieldName[e_Activated], m_Activated, treeManager);

		size_t i = 0;
		String uri(basePathName + S_slash + PrimaryFieldName[e_EAP] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			EAP item;
			res &= item.Deserialize(uri, treeManager);
			m_EAP.push_back(item);
			uri = basePathName + S_slash + PrimaryFieldName[e_EAP] + S_slash + ToString(++i);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Primary::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = true;
		tree.Append(basePathName, PrimaryFieldName[e_Name], m_Name);
		tree.Append(basePathName, PrimaryFieldName[e_Activated], m_Activated);
		for (size_t i = 0; i != m_EAP.size(); ++i)
		{
			tree.Append(basePathName + S_slash + PrimaryFieldName[e_EAP], ToString(i));
			res &= m_EAP[i].Serialize(basePathName + S_slash + PrimaryFieldName[e_EAP] + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Primary::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, PrimaryFieldName[e_Name], m_Name);
		tree.GetValue(basePathName, PrimaryFieldName[e_Activated], m_Activated);

		bool res = true;
		String uri(basePathName + S_slash + PrimaryFieldName[e_EAP]);
		m_EAP.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_EAP.size(); ++i)
		{
			res &= m_EAP[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool SubscriptionParameters::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = m_Primary.Serialize(basePathName + S_slash + SubscriptionParametersFieldName[e_SPPrimary], treeManager);
		for (size_t i = 0; i != m_OtherSubscriptions.size(); ++i)
		{
			res &= m_OtherSubscriptions[i].Serialize(basePathName + S_slash + SubscriptionParametersFieldName[e_OtherSubscriptions] + S_slash + ToString(i), treeManager);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool SubscriptionParameters::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = m_Primary.Deserialize(basePathName + S_slash + SubscriptionParametersFieldName[e_SPPrimary], treeManager);
		size_t i = 0;
		String uri(basePathName + S_slash + SubscriptionParametersFieldName[e_OtherSubscriptions] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			OtherSubscriptions item;
			res &= item.Deserialize(uri, treeManager);
			m_OtherSubscriptions.push_back(item);
			uri = basePathName + S_slash + SubscriptionParametersFieldName[e_OtherSubscriptions] + S_slash + ToString(++i);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool SubscriptionParameters::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = m_Primary.Serialize(basePathName + S_slash + SubscriptionParametersFieldName[e_SPPrimary], tree);
		for (size_t i = 0; i != m_OtherSubscriptions.size(); ++i)
		{
			tree.Append(basePathName + S_slash + SubscriptionParametersFieldName[e_OtherSubscriptions], ToString(i));
			res &= m_OtherSubscriptions[i].Serialize(basePathName + S_slash + SubscriptionParametersFieldName[e_OtherSubscriptions] + 
				S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool SubscriptionParameters::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = m_Primary.Deserialize(basePathName + S_slash + SubscriptionParametersFieldName[e_SPPrimary], tree);

		String uri(basePathName + S_slash + SubscriptionParametersFieldName[e_OtherSubscriptions]);
		m_OtherSubscriptions.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_OtherSubscriptions.size(); ++i)
		{
			res &= m_OtherSubscriptions[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlanEntries::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_Id], m_Id, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_FirstFreq], ToString(m_FirstFreq), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_LastFreq], ToString(m_LastFreq), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_NextFreqStep], ToString(m_NextFreqStep), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_Preambles], m_Preambles, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_CPEBW], ToString(m_BW), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_CPEFFTSize], ToString(m_FFTSize), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_CPEDuplexMode], ToString(m_DuplexMode), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlanEntries::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_Id], m_Id, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_FirstFreq], m_FirstFreq, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_LastFreq], m_LastFreq, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_NextFreqStep], m_NextFreqStep, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_Preambles], m_Preambles, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_CPEBW], m_BW, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_CPEFFTSize], m_FFTSize, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanEntriesFieldName[e_CPEDuplexMode], m_DuplexMode, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlanEntries::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_Id], m_Id);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_FirstFreq], m_FirstFreq);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_LastFreq], m_LastFreq);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_NextFreqStep], m_NextFreqStep);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_Preambles], m_Preambles);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_CPEBW], m_BW);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_CPEFFTSize], m_FFTSize);
		tree.Append(basePathName, ChannelPlanEntriesFieldName[e_CPEDuplexMode], m_DuplexMode);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlanEntries::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_Id], m_Id);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_FirstFreq], m_FirstFreq);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_LastFreq], m_LastFreq);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_NextFreqStep], m_NextFreqStep);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_Preambles], m_Preambles);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_CPEBW], m_BW);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_CPEFFTSize], m_FFTSize);
		tree.GetValue(basePathName, ChannelPlanEntriesFieldName[e_CPEDuplexMode], m_DuplexMode);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlan::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = true;
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			res &= m_Entries[i].Serialize(basePathName + S_slash + ChannelPlanFieldName[e_CPEntries] + S_slash + ToString(i), treeManager);
		}
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanFieldName[e_BW], ToString(m_BW), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanFieldName[e_FFTSize], ToString(m_FFTSize), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ChannelPlanFieldName[e_DuplexMode], ToString(m_DuplexMode), treeManager, S_intFormat);
		return res;

	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlan::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = true;
		size_t i = 0;
		String uri(basePathName + S_slash + ChannelPlanFieldName[e_CPEntries] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			ChannelPlanEntries item;
			res &= item.Deserialize(uri, treeManager);
			m_Entries.push_back(item);
			uri = basePathName + S_slash + ChannelPlanFieldName[e_CPEntries] + S_slash + ToString(++i);
		}

		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanFieldName[e_BW], m_BW, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanFieldName[e_FFTSize], m_FFTSize, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ChannelPlanFieldName[e_DuplexMode], m_DuplexMode, treeManager);
		return res;

	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlan::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = true;
		String uri(basePathName + S_slash + ChannelPlanFieldName[e_CPEntries]);
		m_Entries.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			res &= m_Entries[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		tree.GetValue(basePathName, ChannelPlanFieldName[e_BW], m_BW);
		tree.GetValue(basePathName, ChannelPlanFieldName[e_FFTSize], m_FFTSize);
		tree.GetValue(basePathName, ChannelPlanFieldName[e_DuplexMode], m_DuplexMode);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool ChannelPlan::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = true;
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			tree.Append(basePathName + S_slash + ChannelPlanFieldName[e_CPEntries], ToString(i));
			res &= m_Entries[i].Serialize(basePathName + S_slash + ChannelPlanFieldName[e_CPEntries] + S_slash + ToString(i), tree);
		}
		tree.Append(basePathName, ChannelPlanFieldName[e_BW], m_BW);
		tree.Append(basePathName, ChannelPlanFieldName[e_FFTSize], m_FFTSize);
		tree.Append(basePathName, ChannelPlanFieldName[e_DuplexMode], m_DuplexMode);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPLEntries::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + RAPLEntriesFieldName[e_V_NSP_ID], ToString(m_V_NSP_ID), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + RAPLEntriesFieldName[e_RAPLPriority], ToString(m_Priority), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPLEntries::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + RAPLEntriesFieldName[e_V_NSP_ID], m_V_NSP_ID, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + RAPLEntriesFieldName[e_RAPLPriority], m_Priority, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPLEntries::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, RAPLEntriesFieldName[e_V_NSP_ID], m_V_NSP_ID);
		tree.Append(basePathName, RAPLEntriesFieldName[e_RAPLPriority], m_Priority);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPLEntries::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, RAPLEntriesFieldName[e_V_NSP_ID], m_V_NSP_ID);
		tree.GetValue(basePathName, RAPLEntriesFieldName[e_RAPLPriority], m_Priority);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPL::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = true;
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			res &= m_Entries[i].Serialize(basePathName + S_slash + RAPLFieldName[e_RAPLEntries] + S_slash + ToString(i), treeManager);
		}
		res &= NS_DM_Client::Serialize(basePathName + S_slash + RAPLFieldName[e_RAPLAny], ToString(m_Any), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPL::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = true;

		size_t i = 0;
		String uri(basePathName + S_slash + RAPLFieldName[e_RAPLEntries] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			RAPLEntries item;
			res &= item.Deserialize(uri, treeManager);
			m_Entries.push_back(item);
			uri = basePathName + S_slash + RAPLFieldName[e_RAPLEntries] + S_slash + ToString(++i);
		}

		res &= NS_DM_Client::Deserialize(basePathName + S_slash + RAPLFieldName[e_RAPLAny], m_Any, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPL::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = true;
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			tree.Append(basePathName + S_slash + RAPLFieldName[e_RAPLEntries], ToString(i));
			res &= m_Entries[i].Serialize(basePathName + S_slash + RAPLFieldName[e_RAPLEntries] + S_slash + ToString(i), tree);
		}
		tree.Append(basePathName, RAPLFieldName[e_RAPLAny], m_Any);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool RAPL::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = true;
		String uri(basePathName + S_slash + RAPLFieldName[e_RAPLEntries]);
		m_Entries.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			res &= m_Entries[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		tree.GetValue(basePathName, RAPLFieldName[e_RAPLAny], m_Any);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPLEntries::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + CAPLEntriesFieldName[e_NAP_ID], ToString(m_NAP_ID), treeManager, S_intFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + CAPLEntriesFieldName[e_CAPLPriority], ToString(m_Priority), treeManager, S_intFormat);
		for (size_t i = 0; i != m_ChPlanRefIds.size(); ++i)
		{
			res &= NS_DM_Client::Serialize(basePathName + S_slash + CAPLEntriesFieldName[e_ChPlanRefIds] + S_slash + ToString(i) + S_slash 
				+ CAPLEntriesFieldName[e_RefId], m_ChPlanRefIds[i], treeManager);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPLEntries::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + CAPLEntriesFieldName[e_NAP_ID], m_NAP_ID, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + CAPLEntriesFieldName[e_CAPLPriority], m_Priority, treeManager);

		size_t i = 0;
		String uri(basePathName + S_slash + CAPLEntriesFieldName[e_ChPlanRefIds] + S_slash + ToString(i) + S_slash + CAPLEntriesFieldName[e_RefId]);
		while (treeManager.Exist(uri))
		{
			String item;
			res &= NS_DM_Client::Deserialize(uri, item, treeManager);
			m_ChPlanRefIds.push_back(item);
			uri = basePathName + S_slash + CAPLEntriesFieldName[e_ChPlanRefIds] + S_slash + ToString(++i) + S_slash + CAPLEntriesFieldName[e_RefId];
		}

		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPLEntries::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, CAPLEntriesFieldName[e_NAP_ID], m_NAP_ID);
		tree.Append(basePathName, CAPLEntriesFieldName[e_CAPLPriority], m_Priority);
		for (size_t i = 0; i != m_ChPlanRefIds.size(); ++i)
		{
			tree.Append(basePathName + S_slash + CAPLEntriesFieldName[e_ChPlanRefIds], ToString(i));
			tree.Append(basePathName + S_slash + CAPLEntriesFieldName[e_ChPlanRefIds] + S_slash + ToString(i), CAPLEntriesFieldName[e_RefId],
				m_ChPlanRefIds[i]);
		}
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPLEntries::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, CAPLEntriesFieldName[e_NAP_ID], m_NAP_ID);
		tree.GetValue(basePathName, CAPLEntriesFieldName[e_CAPLPriority], m_Priority);

		String uri(basePathName + S_slash + CAPLEntriesFieldName[e_ChPlanRefIds]);
		m_ChPlanRefIds.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_ChPlanRefIds.size(); ++i)
		{
			tree.GetValue(uri + S_slash + ToString(i), CAPLEntriesFieldName[e_RefId], m_ChPlanRefIds[i]);
		}
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPL::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = true;
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			res &= m_Entries[i].Serialize(basePathName + S_slash + CAPLFieldName[e_CAPLEntries] + S_slash + ToString(i), treeManager);
		}
		res &= NS_DM_Client::Serialize(basePathName + S_slash + CAPLFieldName[e_CAPLAny], ToString(m_Any), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPL::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = true;
		size_t i = 0;
		String uri(basePathName + S_slash + CAPLFieldName[e_CAPLEntries] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			CAPLEntries item;
			res &= item.Deserialize(uri, treeManager);
			m_Entries.push_back(item);
			uri = basePathName + S_slash + CAPLFieldName[e_CAPLEntries] + S_slash + ToString(++i);
		}

		res &= NS_DM_Client::Deserialize(basePathName + S_slash + CAPLFieldName[e_CAPLAny], m_Any, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPL::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = true;
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			tree.Append(basePathName + S_slash + CAPLFieldName[e_CAPLEntries], ToString(i));
			res &= m_Entries[i].Serialize(basePathName + S_slash + CAPLFieldName[e_CAPLEntries] + S_slash + ToString(i), tree);
		}
		tree.Append(basePathName, CAPLFieldName[e_CAPLAny], m_Any);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool CAPL::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = true;
		String uri(basePathName + S_slash + CAPLFieldName[e_CAPLEntries]);
		m_Entries.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_Entries.size(); ++i)
		{
			res &= m_Entries[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		tree.GetValue(basePathName, CAPLFieldName[e_CAPLAny], m_Any);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool NetworkParameters::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = true;
		for (size_t i = 0; i != m_H_NSP.size(); ++i)
		{
			res &= NS_DM_Client::Serialize(basePathName + S_slash + NetworkParametersFieldName[e_H_NSP] + S_slash 
				+ ToString(i) + S_slash + NetworkParametersFieldName[e_H_NSP_ID], ToString(m_H_NSP[i]), treeManager, S_intFormat);
		}
		res &= m_CAPL.Serialize(basePathName + S_slash + NetworkParametersFieldName[e_CAPL], treeManager);
		res &= m_RAPL.Serialize(basePathName + S_slash + NetworkParametersFieldName[e_RAPL], treeManager);
		res &= m_ChannelPlan.Serialize(basePathName + S_slash + NetworkParametersFieldName[e_ChannelPlan], treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + NetworkParametersFieldName[e_OperatorName], m_OperatorName, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + NetworkParametersFieldName[e_PollingInterval], ToString(m_PollingInterval), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool NetworkParameters::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = true;
		size_t i = 0;
		String uri(basePathName + S_slash + NetworkParametersFieldName[e_H_NSP] + S_slash + ToString(i) + S_slash
			+ NetworkParametersFieldName[e_H_NSP_ID]);
		while (treeManager.Exist(uri))
		{
			size_t item;
			res &= NS_DM_Client::Deserialize(uri, item, treeManager);
			m_H_NSP.push_back(item);
			uri = basePathName + S_slash + NetworkParametersFieldName[e_H_NSP] + S_slash + ToString(++i) + S_slash 
				+ NetworkParametersFieldName[e_H_NSP_ID];
		}

		res &= m_CAPL.Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_CAPL], treeManager);
		res &= m_RAPL.Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_RAPL], treeManager);
		res &= m_ChannelPlan.Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_ChannelPlan], treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_OperatorName], m_OperatorName, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_PollingInterval], m_PollingInterval, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool NetworkParameters::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = true;
		for (size_t i = 0; i != m_H_NSP.size(); ++i)
		{
			tree.Append(basePathName + S_slash + NetworkParametersFieldName[e_H_NSP], ToString(i));
			tree.Append(basePathName + S_slash + NetworkParametersFieldName[e_H_NSP] + S_slash + ToString(i), 
				NetworkParametersFieldName[e_H_NSP_ID], m_H_NSP[i]);
		}
		res &= m_CAPL.Serialize(basePathName + S_slash + NetworkParametersFieldName[e_CAPL], tree);
		res &= m_RAPL.Serialize(basePathName + S_slash + NetworkParametersFieldName[e_RAPL], tree);
		res &= m_ChannelPlan.Serialize(basePathName + S_slash + NetworkParametersFieldName[e_ChannelPlan], tree);
		tree.Append(basePathName, NetworkParametersFieldName[e_OperatorName], m_OperatorName);
		tree.Append(basePathName, NetworkParametersFieldName[e_PollingInterval], m_PollingInterval);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool NetworkParameters::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = true;
		String uri(basePathName + S_slash + NetworkParametersFieldName[e_H_NSP]);
		m_H_NSP.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_H_NSP.size(); ++i)
		{
			tree.GetValue(uri + S_slash + ToString(i), NetworkParametersFieldName[e_H_NSP_ID], m_H_NSP[i]);
		}

		res &= m_CAPL.Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_CAPL], tree);
		res &= m_RAPL.Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_RAPL], tree);
		res &= m_ChannelPlan.Deserialize(basePathName + S_slash + NetworkParametersFieldName[e_ChannelPlan], tree);
		tree.GetValue(basePathName, NetworkParametersFieldName[e_OperatorName], m_OperatorName);
		tree.GetValue(basePathName, NetworkParametersFieldName[e_PollingInterval], m_PollingInterval);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Operator::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = m_NetworkParameters.Serialize(basePathName + S_slash + OperatorFieldName[e_NetworkParameters], treeManager);
		res &= m_SubscriptionParameters.Serialize(basePathName + S_slash + OperatorFieldName[e_SubscriptionParameters], treeManager);
		for (size_t i = 0; i != m_RootCA.size(); ++i)
		{
			res = m_RootCA[i].Serialize(basePathName + S_slash + OperatorFieldName[e_RootCA] + S_slash + ToString(i), treeManager);
		}
		for (size_t i = 0; i != m_Contacts.size(); ++i)
		{
			res = m_Contacts[i].Serialize(basePathName + S_slash + OperatorFieldName[e_Contacts] + S_slash + ToString(i), treeManager);
		}
		res &= NS_DM_Client::Serialize(basePathName + S_slash + OperatorFieldName[e_TO_IP_REF], m_TO_IP_REF, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Operator::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = m_NetworkParameters.Deserialize(basePathName + S_slash + OperatorFieldName[e_NetworkParameters], treeManager);
		res &= m_SubscriptionParameters.Deserialize(basePathName + S_slash + OperatorFieldName[e_SubscriptionParameters], treeManager);

		size_t i = 0;
		String uri(basePathName + S_slash + OperatorFieldName[e_RootCA] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			RootCA item;
			res &= item.Deserialize(uri, treeManager);
			m_RootCA.push_back(item);
			uri = basePathName + S_slash + OperatorFieldName[e_RootCA] + S_slash + ToString(++i);
		}

		i = 0;
		uri = basePathName + S_slash + OperatorFieldName[e_Contacts] + S_slash + ToString(i);
		while (treeManager.Exist(uri))
		{
			Contacts item;
			res &= item.Deserialize(uri, treeManager);
			m_Contacts.push_back(item);
			uri = basePathName + S_slash + OperatorFieldName[e_Contacts] + S_slash + ToString(++i);
		}

		res &= NS_DM_Client::Deserialize(basePathName + S_slash + OperatorFieldName[e_TO_IP_REF], m_TO_IP_REF, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Operator::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = m_NetworkParameters.Serialize(basePathName + S_slash + OperatorFieldName[e_NetworkParameters], tree);
		res &= m_SubscriptionParameters.Serialize(basePathName + S_slash + OperatorFieldName[e_SubscriptionParameters], tree);

		for (size_t i = 0; i != m_RootCA.size(); ++i)
		{
			tree.Append(basePathName + S_slash + OperatorFieldName[e_RootCA], ToString(i));
			res &= m_RootCA[i].Serialize(basePathName + S_slash + OperatorFieldName[e_RootCA] + S_slash + ToString(i), tree);
		}
		for (size_t i = 0; i != m_Contacts.size(); ++i)
		{
			tree.Append(basePathName + S_slash + OperatorFieldName[e_Contacts], ToString(i));
			res &= m_Contacts[i].Serialize(basePathName + S_slash + OperatorFieldName[e_Contacts] + S_slash + ToString(i), tree);
		}
		tree.Append(basePathName, OperatorFieldName[e_TO_IP_REF], m_TO_IP_REF);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool Operator::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = m_NetworkParameters.Deserialize(basePathName + S_slash + OperatorFieldName[e_NetworkParameters], tree);
		res &= m_SubscriptionParameters.Deserialize(basePathName + S_slash + OperatorFieldName[e_SubscriptionParameters], tree);
		String uri(basePathName + S_slash + OperatorFieldName[e_RootCA]);
		m_RootCA.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_RootCA.size(); ++i)
		{
			res &= m_RootCA[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		uri = basePathName + S_slash + OperatorFieldName[e_Contacts];
		m_Contacts.resize(tree.GetCount(uri));
		for (size_t i = 0; i != m_Contacts.size(); ++i)
		{
			res &= m_Contacts[i].Deserialize(uri + S_slash + ToString(i), tree);
		}
		tree.GetValue(basePathName, OperatorFieldName[e_TO_IP_REF], m_TO_IP_REF);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXSupp::Serialize(IMOTreeManager& treeManager) const
	{
		bool res = true;
		Operators::const_iterator end(m_Operator.end());
		for (Operators::const_iterator iter = m_Operator.begin(); iter != end; ++iter)
		{
			res = iter->second.Serialize(WiMAXSuppFieldPath[e_Operator] + S_slash + WiMAXSuppFieldName[e_Operator] + 
				S_slash + iter->first, treeManager);
		}

		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXSupp::Deserialize(IMOTreeManager& treeManager)
	{
		bool res = true;
		size_t i = 0;
		String uri(WiMAXSuppFieldPath[e_Operator] + S_slash + WiMAXSuppFieldName[e_Operator]);
		IMOTreeManager::ChildrenPaths children;
		res = (treeManager.GetChildren(uri, children) == e_Ok);
		if (res)
		{
	 		for (size_t i = 0; i != children.size(); ++i)
			{
				Operator curOperator;
				res &= curOperator.Deserialize(uri + S_slash + children[i], treeManager);
				m_Operator[children[i]] = curOperator;
			}
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXSupp::Serialize(String& xml) const
	{
		bool res = true;
		TNDSCreator tree;
		Operators::const_iterator end(m_Operator.end());
		for (Operators::const_iterator iter = m_Operator.begin(); iter != end; ++iter)
		{
			OperatorName name(iter->first);
			tree.Append(WiMAXSuppFieldPath[e_Operator] + S_slash + WiMAXSuppFieldName[e_Operator], name);
			res &= iter->second.Serialize(WiMAXSuppFieldPath[e_Operator] + S_slash + WiMAXSuppFieldName[e_Operator] + S_slash + name, tree);
		}

		tree.Get(xml);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXSupp::Deserialize(const String& xml)
	{
 		TNDSExtractor tree(xml);
 		bool res = true;
		String uri(WiMAXSuppFieldPath[e_Operator] + S_slash + WiMAXSuppFieldName[e_Operator]);
		TNDSExtractor::Children children;
		tree.GetChildren(uri, children);
		for (size_t i = 0; i != children.size(); ++i)
		{
			Operator curOperator;
			res &= curOperator.Deserialize(uri + S_slash + children[i], tree);
			m_Operator[children[i]] = curOperator;
		}
 		return res;
	}
	//-------------------------------------------------------------------------------------------
}