/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "ManagementObjects/TNDSMgmtTree/TNDSCreator.h"
#include "Common.h"
#include "Utils.h"
#include <syncml/formatter/Formatter.h>
#include <syncml/core/ObjectDel.h>

namespace NS_DM_Client
{
	TNDSCreator::TNDSCreator(): m_buffer(new Funambol::StringBuffer((S_beginScope + S_mgmtTree + S_versionNS + S_endScope).c_str()))
	{
		appendVersion();
	}
	//-------------------------------------------------------------------------------------------

	TNDSCreator::~TNDSCreator()
	{
		Funambol::deleteStringBuffer(&m_buffer);
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::appendVersion()
	{
		Funambol::VerDTD ver(S_verDTD.c_str());
		Funambol::StringBuffer* verDTD = Funambol::Formatter::getVerDTD(&ver);
		m_buffer->append(verDTD);
		Funambol::deleteStringBuffer(&verDTD);
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::Append(const String& path, const String& name, const String& value)
	{
		append(path, name, S_formatLeaf, value);
	}
	//-------------------------------------------------------------------------------------------
//// 2011.05.02
	void TNDSCreator::Append(const String& path, const String& name, bool value)
	{
		String tmpValue = "false";
		if(value) tmpValue = "true";
		append(path, name, S_boolFormat, (String &)tmpValue);
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::append(const String& path, const String& name, const String& format, const String& value/* = ""*/)
	{
		Funambol::StringBuffer* node = new Funambol::StringBuffer();
		node->append((S_beginScope + S_node + S_endScope).c_str());
		appendValue(node, S_nodeName, name);
		appendValue(node, S_path, path);

		Funambol::StringBuffer* RTPProperties = new Funambol::StringBuffer((S_beginScope + S_RTProperties + S_endScope).c_str());
		appendValue(RTPProperties, S_format, format);
		if (S_formatNode != format)
		{
			appendValue(RTPProperties, S_value, value);
		}
		RTPProperties->append((S_beginScope + S_slash + S_RTProperties + S_endScope).c_str());
		node->append(RTPProperties);

		node->append((S_beginScope + S_slash + S_node + S_endScope).c_str());

		m_buffer->append(node);
		Funambol::deleteStringBuffer(&RTPProperties);
		Funambol::deleteStringBuffer(&node);
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::Append(const String& path, const String& name, size_t value)
	{
		String strValue = ToString(value);
		Append(path, name, strValue);
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::Append(const String& path, const String& nodeName)
	{
		append(path, nodeName, S_formatNode);
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::Get(String& xml)
	{
		xml = String(m_buffer->c_str()) + S_beginScope + S_slash + S_mgmtTree + S_endScope;
	}
	//-------------------------------------------------------------------------------------------

	void TNDSCreator::appendValue(Funambol::StringBuffer*& nodeXml, const String& target, const String& value)
	{
		Funambol::StringBuffer* valueBuffer = Funambol::Formatter::getValue(target.c_str(), value.c_str());
		nodeXml->append(valueBuffer);
		Funambol::deleteStringBuffer(&valueBuffer);
	}
	//-------------------------------------------------------------------------------------------
}
