/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "Common.h"
#include "Utils.h"
#include <syncml/formatter/Formatter.h>
#include <syncml/core/ObjectDel.h>
#include <base/util/XMLProcessor.h>
#include "treemanager/IMOTreeManager.h"
#include <syncml/core/Item.h>

namespace NS_DM_Client
{
	bool SerializeItemToTree(const String& path, const String& data, IMOTreeManager& treeManager, 
		const String& format, const String& acl, const String& nodeType)
	{
		// TODO: set property ACL to current node
		Funambol::Item item;
		Funambol::Target target(path.c_str());
		item.setTarget(&target);
		Funambol::Meta meta;
		if (!nodeType.empty())
			meta.setType(nodeType.c_str());

		if (!format.empty())
		{
			meta.setFormat(format.c_str());
		}
		else
		{
			const String defaultFormat("chr");
			meta.setFormat(defaultFormat.c_str());
		}

		item.setMeta(&meta);
		Funambol::ComplexData complexData(data.c_str());
		item.setData(&complexData);

		StatusCode status = treeManager.Add(path, item, 0, false);
		if (e_AlreadyExists == status)
		{
			status = treeManager.Replace(path, item, 0, false);
		}
		if (!acl.empty())
		{
			treeManager.SetPropertyValue(path, "ACL", acl);
		}
		return status == e_Ok? true: false;
	}
	//-------------------------------------------------------------------------------------------
}