/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "DevDetail.h"
#include "Common.h"
#include "TNDSMgmtTree/TNDSCreator.h"
#include "TNDSMgmtTree/TNDSExtractor.h"
#include "Logger.h"

namespace NS_DM_Client
{
	enum DevDetailEnum
	{
		e_URI_MaxDepth = 0,
		e_URI_MaxTotLen,
		e_URI_MaxSegLen,
		e_DevTyp,
		e_OEM,
		e_FwV,
		e_SwV,
		e_HwV,
		e_LrgObj
	};

	const String DevDetailFieldPath[] =
	{
		"./DevDetail/URI/",
		"./DevDetail/URI/",
		"./DevDetail/URI/",
		"./DevDetail/",
		"./DevDetail/",
		"./DevDetail/",
		"./DevDetail/",
		"./DevDetail/",
		"./DevDetail/"
	};

	const String DevDetailFieldName[] =
	{
		"MaxDepth",
		"MaxTotLen",
		"MaxSegLen",
		"DevTyp",
		"OEM",
		"FwV",
		"SwV",
		"HwV",
		"LrgObj"
	};

	bool DevDetail::Serialize(IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(DevDetailFieldPath[e_URI_MaxDepth] + DevDetailFieldName[e_URI_MaxDepth], ToString(m_URI.m_MaxDepth), treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_URI_MaxTotLen] + DevDetailFieldName[e_URI_MaxTotLen], ToString(m_URI.m_MaxTotLen), treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_URI_MaxSegLen] + DevDetailFieldName[e_URI_MaxSegLen], ToString(m_URI.m_MaxSegLen), treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_DevTyp] + DevDetailFieldName[e_DevTyp], m_DevTyp, treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_OEM] + DevDetailFieldName[e_OEM], m_OEM, treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_FwV] + DevDetailFieldName[e_FwV], m_FwV, treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_SwV] + DevDetailFieldName[e_SwV], m_SwV, treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_HwV] + DevDetailFieldName[e_HwV], m_HwV, treeManager);
		res &= NS_DM_Client::Serialize(DevDetailFieldPath[e_LrgObj] + DevDetailFieldName[e_LrgObj], ToString(m_LrgObj), treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool DevDetail::Deserialize(IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(DevDetailFieldPath[e_URI_MaxDepth] + DevDetailFieldName[e_URI_MaxDepth], m_URI.m_MaxDepth, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_URI_MaxTotLen] + DevDetailFieldName[e_URI_MaxTotLen], m_URI.m_MaxTotLen, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_URI_MaxSegLen] + DevDetailFieldName[e_URI_MaxSegLen], m_URI.m_MaxSegLen, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_DevTyp] + DevDetailFieldName[e_DevTyp], m_DevTyp, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_OEM] + DevDetailFieldName[e_OEM], m_OEM, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_FwV] + DevDetailFieldName[e_FwV], m_FwV, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_SwV] + DevDetailFieldName[e_SwV], m_SwV, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_HwV] + DevDetailFieldName[e_HwV], m_HwV, treeManager);
		res &= NS_DM_Client::Deserialize(DevDetailFieldPath[e_LrgObj] + DevDetailFieldName[e_LrgObj], m_LrgObj, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool DevDetail::Serialize(String& xml) const
	{
		TNDSCreator tree;
		tree.Append(DevDetailFieldPath[e_URI_MaxDepth], DevDetailFieldName[e_URI_MaxDepth], m_URI.m_MaxDepth);
		tree.Append(DevDetailFieldPath[e_URI_MaxTotLen], DevDetailFieldName[e_URI_MaxTotLen], m_URI.m_MaxTotLen);
		tree.Append(DevDetailFieldPath[e_URI_MaxSegLen], DevDetailFieldName[e_URI_MaxSegLen], m_URI.m_MaxSegLen);
		tree.Append(DevDetailFieldPath[e_DevTyp], DevDetailFieldName[e_DevTyp], m_DevTyp);
		tree.Append(DevDetailFieldPath[e_OEM], DevDetailFieldName[e_OEM], m_OEM);
		tree.Append(DevDetailFieldPath[e_FwV], DevDetailFieldName[e_FwV], m_FwV);
		tree.Append(DevDetailFieldPath[e_SwV], DevDetailFieldName[e_SwV], m_SwV);
		tree.Append(DevDetailFieldPath[e_HwV], DevDetailFieldName[e_HwV], m_HwV);
		tree.Append(DevDetailFieldPath[e_LrgObj], DevDetailFieldName[e_LrgObj], m_LrgObj);

		tree.Get(xml);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool DevDetail::Deserialize(const String& xml)
	{
		String value;
		TNDSExtractor extractor(xml);
		extractor.GetValue(DevDetailFieldName[e_URI_MaxDepth], m_URI.m_MaxDepth);
		extractor.GetValue(DevDetailFieldName[e_URI_MaxTotLen], m_URI.m_MaxTotLen);
		extractor.GetValue(DevDetailFieldName[e_URI_MaxSegLen], m_URI.m_MaxSegLen);
		extractor.GetValue(DevDetailFieldName[e_DevTyp], m_DevTyp);
		extractor.GetValue(DevDetailFieldName[e_OEM], m_OEM);
		extractor.GetValue(DevDetailFieldName[e_FwV], m_FwV);
		extractor.GetValue(DevDetailFieldName[e_SwV], m_SwV);
		extractor.GetValue(DevDetailFieldName[e_HwV], m_HwV);
		extractor.GetValue(DevDetailFieldName[e_LrgObj], m_LrgObj);

		return true;
	}

}
