/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "DataStorage/IDataStorage.h"
#include "Lock.h"

#include <stdio.h>

namespace NS_DM_Client
{

namespace NS_DataStorage
{

class Logger;

class CDataStorage;
class CStreamHandler : public IStreamHandler
{
    friend class CDataStorage;
public:
    virtual ~CStreamHandler();
protected:
    CStreamHandler(FILE* file, String file_name);
    virtual bool Write(const void* buffer, size_t size);
    virtual bool Write(const Buffer& buffer);
    virtual bool FinishWriting();
    virtual void Release();

private:
    FILE* m_file;
    String m_name;
    bool m_isFinishWriting;
    NS_Common::CritSection m_sync;
};


class CDataStorage : public IDataStorage
{
public:
    virtual ~CDataStorage() { }
    CDataStorage(const String& profile);
    virtual bool Init(const String& base_path = "");
    virtual void Release();

    virtual IStreamHandler* CreateStream();

    virtual bool SavePrivateData(const String& key, const void* buffer, size_t size, bool profileSpecific = true);
    virtual bool SavePrivateData(const String& key, const Buffer& buffer, bool profileSpecific = true);
    virtual bool LoadPrivateData(const String& key, Buffer& buffer, bool profileSpecific = true);

    virtual bool RemovePrivateData(const String& key);

    virtual bool GetChildList(const String& key, StringArray& list, bool profileSpecific = true);

    virtual bool Exist(const String& key, bool profileSpecific = true);
    virtual const char* GetBasePath();

    virtual bool GetPrivateDataSize(const String& key, size_t& size, bool profileSpecific = true);
private:
    bool encryptAndSave(FILE* fin, const char* key, const void* buffer, size_t size);
    bool savePrivateData(const char* key, const void* buffer, size_t size);
    bool loadPrivateData(const char* key, void*& buffer, size_t& size);
    bool readBufferSize(const char* key, size_t& size);
    bool isPrivateDataFileType(const char* path);

    bool createPrivateDataPath(const char* key, bool profileSpecific = true);
    void tryRemovePrivateDataPath(const char* key);

    bool isCorrectDataPath(const char* path, const char* node);

    const String m_profile;
    String m_base_path;

    NS_Common::CritSection m_sync;
};

class CConfigurationStorage : public IConfigurationStorage
{
public:
    ~CConfigurationStorage();
    CConfigurationStorage();

    virtual bool Init();
    virtual void Release();

    /// functions for daemon's configuration
    virtual bool SaveConfiguration(const void* buffer, size_t size);
    virtual bool SaveConfiguration(const Buffer& buffer);
    virtual bool LoadConfiguration(Buffer& buffer);
private:
    IDataStorage* m_DataStorage;
};

}
}
