/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include <iostream>

#include <DaemonDM/TestingAPI.h>
#include "commontypes.h"
#include "platform.h"

#include "Errors.h"

#if defined PLATFORM_WINDOWS
	//NULL;
#else
	#include <sys/param.h>
	#include <getopt.h>

	const char* const c_clSmallOptions = "hg:u:d:";
	const struct option LongOptions[] =
	{
	{"help",       0,      NULL,       c_clSmallOptions[0]},
	{"get",        0,      NULL,       c_clSmallOptions[1]},
	{"user",       0,      NULL,       c_clSmallOptions[2]},
	{"device",     0,      NULL,       c_clSmallOptions[3]},
	{NULL,         0,      NULL,       0}
	};
#endif

//------------------------------------------------------------------------------------------------------

void print_usage(FILE* stream, const char* prog_name)
{
    fprintf(stream, "Usage: %s options \n", prog_name);
    fprintf(stream,
        "   -h      		--help              Display this usage information\n"
        "   -g uri  		--get uri           Get value from tree. Set uri of needed value in format: profile:uri \n"
        "   -u profile  	--user profile      Send request for user initiated firmvare update \n"
        "   -d profile  	--device profile   	Send request for device initiated firmvare update \n"
    );
}

//------------------------------------------------------------------------------------------------------

using namespace NS_DM_Client;

void CheckCommandLine(int argc, char** argv, TestingAPI& test)
{
#if defined PLATFORM_WINDOWS
	if (argc > 1)
	{
		char arg[2];
		arg[0] = argv[1][0];
		arg[1] = argv[1][1];
		
		if ((arg[0] == '-') && (arg[1] == 'g'))
		{
			String uri = argv[1];
			uri = uri.substr(2);
            
			fprintf (stdout, "requested uri:\n%s\n", uri.c_str());
            String result;
           StatusCode res = test.GetValueFromTree(uri, result);
            String res_status;
            if (res == e_Ok)
            {
				res_status = "success";
            }
            else if (res == e_NotFound)
            {
				res_status = "not found";
            }
            else
			{
				res_status = "failed";
            }
            fprintf (stdout, "result status:\n%s\n", res_status.c_str());
			if (res == e_Ok)
            {
				fprintf (stdout, "result:\n%s\n", result.c_str());
            }
		}
		else if ((arg[0] == '-') && (arg[1] == 'h'))
		{

		}
	}
#else
    int next_option;
	if (argc > 1)
    {
       do
        {
            next_option = getopt_long(argc, argv, c_clSmallOptions, LongOptions, 0);
            switch (next_option)
            {
                case 'h':
                {
                    print_usage(stdout, argv[0]);
                    break;
                }
                case 'g':
                {
                    String uri = optarg;
                    if (!uri.empty())
                    {
                        fprintf (stdout, "requested uri:\n%s\n", uri.c_str());
                        String result;
                        StatusCode res = test.GetValueFromTree(uri, result);
                        String res_status;
                        if (res == e_Ok)
                        {
                            res_status = "success";
                        }
                        else if (res == e_NotFound)
                        {
                            res_status = "not found";
                        }
                        else
                        {
                            res_status = "failed";
                        }
                        fprintf (stdout, "result status:\n%s\n", res_status.c_str());
                        if (res == e_Ok)
                        {
                            fprintf (stdout, "result:\n%s\n", result.c_str());
                        }
                    }
                    else
                    {
                        fprintf (stdout, "uri is empty. Fill correct argument list. Use -h for help\n");
                    }
                    break;
                }
                case 'u':
                {
                    String profile = optarg;
                    StatusCode res = test.RequestFirmwareUpdate(profile, true);
                    String res_status;
                    if (res == e_Ok)
                    {
                        sleep(2000);
                        res_status = "success";
                    }
                    else
                    {
                        res_status = "failed";
                    }
                    fprintf (stdout, "result status: %s\n", res_status.c_str());
                    break;
                }
                case 'd':
                {
                    String profile = optarg;
                    StatusCode res = test.RequestFirmwareUpdate(profile, false);
                    String res_status;
                    if (res == e_Ok)
                    {
                        sleep(2000);
                        res_status = "success";
                    }
                    else
                    {
                        res_status = "failed";
                    }
                    fprintf (stdout, "result status: %s\n", res_status.c_str());
                    break;
                }                
				default:
                {
                    fprintf (stdout, "No valid command line argument. Use -h for help\n");
                    break;
                }
            }

            // only one parameter may be in command line
            exit(EXIT_SUCCESS);
        }
        while (next_option != -1);
    }
#endif

}

//------------------------------------------------------------------------------------------------------

int main(int argc, char** argv)
{
    TestingAPI test;
    if (test.Start())
    {
        CheckCommandLine(argc, argv, test);

		/*
                    String uri = "WiMAX_Profile:./DevDetail/OEM";
                    if (!uri.empty())
                    {
                        fprintf (stdout, "requested uri: %s \n", uri.c_str());
                        String result;
                        StatusCode res = test.GetValueFromTree(uri, result);
                        String res_status;
                        if (res == e_Ok)
                        {
                            res_status = "success";
                        }
                        else if (res == e_NotFound)
                        {
                            res_status = "not found";
                        }
                        else
                        {
                            res_status = "failed";
                        }
                        fprintf (stdout, "result status: %s \n", res_status.c_str());
                        if (res == e_Ok)
                        {
                            fprintf (stdout, "result: %s \n", result.c_str());
                        }
                    }
                    else
                    {
                        fprintf (stdout, "uri is empty. Fill correct argument list. Use -h for help\n");
                    }

			*/
    }
    else
    {
        fprintf (stdout, "can't start testing API. Daemon not alive or some internal error \n");
    }
    return 0;
}
