/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include <stddef.h>

#include "DaemonDM/UserInteractionDefs.h"
#include "IFIFOWrapper.h"

#include "DaemonDM/IPCExchangeDefs.h"

namespace NS_DM_Client
{

extern const char* const c_MessageListenerLog;
extern const char* const c_DaemonIPCEngineLog;

extern const char* c_StopRequest;
extern const size_t c_StopRequestSize;

extern const char* c_messageRequestFifoName;
extern const char* c_messageResponseFifoName;

extern const char* c_IPCRequestFifoName;
extern const char* c_IPCResponseFifoName;

struct UIExchangeHead
{
    UIExchangeHead()
    {
    }

    UIExchangeHead(UIMessageType type, size_t payload_size)
    {
        m_type = type;
        m_payload_size = payload_size;
    }

    UIMessageType m_type;
    size_t m_payload_size;
};

struct UIResponseExchangeHead
{
    UIResponseExchangeHead()
    {
    }

    UIResponseExchangeHead(StatusCode perform_code, size_t payload_size)
    {
        m_perform_code = perform_code;
        m_payload_size = payload_size;
    }

    StatusCode m_perform_code;
    size_t m_payload_size;
};

bool initializeFifos(IFIFOWrapper*& request, IFIFOWrapper*& response, bool stop_listening = false, bool serverSide = false);
bool initializeIPCFifos(IFIFOWrapper*& request, IFIFOWrapper*& response, bool stop_listening = false, bool serverSide = false);
bool releaseFifos(IFIFOWrapper* request, IFIFOWrapper* response);

bool formPayloadFromOptPars(const UIOptionalParameters& pars, String& payload, bool allowMultipleChoise = true);
bool formOptParsFromPayload(const String& payload, UIOptionalParameters& pars, bool* allowMultipleChoise = 0);

bool get_MINDT(const UIOptionalParameters& pars, long& min_dt);
bool get_MAXDT(const UIOptionalParameters& pars, long& max_dt);
bool get_DR(const UIOptionalParameters& pars, String& def_val);
bool get_MAXLEN(const UIOptionalParameters& pars, long& max_len);
bool get_IT(const UIOptionalParameters& pars, String& input_type);
bool get_ET(const UIOptionalParameters& pars, bool& echo_password);

bool formComplexRequestPayload(
    const String& message, const String& pars, const String& choises, const String& downloads, void*& payload, size_t& payload_size);
bool formComplexRequest(UIMessageType type, void* payload, size_t payload_size, void*& request, size_t& request_size);

bool extractComplexRequestPayload(const void* payload, size_t payload_size,
    String& message, String& pars, String* choises = 0, String* downloads = 0);

bool formChoiseSet(const UserAvialableChoiseSet& choise_set, String& choises);
bool extractChoiseSet(const String& choises, UserAvialableChoiseSet& choise_set);
bool getNumericUserChoise(const String& avialable_choises, const String& user_choises, UserChoiseSet& choise_set);
bool formStringFromNumericUserChoise(const UserChoiseSet& choise_set, String& str_choise);
bool formNumericUserChoiseFromString(const String& str_choise, UserChoiseSet& choise_set);

void deleteMemory(void* memory);

}
