/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "commontypes.h"

namespace NS_DM_Client
{
	extern const char* S_msgTypeDescription[];
	extern const char* S_msgSubTypeDescription[];

	enum MsgType
	{
		e_open = 0,
		e_close,
		e_get,
		e_set,
		e_clientProfiles,
		e_startDMSession,
		e_notifyDMSession,
		e_checkFirmwareUpdate,
		e_notifyFirmwareUpdate,
		e_notifyProvisioningUpdate,
		e_status, // if "e_status" - subtype is used for status's value
		e_collectDRMD,
		e_readyDRMD,
		e_networkEntry
	};

	enum MsgSubType
	{
		e_devInfo = 0,
		e_devDetail,
		e_DMAcc,
		e_WiMAX,
		e_WiMAXSupp,
		e_WiMAX_Diagnostics,
		e_clientProfileName,
		e_EMSK,
		e_DeviceID,
		e_none,
		e_okStatus, // for status
		e_failedStatus, // for status
		e_stopWaitingStatus, // for status

		e_FirmwareDownload,
		e_FirmwareUpdate,
		e_FirmwareDownloadAndUpdate

	};

	typedef unsigned char byte;

	struct Message
	{
		Message(size_t id, size_t msgType, size_t msgSubType, const String& data = "");
		Message(size_t id, size_t msgType, size_t msgSubType, const std::vector<byte>& data);
		Message() {};

		void SetData(void* buffer, size_t size);
		static size_t GetHeaderSize();
		static size_t GetDataSize();

		size_t m_id;
		size_t m_type;
		size_t m_subType;
		std::vector<byte> m_data;
		//String m_data;
	};

	void BytesToString(const std::vector<byte>& bytes, String& str);
	void StringToBytes(const String& str, std::vector<byte>& bytes);
}
