/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include "GetMgmtTreeCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "ManagementObjects/IMgmtObject.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{
	GetMgmtTreeCommand::GetMgmtTreeCommand(ProfileComponentsHolder* holder, const String& uri, String& mgmtTree, 
		NS_Common::EventEx* executionCompleted, bool& executionResult): 
		IMOTreeCommand(holder, 0, executionCompleted, executionResult), m_uri(uri), m_mgmtTree(mgmtTree)
	{
	}
	//-------------------------------------------------------------------------------------------

	bool GetMgmtTreeCommand::run(IMOTreeManager& treeManager)
	{
		NS_DM_Client::IMOTreeManager::RequiredProperties reqPropetries;

		reqPropetries.push_back(e_TNDS_format);
		reqPropetries.push_back(e_TNDS_tstamp);
		reqPropetries.push_back(e_TNDS_title);
		reqPropetries.push_back(e_TNDS_value);
		reqPropetries.push_back(e_TNDS_type);
		reqPropetries.push_back(e_TNDS_ACL);
		reqPropetries.push_back(e_TNDS_name);

		Funambol::StringBuffer* xml = 0;
		NS_DM_Client::StatusCode res = treeManager.GetAttributeTNDS(m_uri, reqPropetries, xml);
		if (res == NS_DM_Client::e_Ok)
		{
			m_mgmtTree = xml->c_str();
			return true;
		}
		return false;
	}

}
