/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include "SynchRunThread.h"
#include "Message.h"
#include "../clientadapterproxy/ClientAdapterProxy.h"
#include "ClientAdapter/INotificationUpdater.h"
#include "ManagementObjects/DevInfo.h"
#include <iostream>

SynchRunThread::SynchRunThread(NS_DM_Client::ClientAdapterProxy& proxy, size_t requestType, size_t requestSubType, 
							   void* mgmtObject): 	m_proxy(proxy), m_requestType(requestType), 
							   m_requestSubType(requestSubType), m_mgmtObject(mgmtObject)
{
}
//-------------------------------------------------------------------------------------------

SynchRunThread::SynchRunThread(NS_DM_Client::ClientAdapterProxy& proxy, size_t requestType, size_t requestSubType, 
							   const std::string& tndsMgmtObject): 	m_proxy(proxy), m_requestType(requestType), 
							   m_requestSubType(requestSubType), m_mgmtObject(0), m_tndsMgmtObject(tndsMgmtObject)
{
}
//-------------------------------------------------------------------------------------------

void SynchRunThread::run()
{
	bool res = false;
	switch (m_requestType)
	{
	case NS_DM_Client::e_open:
		res = m_proxy.Open();
		break;
	case NS_DM_Client::e_close:
		res = m_proxy.Close();
		break;
	case NS_DM_Client::e_set:
		{
			switch (m_requestSubType)
			{
			case NS_DM_Client::e_devInfo:
				if (m_mgmtObject)
				{
					res = m_proxy.SetDeviceInfo(*(reinterpret_cast<NS_DM_Client::DevInfo*>(m_mgmtObject)));
				}
				else
				{
					res = m_proxy.SetMgmtTree(NS_DM_Client::e_MODevInfo, m_tndsMgmtObject);
				}
				break;
			case NS_DM_Client::e_clientProfileName:
				res = m_proxy.SwitchClientProfile("ProfileName");
				break;
			}
			break;
		}
	case NS_DM_Client::e_get:
		{
			switch (m_requestSubType)
			{
			case NS_DM_Client::e_devInfo:
				{
					if (m_mgmtObject)
					{
						NS_DM_Client::DevInfo* devInfo = reinterpret_cast<NS_DM_Client::DevInfo*>(m_mgmtObject);
						res = m_proxy.GetDeviceInfo(*devInfo);
					}
					else
					{
						//res = m_proxy.GetMgmtTree(NS_DM_Client::e_MODevInfo, m_tndsMgmtObject);
					}
					break;
				}
			}
			break;
		}
	case NS_DM_Client::e_clientProfiles:
		{
			std::vector<NS_DM_Client::ClientProfileInfo>* profiles = 
				reinterpret_cast<std::vector<NS_DM_Client::ClientProfileInfo>*>(m_mgmtObject);
			res = m_proxy.GetClientProfiles(*profiles);
			break;
		}
	case NS_DM_Client::e_checkProvision:
		{
			NS_DM_Client::INotificationUpdater* updater = 
				reinterpret_cast<NS_DM_Client::INotificationUpdater*>(m_mgmtObject);
			res = m_proxy.CheckForProvisionUpdate(updater);
			break;
		}
	case NS_DM_Client::e_notifyProvision:
		{
			NS_DM_Client::INotificationUpdater* updater = 
				reinterpret_cast<NS_DM_Client::INotificationUpdater*>(m_mgmtObject);
			res = m_proxy.NotifyProvisionUpdate(updater);
			break;
		}
	default:
		break;
	}
 	if (res)
 		std::cout << "	Success" << std::endl;
 	else
 		std::cout << "	ERROR!!!" << std::endl;
}


