/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include <boost/shared_ptr.hpp>
#include <base/util/StringBuffer.h>
#include <syncml/core/AbstractCommand.h>
#include <syncml/core/ItemizedCommand.h>
#include <syncml/core/Alert.h>
#include <syncml/core/Add.h>
#include <syncml/core/Atomic.h>
#include <syncml/core/Copy.h>
#include <syncml/core/Delete.h>
#include <syncml/core/Exec.h>
#include <syncml/core/Get.h>
#include <syncml/core/Replace.h>
#include <syncml/core/Results.h>
#include <syncml/core/Sequence.h>
#include <syncml/core/Status.h>
#include <vector>
#include "commontypes.h"

namespace NS_DM_Client
{
	/// Shared pointer to message
	typedef boost::shared_ptr<class Funambol::ItemizedCommand> ItemizedCommandPtr;
	typedef boost::shared_ptr<class Funambol::AbstractCommand> AbstractCommandPtr;

	typedef boost::shared_ptr<class Funambol::Alert>	AlertPtr;
	typedef boost::shared_ptr<class Funambol::Add>		AddPtr;
	typedef boost::shared_ptr<class Funambol::Atomic>	AtomicPtr;
	typedef boost::shared_ptr<class Funambol::Copy>		CopyPtr;
	typedef boost::shared_ptr<class Funambol::Delete>	DeletePtr;
	typedef boost::shared_ptr<class Funambol::Exec>		ExecPtr;
	typedef boost::shared_ptr<class Funambol::Get>		GetPtr;
	typedef boost::shared_ptr<class Funambol::Replace>	ReplacePtr;
	typedef boost::shared_ptr<class Funambol::Results>	ResultsPtr;
	typedef boost::shared_ptr<class Funambol::Sequence>	SequencePtr;
	typedef boost::shared_ptr<class Funambol::Status>	StatusPtr;


	namespace NS_SyncMLCommand
	{
		typedef boost::shared_ptr<class SCommandAdapter> SCommandPtr;
		typedef std::vector<SCommandPtr> SCommandsArray;

		class SCommandAdapter
		{
		public:
			typedef unsigned int CommandID;
			typedef enum {
				New,
				Sent,
				Processed,
				NoConnection,
				WrongAuthentication // on err 212
			} Status;

			SCommandAdapter();
			SCommandAdapter(const char *msgid, AbstractCommandPtr origcmd);
			virtual ~SCommandAdapter();


			/// Get the SyncML string of the message
			///
			/// Returned StringBuffer instance should be deleted by the caller
			virtual Funambol::StringBuffer * ToString();

			/// Set command's status
			///
			/// Status is set after message has been processed by the server
			void SetStatus(Status s) { m_status = s; };

			/// Get commnd's status
			Status GetStatus() { return m_status; };

			/// Set command reference of the command
			void SetCmdID(const char *);
			const char * GetCmdID() { return m_cmdid; };

			void SetMessageID(const char *);
			const char * GetMessageID() { return m_msgid; };

			/// Create specific instance of AbstractCommand class
			void Prepare();

			/// Get shared pointer to instance of ItemizedCommand.
			///
			/// Shared pointer could contain NULL object, if Prepare was not called before
			ItemizedCommandPtr Internal() { return m_ptrItemizedCommand; }

			/// Set originated command, of this one
			void SetOriginatedCommand(AbstractCommandPtr ocmd) { m_ptrOriginatedCommand = ocmd; };
			AbstractCommandPtr GetOriginatedCommand() { return m_ptrOriginatedCommand; };


		protected:
			ItemizedCommandPtr m_ptrItemizedCommand;
			AbstractCommandPtr m_ptrOriginatedCommand;
			char *m_cmdid;
			char *m_msgid;

			virtual void createItemizedCommand() = 0;

		private:
//			CommandID m_commandID;
			Status    m_status;
//			String    m_messageid;
			uint      m_msgLength;
		};
	}
}
