/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <syncml/core/ItemizedCommand.h>
#include <syncml/core/SyncML.h>
#include <syncml/core/Add.h>
#include <syncml/core/Alert.h>
#include <syncml/core/Atomic.h>
#include <syncml/core/Copy.h>
#include <syncml/core/Delete.h>
#include <syncml/core/Exec.h>
#include <syncml/core/Get.h>
#include <syncml/core/Replace.h>
#include <syncml/core/Results.h>
#include <syncml/core/Sequence.h>
#include <syncml/core/Status.h>

#include "ConnectionInfo.h"
#include "treemanager/ActionCommand.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/session/ISession.h"
#include "serverexchange/wrappers/CommandsSinkHolder.h"


namespace NS_DM_Client
{
	namespace NS_Communication
	{
		class LOCollector;
		class Connection;
		
		/// Class implements processing of the SyncML DM message. XML document is parsed by the internals
		/// of the Funambol SDK. Corresponding processor is created for every command received from server.
		/// Receiving of LO is implemented as well.
		class ResponseProcessor : public NS_SyncMLCommand::CommandsSinkHolder
		{
		public:
			typedef enum {
				PS_Successful,
				PS_MalformedMessage,
				PS_InvalidServerCred,
				PS_InvalidParam
			} ProcessingStatus;

		public:

			ResponseProcessor(ConnectionInfo &, NS_SyncMLCommand::ICommandsSink *, ProfileComponentsHolder *);
			~ResponseProcessor();

			ProcessingStatus Process(const char * xmlresponse, bool sumode = false);

			bool LastResponseFound()                { return m_sessionFinished; };
			void SetSession(ISession &s)            { m_pSession = &s;	        };
			void SetCheckForCred(bool check)        { m_checkForCred = check;   };
			void SetPCH(ProfileComponentsHolder &p) { m_pPCH = &p;              };
			
		private:
			bool                     m_sessionFinished;
			bool                     m_checkForCred;
			bool                     m_changeAuthType;
			char                    *m_cServerID;
			unsigned int             m_responseCommandsCount;
			
			// TODO - do not store local copy
			ConnectionInfo          *m_pConnInfo;
			ISession                *m_pSession;
			
			Funambol::SyncML        *m_pSyncML;
			LOCollector             *m_pLOCollector;
			ProfileComponentsHolder *m_pPCH;

			ResponseProcessor(const ResponseProcessor&);

			void checkForNextChunkData();
			bool commandHasLOChunk(Funambol::ItemizedCommand *cmd);

			void enqueueExCommand    (ActionCommand &);
			void processHeader    ();
			void processCommand	  (Funambol::AbstractCommand *cmd); 

			void processAdd       (Funambol::Add      *cmd);
			void processAtomic    (Funambol::Atomic   *cmd);
			void processCopy      (Funambol::Copy     *cmd);
			void processDelete    (Funambol::Delete   *cmd);
			void processExec      (Funambol::Exec     *cmd);
			void processGet       (Funambol::Get      *cmd);
			void processReplace   (Funambol::Replace  *cmd);

			void processAlert     (Funambol::Alert    *cmd);
			void processResults   (Funambol::Results  *cmd);
			void processSequence  (Funambol::Sequence *cmd);
			void processStatus    (Funambol::Status   *cmd);

			int  processLOChunk   (Funambol::ItemizedCommand *cmd);
			void initProcessing   (bool sumode, int commandsCount);
		};
	}
}

