/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "serverexchange/wrappers/SCommandAdapter.h"

namespace NS_DM_Client
{
    namespace NS_SyncMLCommand
    {
    	/**
    	 * Class is able to represent one Funambol::Results message with large binary object or
    	 * multiple items as a sequence of Results objects where large object is divided into smaller chunks
    	 * and multiple items are spread in.
    	 */
        class LOResults
        {
        public:
			/**
			 * @param results Results object which should be separated into smaller parts
			 * @param resultMaxSize sets the max size of the Results message including binary
			 *        data and <MoreData/> tag, if required
			 */
			LOResults(ResultsPtr results, unsigned int resultMaxSize, unsigned int maxObjSize);
			~LOResults();

			/**
			 * Check if all parts, the initial message was devided to, have been retrived from the class.
			 */
			bool HasAllChunksCreated();

			/**
			 * Returns size of the next chunk (Results command) with no Data payload inserted.
			 */
			unsigned int GetNextChunkEmptySize();

			/**
			 * Retrive next chunk of the initial Results message.
			 * If returned shared pointer contains NULL, all chunks have alrady been retrived.
			 * @param maxSize sets the max size of the data to be inserted into the Data section in the Item
			 * @return shared pointer to next Results
			 **/
			ResultsPtr GetNextChunk(const char * cmdid, int maxSize);

		private:
			bool         m_firstChunk;		// indicates whether the first chunk is being prepared
			int          m_curritemindex;	// index of item in the Results items list
			int          m_maxsize;
			const int    m_maxobjsize;		// max size of binary data to be set into the Data section
			int          m_buffersize;		// size of the data buffer allocated for the LO
			int          m_bufferpos;		// carret position within the data buffer
			const char * m_buffer;			// buffer with data to be split into the parts
			ResultsPtr   m_rescmd;			// initial Results command with LO inside it
			Funambol::ArrayList *m_items;

			Funambol::Meta * getMetaFrom(Funambol::Item &item);
        };
    }
}

