/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "executionqueue/ICommand.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/commands/AlertCodes.h"
#include "serverexchange/wrappers/SAlertCommand.h"
#include "NotificationListener/SessionInfo.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;

	namespace NS_Common {
		class Event;
	}

	namespace NS_Communication {
		class ConnectionInfo;
		class IConnection : public NS_SyncMLCommand::ICommandsSink
		{
		public:
			virtual ~IConnection() {};

			virtual void Abort() = 0;

			virtual ConnectionInfo & Info() = 0;
			virtual bool IsRunning() = 0;

			virtual void NotifySessionStarted() = 0;

			virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo) = 0;
			virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data) = 0;

			virtual void SetPCH(ProfileComponentsHolder &) = 0;

			virtual void Start(NS_Common::Event *e = NULL) = 0;
			virtual void StartSession(const NS_SyncMLCommand::AlertCode ac = NS_SyncMLCommand::AC_CLIENT_INITIATED_MGMT) = 0;
			virtual void StartSession(NS_SyncMLCommand::SAlertCommandPtr) = 0;
			virtual void Stop() = 0;

			virtual void Wait() = 0;
		};

		typedef boost::shared_ptr<IConnection> ConnectionPtr;
	}
}

