/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <platform.h>
#include <vector>

#include <commontypes.h>

namespace NS_DM_Client
{

namespace NS_NotificationListener
{

    class NotificationMessage
    {
    public:
        NotificationMessage();
        ~NotificationMessage();

        enum HeaderSize
        {
            HEADER_SIZE  = 24
        };

        bool    SetMessage(const void*  msg, size_t size);

        typedef buffer_t diggest_t;
        bool    CheckDiggest() const;

        enum
        {
            VERSION = 0x0B  // 0000001011
        };

        int                 GetVersion() const;

        enum EnumUIMode
        {
            e_UI_NotDefined         =   0x00,
            e_UI_Background         =   0x01,
            e_UI_Informative        =   0x02,
            e_UI_UserInteraction    =   0x03
        };
        EnumUIMode      GetUIMode() const;

        enum EnumInitiator
        {
            e_InitiatorClient   = 0,
            e_InitiatorServer   = 1
        };
        EnumInitiator   GetInitiator() const;

        typedef unsigned short  session_id_t;
        session_id_t    GetSessionID() const;
        bool            GetSessionID(String& sessionID) const;

        const char*     GetServerID() const;

        typedef std::vector<char>   body_t;
        bool    HasBody() const;
        bool    GetBody(body_t& body) const;

    private:
        size_t          getServerIDLength() const;
        const char*     getServerIDRef() const;

    private:
        buffer_t   m_message;
    #ifdef PLT_BIG_ENDIAN
        buffer_t&  m_header;
    #else
        buffer_t   m_header;
    #endif

        diggest_t      m_diggest;
        String         m_server_id;
    };

}

}
