/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */ 

#pragma once

#include "commontypes.h"
#include "IMgmtObject.h"

namespace NS_DM_Client
{
	class IMOTreeManager;
	class TNDSCreator;
	class TNDSExtractor;

	struct MANAGEMENTOBJECTS_API SPLock
	{
		SPLock(): m_LockStatus(0), m_VerNbr(0) {}

		size_t m_LockStatus;
		String m_Operator;
		size_t m_VerNbr;
		String m_Lock; 

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API WiMAXRadioModule 
	{
		String m_Man;
		String m_Mod;
		String m_FwV;
		String m_HwV;
		String m_SwV;
		String m_MACAddress;
		//SPLock m_SPLock;
		String m_TO_FUMO_REF;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API TerminalEquipment 
	{
		String m_DevID;
		String m_DevTyp;
		String m_Man;
		String m_Mod;
		String m_FwV;
		String m_HwV;
		String m_SwV;
		// Ext and Bearer are not supported

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API IPCap
	{
		IPCap(): m_IPV4(0), m_IPV6(0), m_CMIPV4(0), m_CMIPV6(0) {}

		size_t m_IPV4;
		size_t m_IPV6;
		size_t m_CMIPV4;
		size_t m_CMIPV6;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API ClientInitiated
	{
		ClientInitiated(): m_PollingSupported(0), m_PollingInterval(0) {}

		bool m_PollingSupported;
		size_t m_PollingInterval;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API UpdateMethods
	{
		UpdateMethods(): m_ServerInitiated(0) {}

		size_t m_ServerInitiated;
		ClientInitiated m_ClientInitiated;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API DevCap
	{
		IPCap m_IPCap;
		UpdateMethods m_UpdateMethods;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	class MANAGEMENTOBJECTS_API WiMAX: public IMgmtObject
	{
	public:
		std::vector<WiMAXRadioModule> m_WiMAXRadioModule;
		TerminalEquipment m_TerminalEquipment;
		String m_TO_WiMAX_REF;
		DevCap m_DevCap;

	public:
		virtual bool Serialize(IMOTreeManager& treeManager) const;
		virtual bool Deserialize(IMOTreeManager& treeManager);

		virtual bool Serialize(String& xml) const;
		virtual bool Deserialize(const String& xml);
	};
}
