/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "DeviceAdapter/IDeviceAdapter.h"
#include "commontypes.h"

namespace NS_DM_Client
{
	class IWiMAXDevice;
	class MOTreeManager;
	struct NetworkParameters;
	struct Contacts;
	struct RootCA;
	struct SubscriptionParameters;
	struct CAPLEntries;
	struct ChannelPlan;
	struct RAPL;
	struct OtherSubscriptions;
	struct Primary;
	struct EAP;

	class DummyDeviceAdapter: public IDeviceAdapter
	{
	public:
		DummyDeviceAdapter();
		virtual ~DummyDeviceAdapter();

		virtual bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0);

		virtual bool Open();
		virtual bool Close();
		virtual void Release();

		virtual bool GetDeviceInfo(DevInfo& deviceInfo);
		virtual bool GetDeviceDetail(DevDetail& deviceDetail);
		virtual bool GetDMAccount(DMAcc& dmAccount);
		virtual bool GetWiMAX(WiMAX& wimax);
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp);

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo);
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail);
		virtual bool SetDMAccount(const DMAcc& dmAccount);
		virtual bool SetWiMAX(const WiMAX& wimax);
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp);

		virtual EnumFirmwareStatus InitFirmwareStorage(const char* packageName = 0, const char* location = 0);
		virtual EnumFirmwareStatus ResetFirmwareStorage();
		virtual EnumFirmwareStatus AppendFirmwareChunk(const char* buffer, size_t size, bool last);
		virtual EnumFirmwareStatus UpdateFirmware();

		virtual bool SetEMSK(const void*, size_t size);
		virtual bool GetEMSK(void*, size_t& size);

		virtual bool SetDeviceID(const void*, size_t size);
		virtual bool GetDeviceID(void*, size_t& size);

		virtual bool GetNetworkInterfaceName(char*, size_t& size);

	private:
		bool initFirmwareUpdater(const char* defFWPackageName, const char* defFWPackageLocation,
			bool noCleanStorage, bool fwUpdateFailure);
		void setFirmwareUpdater(IFirmwareUpdater* fu);

		virtual bool getEMSKfromCustomSource(void*, size_t& size);

	private:
		NS_Logging::Logger& m_logger;
		IFirmwareUpdater*	m_fwUpdater;

		String	m_EMSKSource;
		std::vector<byte> m_EMSKBuffer;
		String	m_deviceID; // e.g. MAC-address

		String	m_networkIFName; // system network interface name assosiated with the device
	};
}
