// DEB DynamicGrid Actions定义
DBE.DynamicGridActions = function(dyGrid) {
	/**
	 * 复制表格内容（选择行）到剪贴板
	 */
	this.copyToClipboard = new Ext.Action({
		text : LocaleLang.copyToClipboard,
		iconCls : 'copy',
		scope : this,
		handler : function() {
			var records = dyGrid.getSelectionModel().getSelections();
			// copyRecords(records, false);
			if (records && records.length) {
				// 生成数据
				var data = "";
				for (var i = 0; i < records.length; i++) {
					var rd = records[i];
					if (data.length > 0) {
						data += "\n";
					}
					var newLine = true;
					for (x in rd.data) {
						//
						if (newLine) {
							newLine = false;
						} else {
							data += ",";
						}
						data += rd.data[x];
					}
				}
				// copy...
//				DBE.copyToClipboard(data);
				client.setText(data);
				Ext.Msg.info({
					message : "[" + records.length + " " + LocaleLang.rowsCopiedToClipboard
				});
			} else {
				Ext.Msg.info({
					message : LocaleLang.noRowsSelected
				});
			}
		}
	});
	/**
	 * 复制单元格内容到剪贴板
	 */
	this.copyCellToClipboard = new Ext.Action({
		text : LocaleLang.copyCellToClipboard,
		iconCls : 'copy',
		scope : dyGrid,
		handler : function() {
			var e = this.cellRightMenuEventObject;
			if (e.isRightClick && !e.isHeaderRightClick) {
				var cellName = this.getColumnModel().getColumnHeader(e.cellIdx);
				// alert(cellName);
				var record = this.store.getAt(e.rowIdx);
				var data = record.data[cellName];
//				DBE.copyToClipboard(data);
				client.setText(data);
				Ext.Msg.info({
					message : '[' + data + '] ' + LocaleLang.cellsCopiedToClipboard
				});
			}
		}
	});
	/**
	 * 复制列数据到剪贴板
	 */
	this.copyColumnToClipboard = new Ext.Action({
		text : LocaleLang.copyColumnToClipboard,
		iconCls : 'copy',
		scope : dyGrid,
		handler : function() {
			var e = this.cellRightMenuEventObject;
			if (e.isRightClick) {
				var cellName = this.getColumnModel().getColumnHeader(e.cellIdx);
				// alert(cellName);

				var records = this.store.getRange();
				var data = "";
				for (var i = 0; i < records.length; i++) {
					if (data.length > 0) {
						data += "\n";
					}
					var record = records[i];
					data += record.data[cellName];
				}

//				DBE.copyToClipboard(data);
				client.setText(data);
				Ext.Msg.info({
					message : '[' + cellName + LocaleLang.columnsCopiedToClipboard
				});
			}
		}
	});
	/**
	 * 复制列头到剪贴板
	 */
	this.copyColumnHeaderToClipboard = new Ext.Action({
		text : LocaleLang.copyColumnHeaderToClipboard,
		iconCls : 'copy',
		scope : dyGrid,
		handler : function() {
			var cm = this.getColumnModel();
			var data = "";
			for (var i = 0; i < cm.getColumnCount(); i++) {
				if (i > 1) {// 跳过第0/1 序号/选择框
					if (data.length > 0) {
						data += ",";
					}
					data += cm.getColumnHeader(i);
				}
			}
//			DBE.copyToClipboard(data);
			client.setText(data);
			Ext.Msg.info({
				message : LocaleLang.columnHeaderCopiedToClipboard
			});
		}
	});
	/**
	 * 数据导出
	 */
	this.dataExport = new Ext.Action({
		text : LocaleLang.exportData,
		iconCls : 'export',
		handler : function() {
			// alert("数据导出~~》:" + DBE.DataExport);
			var paging = dyGrid.getPagingInfo();
			var baseParams = null;
			if (dyGrid.nodeInfo) {
				baseParams = {
					node : dyGrid.nodeInfo.id,
					text : dyGrid.nodeInfo.text,
					path : dyGrid.nodeInfo.getPath('text')
				}
			} else if (dyGrid.sqlText && dyGrid.sqlText.length > 0) {
				baseParams = {
					sql : dyGrid.sqlText
				}
			} else {
				alert(LocaleLang.nodeInfoInvalid);
				return;
			}

			var dataExport = new DBE.DataExport({
				tableinfo : dyGrid.initialConfig.tableinfo,
				pagingInfo : paging,
				baseParams : baseParams
			});
			dataExport.show(dyGrid, function() {
				// 自动计算高度，并重设窗口高度..
				var height = this.reCalculateHeight();
				// alert("height:" + height);
				this.setHeight(height);
				this.center();
				this.getLayout();
			}, dataExport);
		}
	});

	/**
	 * 刷新：重新读取Grid数据
	 */
	this.refresh = new Ext.Action({
		text : LocaleLang.refresh,
		tooltip : LocaleLang.refreshData,
		tooltipType : 'title',
		iconCls : 'refresh',
		handler : function() {
			dyGrid.store.reload();
		}
	});
};
