// 大字段显示窗口定义
DBE.CLobPanel = function(config, lobWindow) {
	// CLOB资源路径
	var filePath = false;
	if (config.name && !config.isNull) {
		// filePath = "../dbeAction/readfile.do?targetFile=";
		filePath = "../control/downfile?targetFile=";
		filePath += config.name;
	}
	// save Action
	var action = new Ext.Action({
		text : LocaleLang.save,
		scope : this,
		disabled : true,
		handler : function() {
			// alert('save...');
			var clob = this.getTextare().getValue();
			if (clob != this.clobValue) {
				// alert('update..');
				var params = config.param;
				params.clob = clob;
				Ext.Ajax.request({
					url : '../control/gridUpdateclob',
					params : params,
					scope : this,
					success : function(response) {
						// alert('save ok~.');
						this.clobValue = clob;
						refreshSaveActionStat();
						// alert('保存成功~~..');
						Ext.Msg.info({
							message : LocaleLang.saveComplete,
							alignRef : lobWindow.getId(),
							alignType : 'tl-tr?'
						});
					},
					failure : function(response) {
						var json = response.responseText;
						alert(LocaleLang.saveClobError + json);
					}
				});
			}
		}
	});
	var refreshSaveActionStat = (function() {
		var value = this.getTextare().getValue();
		// alert(value + "--> " + this.clobValue);
		action.setDisabled(value == this.clobValue);
	}).createDelegate(this);

	// textarea
	var textArea = new Ext.form.TextArea({
		id : 'textCLOB',
		disabled : true,
		value : 'Reading...',
		enableKeyEvents : true,
		listeners : {
			keypress : {
				scope : this,
				fn : function(textarea, objEvent) {
					refreshSaveActionStat.defer(100);
				}
			},
			change : function(textarea, newValue, oldValue) {
				action.setDisabled(false);
			}
		}
	});

	// 准备配置参数..
	var cfg = {
		layout : 'fit',
		width : 10,
		height : 10,
		plain : true,
		frame : false,
		border : false,
		items : textArea,
		keys : [{
			key : [Ext.EventObject.BACKSPACE, Ext.EventObject.DELETE],
			fn : function(key, eventObj) {
				refreshSaveActionStat.defer(100);
			}
		}],
		bbar : ['->', {
			text : LocaleLang.download,
			handler : function() {
				if (!config.isNull) {
					if (filePath) {
						DBE.downfile(filePath);
					} else {
						alert(LocaleLang.filePathInvalid);
					}
				} else {
					alert(LocaleLang.columnIsNull);
				}
			}
		}, action]
	};
	// call父类构建器
	DBE.CLobPanel.superclass.constructor.call(this, cfg);

	// 公布属性
	this.filePath = filePath;// 资源文件路径
	this.clobValue = "";// 源clob内容..
}
Ext.extend(DBE.CLobPanel, Ext.Panel, {
	getTextare : function() {
		return this.items.get(0);
	},
	init : function() {
		// 设置窗口大小
		var size = Ext.getBody().getSize(true);
		size.width = size.width / 2;
		size.height = size.height / 2;
		this.setSize(size);

		// 读取CLOB数据
		var wait = Ext.Msg.wait(LocaleLang.loading, LocaleLang.waitAWhile);
		var textareCLOB = this.getTextare();
		if (this.filePath) {
			var url = this.filePath;
			Ext.Ajax.request({
				url : url,
				scope : this,
				success : function(resp, opt) {
					var json = resp.responseText;
					this.clobValue = json;// 记录源内容
					if (textareCLOB) {
						textareCLOB.setValue(json);
						textareCLOB.setDisabled(false);
						textareCLOB.focus(false, 100);
					} else {
						alert(LocaleLang.textAreaIsNull);
					}
					wait.hide();
				},
				failure : function(resp, opt) {
					var json = resp.responseText;
					wait.hide();
					alert(LocaleLang.saveClobError + json);
				}
			});
		} else {
			textareCLOB.setValue("");
			textareCLOB.setDisabled(false);
			textareCLOB.focus(false, 100);
			wait.hide();
		}
	}
});