package cn.com.qimingx.dbe.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.base.util.FileUtil;
import org.ofbiz.base.util.UtilGenerics;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Controller;
//import org.springframework.util.FileCopyUtils;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.DBConnectionState;
import cn.com.qimingx.dbe.GridOperator;
import cn.com.qimingx.dbe.action.bean.DataExportBean;
import cn.com.qimingx.dbe.action.bean.GridTableFieldInfoBean;
import cn.com.qimingx.dbe.action.bean.GridTableLoadBean;
import cn.com.qimingx.dbe.action.bean.GridTableLongFieldInfoBean;
import cn.com.qimingx.dbe.action.bean.GridTableUpdateBean;
import cn.com.qimingx.dbe.action.bean.PkColumnObject;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.dbe.service.WorkDirectory;

/**
 * @author Wangwei
 * 
 * 用于提供 DataGridPanel 相关的功能Action
 */
//@Controller("dbeGridAction")
public class DbeGridActionController extends AbstractDbeActionController {
	// logger
	private static final Log log = LogFactory
			.getLog(DbeGridActionController.class);

	// Grid操作实现对象
	private static GridOperator gridOperator = new GridOperator();

	public static void load(HttpServletRequest req, HttpServletResponse resp) {
		GridTableLoadBean param = getGridTableLoadBean(req);
		load(req, resp, param);
	}

	// 装载指定元素的数据
	public static void load(HttpServletRequest req, HttpServletResponse resp,
			GridTableLoadBean param) {
		log.debug("call dbeGridAction.load,param:" + param);

		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		//
		DBInfoService service = prDBCS.getData().getDBInfoService();
		ProcessResult<JSON> pr = gridOperator.load(service, param);
		if (pr.isSuccess()) {
			sendJSON(resp, pr.getData().toString());
		} else {
			sendJSON(resp, pr.toJSON());
		}

	}

	public static void update(HttpServletRequest req, HttpServletResponse resp) {
		GridTableUpdateBean param = getGridTableUpdateBean(req);
		update(req, resp, param);
	}

	// 保存表更新
	public static void update(HttpServletRequest req, HttpServletResponse resp,
			GridTableUpdateBean param) {
		log.debug("call dbeGridAction.update,param:" + param);

		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		DBInfoService service = prDBCS.getData().getDBInfoService();
		ProcessResult<String> pr = gridOperator.update(service, param);
		if (pr.isFailing()) {
			sendErrorJSON(resp, pr.toJSON());
		} else {
			sendJSON(resp, pr.toJSON());
		}

	}

	public static void remove(HttpServletRequest req, HttpServletResponse resp) {
		GridTableUpdateBean param = getGridTableUpdateBean(req);
		remove(req, resp, param);
	}

	// 删除表记录...
	public static void remove(HttpServletRequest req, HttpServletResponse resp,
			GridTableUpdateBean params) {
		log.debug("call dbeGridAction.remove,param:" + params);
		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		DBInfoService service = prDBCS.getData().getDBInfoService();
		ProcessResult<String> pr = gridOperator.remove(service, params);
		if (pr.isSuccess()) {
			sendJSON(resp, pr.toJSON());
		} else {
			sendErrorJSON(resp, pr.toJSON());
		}
	}

	// 取得外键可选值
	public static void fkvalue(HttpServletRequest req, HttpServletResponse resp) {
		// 取得外键表和外键字段 名称
		String t = req.getParameter("table");
		String f = req.getParameter("field");
		log.debug("call dbeGridAction.fkvalue," + t + "." + f);

		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		DBInfoService service = prDBCS.getData().getDBInfoService();
		ProcessResult<JSON> pr = gridOperator.getFKValues(service, t, f);
		if (pr.isSuccess()) {
			sendJSON(resp, pr.getData().toString());
		} else {
			sendJSON(resp, pr.toJSON());
		}
	}

	public static void export(HttpServletRequest req, HttpServletResponse resp) {
		DataExportBean param = getDataExportBean(req);
		export(req, resp, param);
	}

	// 数据导出
	public static void export(HttpServletRequest req, HttpServletResponse resp,
			DataExportBean param) {
		log.debug("call dbeGridAction.export.params:" + param);
		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		DBInfoService service = prDBCS.getData().getDBInfoService();
		WorkDirectory wd = workDirectory(req);// 当前临时文件目录
		ProcessResult<JSON> pr = gridOperator.export(service, param, wd);
		if (pr.isSuccess()) {
			sendJSON(resp, pr.getData().toString());
		} else {
			sendError(resp, 500, pr.toJSON());
		}
	}

	public static void readlob(HttpServletRequest req, HttpServletResponse resp) {
		GridTableFieldInfoBean param = getGridTableFieldInfoBean(req);
		readlob(req, resp, param);
	}

	// 读取长类型字段...
	public static void readlob(HttpServletRequest req, HttpServletResponse resp,
			GridTableFieldInfoBean param) {
		log.debug("call dbeGridAction.readlob:" + param);
		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		DBInfoService service = prDBCS.getData().getDBInfoService();
		WorkDirectory wd = workDirectory(req);// 当前临时文件目录
		ProcessResult<JSON> pr = gridOperator.readLob(service, param, wd);
		if (pr.isSuccess()) {
			sendJSON(resp, pr.getData().toString());
		} else {
			sendError(resp, 500, pr.toJSON());
		}
	}

	public static void updateblob(HttpServletRequest req, HttpServletResponse resp) {
		GridTableLongFieldInfoBean param = getGridTableLongFieldInfoBean(req);
		updateblob(req, resp, param);
	}

	// 上传文件 并更新到具体的Blob字段
	public static void updateblob(HttpServletRequest req, HttpServletResponse resp,
			GridTableLongFieldInfoBean bean) {
		log.debug("call dbeGridAction.updateblob,param:" + bean.getName());

		// 创建资源的临时文件
//		File file = workDirectory(req).newFile(bean.getName(), null);
//		OutputStream output = null;
//		InputStream input = null;
//		try {
//			output = new FileOutputStream(file);
//			input = bean.getFile().getInputStream();
//			FileCopyUtils.copy(input, output);
//		} catch (Exception e) {
//			log.debug("create temporary file error:" + e.getMessage());
//			sendError(resp, 500, "{success:false,msg:'create file error!'}");
//			return;
//		} finally {
//			IOUtils.closeQuietly(output);
//			IOUtils.closeQuietly(input);
//		}

        ServletFileUpload dfu = new ServletFileUpload(new DiskFileItemFactory(10240, FileUtil.getFile("runtime/tmp")));
        List<FileItem> lst = null;
        try {
            lst = UtilGenerics.checkList(dfu.parseRequest(req));
        } catch (FileUploadException e) {
			log.debug("check file error:" + e.getMessage());
			sendError(resp, 500, "{success:false,msg:'create file error!'}");
			return;
        }

        if (lst.size() == 0) {
			log.debug("no file error");
			sendError(resp, 500, "{success:false,msg:'No files uploaded!'}");
            return;
        }

        FileItem fi = null;
        String fileName = null;
        for (int i = 0; i < lst.size(); i++) {
            fi = lst.get(i);
            if (fi.isFormField()) {
                if (fi.getFieldName().equals("field")) {
                    bean.setField(fi.getString());
                } else if (fi.getFieldName().equals("pkInfo")) {
                	bean.setPkInfo(fi.getString());
//                    String pkInfo = fi.getString();
//                    if (!pkInfo.isEmpty()) {
//                    	JSONArray jsonArray = (JSONArray) JSONSerializer.toJSON(pkInfo);
//                    	JsonConfig jsonConfig = new JsonConfig();
//                    	jsonConfig.setArrayMode(JsonConfig.MODE_LIST);
//                    	jsonConfig.setRootClass(PkColumnObject.class);
//                    	List<PkColumnObject> pks = (List<PkColumnObject>) JSONSerializer.toJava(jsonArray, jsonConfig);
//                    	bean.setPkList(pks);
//                    }
                } else if (fi.getFieldName().equals("tablename")) {
                    bean.setTablename(fi.getString());
                }
            } else {
                String fieldName = fi.getFieldName();
                fileName = fi.getName();
                String contentType = fi.getContentType();
                boolean isInMemory = fi.isInMemory();
                long sizeInBytes = fi.getSize();
                break;
            }
        }
//        File file = FileUtil.getFile("runtime/tmp/" + fileName);
		File file = workDirectory(req).newFile(fileName, null);
        try {
            fi.write(file);
        } catch (Exception e) {
			log.debug("create temporary file error:" + e.getMessage());
			sendError(resp, 500, "{success:false,msg:'create file error!'}");
			return;
        }

		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		DBInfoService service = prDBCS.getData().getDBInfoService();
		ProcessResult<String> pr = gridOperator.updateBlob(service, bean, file);
		if (pr.isSuccess()) {
			sendJSON(resp, pr.getData());
		} else {
			sendError(resp, 500, pr.toJSON());
		}
	}

	public static void updateclob(HttpServletRequest req, HttpServletResponse resp) {
		GridTableFieldInfoBean param = getGridTableFieldInfoBean(req);
		updateclob(req, resp, param);
	}

	// 上传文件 并更新到具体的Blob字段
	public static void updateclob(HttpServletRequest req, HttpServletResponse resp,
			GridTableFieldInfoBean param) {
		log.debug("call dbeGridAction.updateclob,param:" + param);
		// check current login state
		ProcessResult<DBConnectionState> prDBCS = checkLogin(req);
		if (prDBCS.isFailing()) {
			log.error(prDBCS.getMessage());
			sendJSON(resp, prDBCS.toJSON());
			return;
		}

		// process
		ProcessResult<String> pr = null;
		String clob = req.getParameter("clob");
		if (clob == null) {
			pr = new ProcessResult<String>(false);
			pr.setMessage("updateclob Error:clob is null~~!");
			log.error(pr.getMessage());
		} else {
			log.debug("call dbeGridAction.upload,clob:" + clob);
			DBInfoService service = prDBCS.getData().getDBInfoService();
			pr = gridOperator.updateClob(service, param, clob);
		}

		// return
		if (pr.isSuccess()) {
			sendJSON(resp, pr.getData());
		} else {
			sendError(resp, 500, pr.toJSON());
		}
	}
	

//	public GridOperator getGridOperator() {
//		return gridOperator;
//	}

//	@Autowired
//	public void setGridOperator(GridOperator gridOperator) {
//		this.gridOperator = gridOperator;
//	}

	private static GridTableLoadBean getGridTableLoadBean(HttpServletRequest req) {
		GridTableLoadBean param = new GridTableLoadBean();
		try {
			BeanUtils.populate(param, req.getParameterMap());
		} catch (Exception e) {
			e.printStackTrace();
		}
//		param.setStart(Integer.valueOf("0" + req.getParameter("start")).intValue());
//		param.setLimit(Integer.valueOf("0" + req.getParameter("limit")).intValue());
//		param.setSearch(req.getParameter("search"));
//		param.setSearchValue(req.getParameter("searchValue"));
		return param;
	}

	private static GridTableUpdateBean getGridTableUpdateBean(HttpServletRequest req) {
		GridTableUpdateBean param = new GridTableUpdateBean();
		try {
			BeanUtils.populate(param, req.getParameterMap());
		} catch (Exception e) {
			e.printStackTrace();
		}
//		param.setData(req.getParameter("data"));
//		param.setTableUpdate((GridTableUpdateBean) req.getParameter("tableUpdate"));
		return param;
	}

	private static GridTableFieldInfoBean getGridTableFieldInfoBean(HttpServletRequest req) {
		GridTableFieldInfoBean param = new GridTableFieldInfoBean();
		try {
			BeanUtils.populate(param, req.getParameterMap());
		} catch (Exception e) {
			e.printStackTrace();
		}
//		param.setTablename(req.getParameter("tablename"));
//		param.setPkList((List<PkColumnObject>) req.getParameterValues("pkList"));
//		param.setPkInfo(req.getParameter("pkInfo"));
//		param.setField(req.getParameter("field"));
		return param;
	}

	private static GridTableLongFieldInfoBean getGridTableLongFieldInfoBean(HttpServletRequest req) {
		GridTableLongFieldInfoBean param = new GridTableLongFieldInfoBean();
		try {
			BeanUtils.populate(param, req.getParameterMap());
		} catch (Exception e) {
			e.printStackTrace();
		}
//		param.setTablename(req.getParameter("tablename"));
//		param.setPkList((List<PkColumnObject>) req.getParameterValues("pkList"));
//		param.setPkInfo(req.getParameter("pkInfo"));
//		param.setField(req.getParameter("field"));
		return param;
	}

	private static DataExportBean getDataExportBean(HttpServletRequest req) {
		DataExportBean param = new DataExportBean();
		try {
			BeanUtils.populate(param, req.getParameterMap());
		} catch (Exception e) {
			e.printStackTrace();
		}
//		param.setFields(req.getParameterValues("fields"));
//		param.setRangeType(req.getParameter("rangeType"));
//		param.setFormatType(req.getParameter("formatType"));
//		param.setStartPageNo(Integer.valueOf("0" + req.getParameter("startPageNo")).intValue());
//		param.setEndPageNo(Integer.valueOf("0" + req.getParameter("endPageNo")).intValue());
		return param;
	}
}
