/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.utils.sql;

import cn.com.qimingx.utils.sql.JDBCTask;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLExec
extends JDBCTask {
    private static final Log log = LogFactory.getLog(SQLExec.class);
    public static final String DELIMITER_TYPE_NORMAL = "normal";
    public static final String DELIMITER_TYPE_ROW = "row";
    public static final String ON_ERROR_ABORT = "abort";
    public static final String ON_ERROR_CONTINUE = "continue";
    public static final String ON_ERROR_STOP = "stop";
    private int goodSql = 0;
    private int totalSql = 0;
    private Connection conn = null;
    private List<File> resources = new ArrayList<File>();
    private Statement statement = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector<Transaction> transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private boolean showtrailers = true;
    private File output = null;
    private String onError = "abort";
    private String encoding = null;
    private boolean append = false;
    private boolean keepformat = false;
    private boolean escapeProcessing = true;
    private boolean expandProperties = false;

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public String getResult() {
        return String.valueOf(this.goodSql) + "  OF  " + String.valueOf(this.totalSql) + "\u6761\u8bb0\u5f55\u88ab\u6210\u529f\u6267\u884c";
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void add(File srcFile) {
        this.resources.add(srcFile);
    }

    public Transaction createTransaction() {
        Transaction t = new Transaction();
        this.transactions.addElement(t);
        return t;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(String delimiterType) {
        this.delimiterType = delimiterType;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setShowtrailers(boolean showtrailers) {
        this.showtrailers = showtrailers;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setOnerror(String onError) {
        this.onError = onError;
    }

    public void setKeepformat(boolean keepformat) {
        this.keepformat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection cnn, boolean isclose) throws Exception {
        Vector savedTransaction = (Vector)this.transactions.clone();
        String savedSqlCommand = this.sqlCommand;
        this.sqlCommand = this.sqlCommand.trim();
        try {
            if (this.srcFile == null && this.sqlCommand.length() == 0 && this.resources.size() == 0 && this.transactions.size() == 0) {
                throw new Exception("Source file or resource collection, transactions or sql statement must be set!");
            }
            if (this.srcFile != null && !this.srcFile.exists()) {
                throw new Exception("Source file does not exist!");
            }
            for (File file : this.resources) {
                Transaction t = this.createTransaction();
                t.setSrcResource(file);
            }
            Transaction t = this.createTransaction();
            t.setSrc(this.srcFile);
            t.addText(this.sqlCommand);
            this.conn = cnn;
            try {
                this.statement = this.conn.createStatement();
                this.statement.setEscapeProcessing(this.escapeProcessing);
                PrintStream out = System.out;
                try {
                    if (this.output != null) {
                        log.info((Object)("Opening PrintStream to output file " + this.output));
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    Enumeration<Transaction> e = this.transactions.elements();
                    while (e.hasMoreElements()) {
                        e.nextElement().runTransaction(out);
                        if (this.isAutocommit()) continue;
                        log.info((Object)"Committing transaction");
                        this.conn.commit();
                    }
                }
                finally {
                    if (out != null && out != System.out) {
                        out.close();
                    }
                }
            }
            catch (IOException e) {
                this.closeQuietly();
                throw new Exception(e);
            }
            catch (SQLException e) {
                this.closeQuietly();
                throw new Exception(e);
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (this.conn != null && isclose) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex) {}
            }
            log.info((Object)(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully"));
        }
        finally {
            this.transactions = savedTransaction;
            this.sqlCommand = savedSqlCommand;
        }
    }

    protected void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String line;
        StringBuffer sql = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        boolean isend = true;
        while ((line = in.readLine()) != null) {
            System.out.println(line);
            if (!this.keepformat) {
                line = line.trim();
            }
            if (!this.keepformat) {
                String token;
                StringTokenizer st;
                int index;
                String regEx = "/\\*[\\w\\s\\*@@-]*\\*/";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(line);
                line = m.replaceAll("");
                if (line.startsWith("GO") || line.startsWith("go")) {
                    line = "; " + line.substring(2);
                }
                if (line.startsWith("--")) {
                    line = "";
                    continue;
                }
                regEx = "\\*/[\\w\\s\\*@@-]*/\\*";
                int begin = line.indexOf("*/");
                int end = line.indexOf("/*");
                p = Pattern.compile(regEx);
                m = p.matcher(line);
                if (m.find()) {
                    line = line.substring(begin + 2, end);
                    isend = false;
                    continue;
                }
                if (line.indexOf("*/") > -1) {
                    index = line.indexOf("*/");
                    line.substring(index + 1);
                    isend = true;
                    continue;
                }
                if (line.indexOf("/*") > -1) {
                    index = line.indexOf("/*");
                    line.substring(0, index);
                    isend = false;
                    continue;
                }
                if (!isend) {
                    line = "";
                }
                if (line.indexOf("--") > -1) {
                    index = line.indexOf("--");
                    line = line.substring(0, index - 1);
                }
                if ((st = new StringTokenizer(line = line.trim())).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken())) continue;
            }
            if (!this.keepformat) {
                sql.append(" ");
                sql.append(line);
            } else {
                sql.append("\n");
                sql.append(line);
            }
            if (!this.keepformat && line.indexOf("--") >= 0) {
                sql.append("\n");
            }
            if ((!this.delimiterType.equals(DELIMITER_TYPE_NORMAL) || !sql.toString().endsWith(this.delimiter) || line.length() <= 0) && (!this.delimiterType.equals(DELIMITER_TYPE_ROW) || !line.equals(this.delimiter))) continue;
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql.replace(0, sql.length(), "");
        }
        if (sql.length() > 0) {
            log.debug((Object)("SQLExec.runStatements.sql" + sql));
            this.execSQL(sql.toString(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            ++this.totalSql;
            log.info((Object)("SQL: " + sql));
            int updateCount = 0;
            int updateCountTotal = 0;
            boolean ret = this.statement.execute(sql);
            updateCount = this.statement.getUpdateCount();
            log.debug((Object)("@@@@@@@@@@@UpdateCount" + updateCount));
            resultSet = this.statement.getResultSet();
            do {
                if (!ret) {
                    if (updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                } else if (this.print) {
                    this.printResults(resultSet, out);
                }
                if (!(ret = this.statement.getMoreResults())) continue;
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (ret);
            log.info((Object)(updateCountTotal + " rows affected"));
            if (this.print && this.showtrailers) {
                out.println(updateCountTotal + " rows affected");
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                log.debug((Object)(" sql warning " + warning.getLocalizedMessage()));
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException e) {
            log.debug((Object)("Failed to execute: " + sql));
            if (!this.onError.equals(ON_ERROR_CONTINUE)) {
                throw e;
            }
            log.debug((Object)e.toString());
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printResults(PrintStream out) throws SQLException {
        ResultSet rs = this.statement.getResultSet();
        try {
            this.printResults(rs, out);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    protected void printResults(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            log.info((Object)"Processing new result set.");
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                for (int col = 1; col < columnCount; ++col) {
                    line.append(md.getColumnName(col));
                    line.append(",");
                }
                line.append(md.getColumnName(columnCount));
                out.println(line);
                line = new StringBuffer();
            }
            while (rs.next()) {
                boolean first = true;
                for (int col = 1; col <= columnCount; ++col) {
                    String columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(",");
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
        }
        out.println();
    }

    private void closeQuietly() {
        if (!this.isAutocommit() && this.conn != null && this.onError.equals(ON_ERROR_ABORT)) {
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public class Transaction {
        private File tSrcResource = null;
        private String tSqlCommand = "";

        public void setSrc(File src) {
            if (src != null) {
                this.setSrcResource(src);
            }
        }

        public void setSrcResource(File src) {
            if (this.tSrcResource != null) {
                throw new IllegalArgumentException("only one resource per transaction");
            }
            this.tSrcResource = src;
        }

        public void addText(String sql) {
            if (sql != null) {
                this.tSqlCommand = this.tSqlCommand + sql;
            }
        }

        public void addConfigured(Collection<File> files) {
            if (files.size() != 1) {
                throw new IllegalArgumentException("only single argument resource collections are supported.");
            }
            this.setSrcResource(files.iterator().next());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream out) throws IOException, SQLException {
            System.out.println("tSqlCommand.length():" + this.tSqlCommand.length());
            if (this.tSqlCommand.length() != 0) {
                log.info((Object)"Executing commands");
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcResource != null) {
                log.info((Object)("Executing resource: " + this.tSrcResource.toString()));
                InputStream is = null;
                Reader reader = null;
                try {
                    is = new FileInputStream(this.tSrcResource);
                    reader = SQLExec.this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, SQLExec.this.encoding);
                    SQLExec.this.runStatements(reader, out);
                }
                finally {
                    is.close();
                    reader.close();
                }
            }
        }
    }
}

