/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.utils;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.base.util.UtilProperties;

public class SQLUtils {
    private static final Log log = LogFactory.getLog(SQLUtils.class);
    private static final Pattern FROM_PATTERN = Pattern.compile("(^|\\s)(from)\\s", 2);
    private static final Pattern ORDER_PATTERN = Pattern.compile("\\s(order)(\\s)+by\\s", 2);

    public static void main(String[] args) {
        String sql = "select * from users where id=3 order by id,name desc";
        String cond = "aa=b and c=d";
        System.out.println(SQLUtils.appendCondition(sql, cond));
    }

    public static Map<String, String> getDBInfos(DatabaseMetaData dbmd, Locale locale) {
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        try {
            String value = dbmd.getDatabaseProductName();
            value = value + "[" + dbmd.getDatabaseMajorVersion();
            value = value + "." + dbmd.getDatabaseMinorVersion() + "]";
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"DatabaseNameAndVersion", (Locale)locale), value);
            value = dbmd.getDriverName();
            value = value + "[" + dbmd.getDriverMajorVersion();
            value = value + "." + dbmd.getDriverMinorVersion() + "]";
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"DriverNameAndVersion", (Locale)locale), value);
            value = dbmd.getUserName();
            value = value + " connect to " + dbmd.getURL();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"UserName", (Locale)locale), value);
            int iValue = dbmd.getJDBCMajorVersion();
            value = String.valueOf(iValue);
            iValue = dbmd.getJDBCMinorVersion();
            value = value + "." + iValue;
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"JdbcVersion", (Locale)locale), value);
            boolean support = dbmd.supportsTransactions();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsTransactions", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsStoredProcedures();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsStoredProcedures", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsStatementPooling();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsStatementPooling", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsBatchUpdates();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsBatchUpdates", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsGetGeneratedKeys();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsGetGeneratedKeys", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsConvert();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsConvert", (Locale)locale), String.valueOf(support));
            value = UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"Full", (Locale)locale);
            support = dbmd.supportsANSI92FullSQL();
            if (!support) {
                value = UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"Intermediate", (Locale)locale);
                support = dbmd.supportsANSI92IntermediateSQL();
                if (!support) {
                    value = UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"Entry", (Locale)locale);
                }
            }
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsANSI92SQL", (Locale)locale), value);
            support = dbmd.supportsSubqueriesInComparisons();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsSubqueriesInComparisons", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsSubqueriesInExists();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsSubqueriesInExists", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsSubqueriesInIns();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsSubqueriesInIns", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsCorrelatedSubqueries();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsCorrelatedSubqueries", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsSubqueriesInQuantifieds();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsSubqueriesInQuantifieds", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsSelectForUpdate();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsSelectForUpdate", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsUnion();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsUnion", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsUnionAll();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsUnionAll", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsGroupBy();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsGroupBy", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsOuterJoins();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsOuterJoins", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsLimitedOuterJoins();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsLimitedOuterJoins", (Locale)locale), String.valueOf(support));
            support = dbmd.supportsFullOuterJoins();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SupportsFullOuterJoins", (Locale)locale), String.valueOf(support));
            iValue = dbmd.getMaxStatementLength();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"MaxStatementLength", (Locale)locale), String.valueOf(iValue));
            value = dbmd.getSQLKeywords();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SQLKeywords", (Locale)locale), value);
            value = dbmd.getSystemFunctions();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"SystemFunctions", (Locale)locale), value);
            value = dbmd.getNumericFunctions();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"NumericFunctions", (Locale)locale), value);
            value = dbmd.getStringFunctions();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"StringFunctions", (Locale)locale), value);
            value = dbmd.getTimeDateFunctions();
            infos.put(UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"TimeDateFunctions", (Locale)locale), value);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return infos;
    }

    public static String getCountSQL(String sql) {
        Matcher fMatcher = FROM_PATTERN.matcher(sql);
        if (!fMatcher.find()) {
            throw new IllegalArgumentException("no from clause found in query");
        }
        int fLoc = fMatcher.start(2);
        Matcher oMatcher = ORDER_PATTERN.matcher(sql);
        int oLoc = oMatcher.find() ? oMatcher.start(1) : sql.length();
        return "select count(*) " + sql.substring(fLoc, oLoc);
    }

    public static long totalRowsBySQL(String sql, Statement stat) {
        long total = 0L;
        String countSQL = SQLUtils.getCountSQL(sql);
        log.debug((Object)("count rows total:" + countSQL));
        try {
            ResultSet rs = stat.executeQuery(countSQL);
            if (rs.next()) {
                total = rs.getInt(1);
            } else {
                log.error((Object)"getTotalRows Error~~,total=0");
            }
            rs.close();
        }
        catch (SQLException e) {
            log.error((Object)"getTotalRows Error~~,total=0");
        }
        return total;
    }

    public static String appendCondition(String sql, String condition) {
        if (condition == null || condition.length() == 0) {
            return sql;
        }
        Matcher oMatcher = ORDER_PATTERN.matcher(sql);
        int oLoc = oMatcher.find() ? oMatcher.start(1) : sql.length();
        StringBuilder str = new StringBuilder(sql.toLowerCase());
        String cond = null;
        cond = str.lastIndexOf("where") == -1 ? "where (" + condition + ") " : "and (" + condition + ") ";
        if (oLoc == sql.length()) {
            cond = " " + cond;
        }
        str.insert(oLoc, cond);
        return str.toString();
    }
}

