/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyUtils {
    private static final transient Log log = LogFactory.getLog(MyUtils.class);

    public static void main(String[] args) {
    }

    public static boolean isHTMLContent(String content) {
        String[] tags = new String[]{"<html>", "<head>", "<title>", "<script", "<meta", "<link", "<body", "<table", "<tr", "<td", "<form", "<img", "<input", "<frame", "<iframe", "<frameset", "<hr", "<dd", "<dl", "<dt", "<dir", "<ll", "<li", "<ul", "<span"};
        content = content.toLowerCase();
        for (String tag : tags) {
            if (!content.contains(tag)) continue;
            log.debug((Object)("[" + content + "] isHTML=" + true));
            return true;
        }
        return false;
    }

    public static String printObject(Object o) {
        String s = ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        return s;
    }

    public static String toUTF8(String str) {
        String encoding = System.getProperty("file.encoding", "GBK");
        return MyUtils.resetCharset(str, encoding, "UTF-8");
    }

    public static String resetCharset(String string, String srcCharset, String destCharset) {
        String result = null;
        try {
            byte[] bytes = string.getBytes(srcCharset);
            result = new String(bytes, destCharset);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("resetCharset Error:" + e.getLocalizedMessage()));
            return string;
        }
        log.debug((Object)(srcCharset + " --> " + destCharset + ":[" + string + " --> " + result + "]"));
        return result;
    }

    public static String urlEncode(String url) {
        try {
            url = URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("urlEncod Error:" + e.getMessage()));
        }
        return url;
    }

    public static Object newObjectOfClassName(String clsName) {
        try {
            return Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("newObjectOfClassName Error:" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate(String date, String ... formats) {
        if (formats == null || formats.length == 0) {
            formats = new String[]{"yyyy-MM-dd"};
        }
        try {
            return DateUtils.parseDate((String)date, (String[])formats);
        }
        catch (ParseException e) {
            String format = Arrays.toString(formats);
            log.error((Object)("parseDate Error:" + date + "[" + format));
            return null;
        }
    }
}

