/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.utils;

import cn.com.qimingx.utils.SQLTypeUtils;

public class ExtTypeInfo {
    private static final String FORMAT_DATA_TIME = "yyyy-MM-dd HH:mm";
    private static final String FORMAT_DATA_TIME_EXT = "Y-m-d H:i";
    private static final String FORMAT_DATA = "yyyy-MM-dd";
    private static final String FORMAT_DATA_EXT = "Y-m-d";
    private static final String FORMAT_TIME = "HH:mm";
    private static final String FORMAT_TIME_EXT = "H:i";
    private String type;
    private int jdbcType;
    private String format;

    public ExtTypeInfo(int jdbcType) {
        this.jdbcType = jdbcType;
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                this.setType("int");
                break;
            }
            case 16: {
                this.setType("boolean");
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.setType("float");
                break;
            }
            case 91: {
                this.setFormat(FORMAT_DATA);
                this.setType("date");
                break;
            }
            case 92: {
                this.setFormat(FORMAT_TIME);
                this.setType("date");
                break;
            }
            case 93: {
                this.setFormat(FORMAT_DATA_TIME);
                this.setType("date");
                break;
            }
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                this.setType("string");
                break;
            }
            default: {
                this.setType("auto");
            }
        }
    }

    public boolean isNumberType() {
        return SQLTypeUtils.isNumberType(this.jdbcType);
    }

    public boolean isDateType() {
        return SQLTypeUtils.isDateType(this.jdbcType);
    }

    public boolean isLongType() {
        return SQLTypeUtils.isLongType(this.jdbcType);
    }

    public boolean isBooleanType() {
        return this.jdbcType == 16;
    }

    public boolean isSortable() {
        boolean sortable = this.type.equalsIgnoreCase("int");
        sortable = sortable || this.type.equalsIgnoreCase("float");
        sortable = sortable || this.type.equalsIgnoreCase("boolean");
        sortable = sortable || this.type.equalsIgnoreCase("date");
        return sortable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public String getDateFormat() {
        switch (this.jdbcType) {
            case 91: {
                return FORMAT_DATA_EXT;
            }
            case 92: {
                return FORMAT_TIME_EXT;
            }
            case 93: {
                return FORMAT_DATA_TIME_EXT;
            }
        }
        return null;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

