/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.json;

import java.util.Date;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import org.apache.commons.lang.time.DateFormatUtils;

public class MyJsDateJsonBeanProcessor
implements JsonBeanProcessor {
    public static String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm";
    private String datePattern = null;

    public static String processDate(Date date) {
        return DateFormatUtils.format((Date)date, (String)DEFAULT_DATE_PATTERN);
    }

    public String getDatePattern() {
        if (this.datePattern == null) {
            return DEFAULT_DATE_PATTERN;
        }
        return this.datePattern;
    }

    public void resetDatePattern() {
        this.datePattern = null;
    }

    public JSONObject processBean(Object bean, JsonConfig jsonConfig) {
        if (bean instanceof java.sql.Date) {
            java.sql.Date d = (java.sql.Date)bean;
            long time = d.getTime();
            String pattern = this.getDatePattern();
            String date = DateFormatUtils.format((long)time, (String)pattern);
            return MyJsDateJsonBeanProcessor.makeJSONObject(date, time, pattern);
        }
        if (bean instanceof Date) {
            Date d = (Date)bean;
            long time = d.getTime();
            String pattern = this.getDatePattern();
            String date = DateFormatUtils.format((long)time, (String)pattern);
            return MyJsDateJsonBeanProcessor.makeJSONObject(date, time, pattern);
        }
        return new JSONObject(true);
    }

    private static JSONObject makeJSONObject(String date, long time, String pattern) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.element("date", (Object)date);
        jsonObject.element("time", time);
        jsonObject.element("pattern", (Object)pattern);
        return jsonObject;
    }
}

