/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.web;

import cn.com.qimingx.dbe.service.WorkDirectory;
import cn.com.qimingx.dbe.service.impl.TemporaryWorkDirectory;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBEListener
implements HttpSessionListener,
ServletContextListener {
    private static final Log log = LogFactory.getLog(DBEListener.class);
    private static final String KEY_WORK_DIRECTORY = "WORK_DIRECTORY_OBJECT";

    public static WorkDirectory getWorkDirectory(HttpSession sess) {
        Object obj = sess.getAttribute(KEY_WORK_DIRECTORY);
        if (obj == null) {
            TemporaryWorkDirectory twd = new TemporaryWorkDirectory();
            twd.setTagName(sess.getId());
            twd.initWorkDirectory();
            sess.setAttribute(KEY_WORK_DIRECTORY, (Object)twd);
            return twd;
        }
        return (WorkDirectory)obj;
    }

    public void contextInitialized(ServletContextEvent event) {
    }

    public void sessionCreated(HttpSessionEvent event) {
        DBEListener.getWorkDirectory(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        String tag = event.getSession().getId();
        DBEListener.getWorkDirectory(event.getSession()).cleanWorkDirectoryByTag(tag);
    }

    public void contextDestroyed(ServletContextEvent event) {
        File f = TemporaryWorkDirectory.getWorkDirectoryHome(false);
        if (f != null) {
            try {
                FileUtils.deleteDirectory((File)f);
                log.debug((Object)("clean WorkDirectory.ok:" + f.getAbsolutePath()));
            }
            catch (IOException e) {
                log.error((Object)("cleanWorkDirectory.error:" + e.getMessage()));
            }
        }
    }
}

