/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.dbe.service.WorkDirectory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemporaryWorkDirectory
implements WorkDirectory {
    private static final Log log = LogFactory.getLog(TemporaryWorkDirectory.class);
    private static File home = null;
    private String tag = null;
    private File dir = null;

    @Override
    public void setTagName(String tag) {
        this.tag = tag;
    }

    public static File getWorkDirectoryHome(boolean autoCreate) {
        if (home == null) {
            String path = TemporaryWorkDirectory.class.getResource("/").getFile();
            home = new File(path, "runtime/tmp");
        }
        return home;
    }

    @Override
    public File newFile(String name, String ext) {
        File tempDir = this.getCurrentDir();
        try {
            File file = null;
            if (name == null) {
                ext = ext == null ? ".tmp" : ext;
                ext = ext.startsWith(".") ? ext : "." + ext;
                file = File.createTempFile("tf_", ext, tempDir);
            } else {
                if (ext != null) {
                    ext = ext.startsWith(".") ? ext : "." + ext;
                    name = name + ext;
                }
                file = new File(tempDir, name);
            }
            return file;
        }
        catch (IOException e) {
            log.error((Object)("newFile.error\uff1a" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)e);
            }
            return null;
        }
    }

    private File getCurrentDir() {
        if (this.dir == null) {
            this.dir = TemporaryWorkDirectory.getWorkDirectoryHome(true);
            if (this.tag != null) {
                this.dir = new File(this.dir, this.tag);
                if (!this.dir.exists()) {
                    if (this.dir.mkdirs()) {
                        log.debug((Object)("WorkDirectory init OK~:" + this.dir.getAbsolutePath()));
                    } else {
                        log.error((Object)"dir.mkdirs() is False.");
                    }
                }
            } else {
                String msg = "create WorkDirectory error:tag is null.";
                log.error((Object)msg);
                return null;
            }
        }
        return this.dir;
    }

    @Override
    public File getFileByName(String name) {
        File file = new File(this.getCurrentDir(), name);
        if (file.exists()) {
            return file;
        }
        log.error((Object)("\u6587\u4ef6\uff1a" + name + "\uff0c\u4e0d\u5b58\u5728."));
        return null;
    }

    @Override
    public void initWorkDirectory() {
        this.getCurrentDir();
    }

    @Override
    public void cleanWorkDirectoryByTag(String tag) {
        if (this.dir != null) {
            try {
                FileUtils.deleteDirectory((File)this.dir);
                String msg = "current WorkDirectory clean OK~~:";
                msg = msg + this.dir.getAbsolutePath();
                log.debug((Object)msg);
            }
            catch (IOException e) {
                String msg = "current clean WorkDirectory.error:";
                msg = msg + e.getMessage();
                log.debug((Object)msg);
            }
        }
    }
}

