/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.LobObject;
import cn.com.qimingx.dbe.service.WorkDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LobStreamingResultSetExtractor {
    private static final Log log = LogFactory.getLog(LobStreamingResultSetExtractor.class);
    private WorkDirectory work;
    private ProcessResult<LobObject> pr = new ProcessResult();

    public LobStreamingResultSetExtractor(WorkDirectory work) {
        this.work = work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamData(ResultSet rs) throws SQLException, IOException {
        int type = rs.getMetaData().getColumnType(1);
        LobObject lob = new LobObject(type);
        File file = null;
        file = lob.isBLOB() ? this.work.newFile(null, ".blob") : this.work.newFile(null, ".txt");
        lob.setValue(file);
        this.pr.setData(lob);
        InputStream in = null;
        FileOutputStream out = null;
        Reader reader = null;
        OutputStreamWriter writer = null;
        try {
            if (lob.isBLOB()) {
                Blob blob;
                out = new FileOutputStream(file);
                if (rs.next() && (blob = rs.getBlob(1)) != null) {
                    in = blob.getBinaryStream();
                }
                if (in != null) {
                    int length = IOUtils.copy(in, (OutputStream)out);
                    this.pr.setMessage("Read BLOB OK:" + length);
                } else {
                    this.pr.setMessage("Read BLOB stream is null.");
                    lob.setValue(null);
                }
            } else {
                Clob clob;
                out = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)out, "utf-8");
                if (rs.next() && (clob = rs.getClob(1)) != null) {
                    reader = clob.getCharacterStream();
                }
                if (reader != null) {
                    int length = IOUtils.copy(reader, (Writer)writer);
                    ((Writer)writer).flush();
                    out.flush();
                    this.pr.setMessage("Read CLOB OK:" + length);
                } else {
                    this.pr.setMessage("Read CLOB stream is null.");
                    lob.setValue(null);
                }
            }
            this.pr.setSuccess(true);
            log.debug((Object)this.pr.getMessage());
        }
        catch (Throwable e) {
            try {
                this.pr.setSuccess(false);
                this.pr.setMessage("Read LOB Error:" + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
    }

    public ProcessResult<LobObject> getProcessResult() {
        return this.pr;
    }
}

