/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.TableColumnInfo;
import cn.com.qimingx.dbe.TableDataInfo;
import cn.com.qimingx.dbe.TableInfo;
import cn.com.qimingx.dbe.service.impl.AbstractDBInfoService;
import cn.com.qimingx.spring.NamedPreparedStatement;
import cn.com.qimingx.utils.MyUtils;
import cn.com.qimingx.utils.SQLTypeUtils;
import cn.com.qimingx.utils.SQLUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

class HelperDBInfoServiceTable {
    private Log log;
    private AbstractDBInfoService service;

    public HelperDBInfoServiceTable(AbstractDBInfoService service, Log log) {
        this.service = service;
        this.log = log;
    }

    public ProcessResult<String> executeUpdate(String sql, Map<String, Object> params) {
        ProcessResult<String> pr = new ProcessResult<String>();
        try {
            NamedPreparedStatement stmt = new NamedPreparedStatement(sql);
            if (params != null) {
                for (String key : params.keySet()) {
                    Object[] p;
                    Object param = params.get(key);
                    if (param instanceof Integer) {
                        p = new Integer[]{(Integer)param};
                        stmt.setInt(key, (Integer[])p);
                        continue;
                    }
                    if (param instanceof Date) {
                        p = new Date[]{(Date)param};
                        stmt.setDate(key, (Date[])p);
                        continue;
                    }
                    if (!(param instanceof String)) continue;
                    p = new String[]{(String)param};
                    stmt.setString(key, (String[])p);
                }
            }
            int updateRows = stmt.executeUpdate(this.service.getDBConnection());
            pr.setSuccess(true);
            pr.setMessage("Update " + updateRows + " Rows.");
            return pr;
        }
        catch (SQLException e) {
            pr.setMessage(e.getMessage());
            this.log.error((Object)("\u6267\u884cSQL[" + sql + "]\u51fa\u9519\uff1a" + pr.getMessage()));
            return pr;
        }
    }

    public ProcessResult<TableInfo> executeQuery(String sql, int start, int limit, String condition) {
        ProcessResult<TableInfo> prTableInfo = this.readTableInfo(sql, start, limit, condition, null);
        ProcessResult<TableInfo> pr = new ProcessResult<TableInfo>();
        if (prTableInfo.isFailing()) {
            pr.setMessage(prTableInfo.getMessage());
        } else {
            pr.setSuccess(true);
            pr.setData(prTableInfo.getData());
        }
        return pr;
    }

    public ProcessResult<TableDataInfo> getTableData(String schema, String name, int start, int limit, String condition) {
        ProcessResult<TableDataInfo> pr = new ProcessResult<TableDataInfo>();
        ProcessResult<List<TableColumnInfo>> prCI = this.service.getTableColumnInfo(schema, name);
        if (prCI.isFailing()) {
            pr.setMessage(prCI.getMessage());
            return pr;
        }
        List<TableColumnInfo> columns = prCI.getData();
        String sql = "SELECT * FROM " + name;
        ProcessResult<TableInfo> prTable = this.readTableInfo(sql, start, limit, condition, columns);
        if (prTable.isFailing()) {
            pr.setMessage(prTable.getMessage());
        } else {
            pr.setSuccess(true);
            pr.setData(prTable.getData().getData());
        }
        return pr;
    }

    public ProcessResult<TableInfo> getTableInfo(String schema, String name) {
        ProcessResult<TableInfo> pr = new ProcessResult<TableInfo>();
        TableInfo info = new TableInfo();
        info.setTableName(name);
        ProcessResult<String> prPK = this.service.getPrimaryKeys(schema, name);
        info.setReadOnly(prPK.isFailing());
        if (prPK.isFailing()) {
            this.log.warn((Object)("\u53d6 [" + name + "] \u4e3b\u952e\u5931\u8d25\uff0c\u8868\u5c06\u53ea\u8bfb~~"));
        } else {
            info.setPkColumnName(prPK.getData());
        }
        ProcessResult<List<TableColumnInfo>> prCI = this.service.getTableColumnInfo(schema, name);
        if (prCI.isFailing()) {
            pr.setMessage(prCI.getMessage());
            return pr;
        }
        info.setColumns(prCI.getData());
        for (TableColumnInfo tci : prCI.getData()) {
            String cname = tci.getName();
            String pkname = info.getPkColumnName();
            if (pkname.indexOf(cname) <= -1) continue;
            tci.setPkColumn(true);
        }
        pr.setSuccess(true);
        pr.setData(info);
        return pr;
    }

    public ProcessResult<TableInfo> readTableInfo(String sql, int start, int limit, String condition, List<TableColumnInfo> columns) {
        ProcessResult<TableInfo> pr = new ProcessResult<TableInfo>();
        try {
            Statement stat = this.service.getDBConnection().createStatement(1004, 1007);
            if (condition != null && condition.length() > 0) {
                sql = SQLUtils.appendCondition(sql, condition);
            }
            long total = SQLUtils.totalRowsBySQL(sql, stat);
            if (this.service.supportLimit()) {
                sql = this.service.getLimitSQLString(sql);
            }
            this.log.debug((Object)("load data by sql:" + sql));
            ResultSet rs = stat.executeQuery(sql);
            if (!this.service.supportLimit() && start > 1) {
                if (this.service.supportScrollableResultSet()) {
                    rs.absolute(start);
                } else {
                    int counter = 0;
                    while (rs.next() && ++counter != start) {
                    }
                }
            }
            if (columns == null || columns.size() == 0) {
                columns = this.getTableColumnInfoByResultSet(rs);
            }
            TableDataInfo tableData = this.getTableDataInfoByResultSet(rs, limit, columns, this.service.supportLimit(), total);
            rs.close();
            TableInfo tableInfo = new TableInfo();
            tableInfo.setData(tableData);
            tableInfo.setColumns(columns);
            pr.setSuccess(true);
            pr.setData(tableInfo);
            return pr;
        }
        catch (SQLException e) {
            this.log.error((Object)("readTableInfo\u51fa\u9519\uff1a" + e.getMessage()));
            pr.setMessage(e.getMessage());
            return pr;
        }
    }

    public ProcessResult<String> getPrimaryKeys(String schema, String name) {
        ProcessResult<String> pr = new ProcessResult<String>();
        try {
            ResultSet rs = null;
            rs = this.service.baseHelper.isSchema() ? this.service.meta.getPrimaryKeys(null, schema, name) : this.service.meta.getPrimaryKeys(schema, null, name);
            String pkName = "";
            while (rs.next()) {
                if (pkName.length() > 0) {
                    pkName = pkName + ",";
                }
                pkName = pkName + rs.getString("COLUMN_NAME");
            }
            rs.close();
            if (pkName != null) {
                pr.setSuccess(true);
                pr.setData(pkName);
            } else {
                pr.setMessage(name + " without PrimaryKey~!?");
            }
            return pr;
        }
        catch (SQLException e) {
            this.log.error((Object)("getPrimaryKeys\u51fa\u9519\uff1a" + e.getMessage()));
            pr.setMessage(e.getMessage());
            return pr;
        }
    }

    public ProcessResult<List<TableColumnInfo>> getTableColumnInfo(String schema, String name) {
        ProcessResult<List<TableColumnInfo>> pr = new ProcessResult<List<TableColumnInfo>>();
        try {
            ResultSet rs = null;
            rs = this.service.baseHelper.isSchema() ? this.service.meta.getColumns(null, schema, name, null) : this.service.meta.getColumns(schema, null, name, null);
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            while (rs.next()) {
                TableColumnInfo cinfo = new TableColumnInfo();
                cinfo.setName(rs.getString("COLUMN_NAME"));
                cinfo.setType(rs.getInt("DATA_TYPE"));
                cinfo.setSize(rs.getInt("COLUMN_SIZE"));
                cinfo.setDigits(rs.getInt("DECIMAL_DIGITS"));
                int nullIdx = rs.getInt("NULLABLE");
                cinfo.setNullable(nullIdx == 1);
                cinfo.setDefaultValue(rs.getString("COLUMN_DEF"));
                cinfo.setComment(rs.getString("REMARKS"));
                columns.add(cinfo);
            }
            rs.close();
            rs = this.service.meta.getImportedKeys(null, schema, name);
            block3: while (rs.next()) {
                String table = rs.getString("PKTABLE_NAME");
                String colname = rs.getString("PKCOLUMN_NAME");
                String fkName = rs.getString("FKCOLUMN_NAME");
                for (TableColumnInfo tci : columns) {
                    if (!tci.getName().equalsIgnoreCase(fkName)) continue;
                    tci.setFkColumn(true);
                    tci.setFkInfo(new TableColumnInfo.FKColumnInfo(table, colname));
                    continue block3;
                }
            }
            rs.close();
            pr.setSuccess(true);
            pr.setData(columns);
            return pr;
        }
        catch (SQLException e) {
            this.log.error((Object)("getTableColumnInfo\u51fa\u9519\uff1a" + e.getMessage()));
            pr.setMessage(e.getMessage());
            return pr;
        }
    }

    private List<TableColumnInfo> getTableColumnInfoByResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int length = rsmd.getColumnCount();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>(length);
        for (int i = 0; i < length; ++i) {
            int idx = i + 1;
            String name = rsmd.getColumnName(idx);
            int type = rsmd.getColumnType(idx);
            int width = rsmd.getColumnDisplaySize(idx);
            columns.add(new TableColumnInfo(name, type, width, true));
        }
        return columns;
    }

    private TableDataInfo getTableDataInfoByResultSet(ResultSet rs, int limit, List<TableColumnInfo> columns, boolean supportLimitSQL, long total) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(limit + 10);
        int counter = 0;
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (TableColumnInfo column : columns) {
                Object value = this.readFieldValue(rs, column);
                row.put(column.getName(), value);
            }
            rows.add(row);
            if (supportLimitSQL || limit <= 0 || ++counter != limit) continue;
            break;
        }
        return new TableDataInfo(total, rows);
    }

    private Object readFieldValue(ResultSet rs, TableColumnInfo column) throws SQLException {
        int type = column.getType();
        String field = column.getName();
        Object value = null;
        value = SQLTypeUtils.isDateType(type) ? rs.getTimestamp(field) : (SQLTypeUtils.isNumberType(type) ? rs.getString(field) : (SQLTypeUtils.isStringType(type) ? rs.getString(field) : (SQLTypeUtils.isBlobType(type) ? "[LONGVARBINARY]" : (SQLTypeUtils.isClobType(type) ? "[LONGVARCHAR]" : "[" + SQLTypeUtils.getJdbcTypeName(type) + "]"))));
        if (rs.wasNull() && !SQLTypeUtils.isNumberType(type) && !SQLTypeUtils.isDateType(type)) {
            value = "[NULL]";
        } else if (SQLTypeUtils.isStringType(type) && MyUtils.isHTMLContent(value.toString())) {
            value = "[HTML]";
        }
        return value;
    }
}

