/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.LobObject;
import cn.com.qimingx.dbe.action.bean.PkColumnObject;
import cn.com.qimingx.dbe.service.WorkDirectory;
import cn.com.qimingx.dbe.service.impl.AbstractDBInfoService;
import cn.com.qimingx.dbe.service.impl.LobStreamingResultSetExtractor;
import cn.com.qimingx.spring.NamedPreparedStatement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

class HelperDBInfoServiceLob {
    private Log log;
    private AbstractDBInfoService service;

    public HelperDBInfoServiceLob(AbstractDBInfoService service, Log log) {
        this.service = service;
        this.log = log;
    }

    public ProcessResult<LobObject> readLob(String table, List<PkColumnObject> pks, String fieldName, WorkDirectory work) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String where = "";
        for (PkColumnObject pk : pks) {
            if (where.length() > 0) {
                where = where + " and ";
            }
            where = where + pk.getPk() + "=:" + pk.getPk();
            paramMap.put(pk.getPk(), pk.getPkValueObject());
        }
        String sql = "select " + fieldName + " from " + table;
        sql = sql + " where (" + where + ")";
        this.log.debug((Object)("readLob.sql:" + sql));
        LobStreamingResultSetExtractor extractor = new LobStreamingResultSetExtractor(work);
        try {
            NamedPreparedStatement stmt = new NamedPreparedStatement(sql);
            for (String key : paramMap.keySet()) {
                Object[] p;
                Object param = paramMap.get(key);
                if (param instanceof Integer) {
                    p = new Integer[]{(Integer)param};
                    stmt.setInt(key, (Integer[])p);
                    continue;
                }
                if (param instanceof Date) {
                    p = new Date[]{(Date)param};
                    stmt.setDate(key, (Date[])p);
                    continue;
                }
                if (!(param instanceof String)) continue;
                p = new String[]{(String)param};
                stmt.setString(key, (String[])p);
            }
            ResultSet rs = stmt.executeQuery(this.service.getDBConnection());
            extractor.streamData(rs);
        }
        catch (Throwable e) {
            this.log.error((Object)("Read LOB Error:" + e.getMessage()));
        }
        ProcessResult<LobObject> pr = extractor.getProcessResult();
        if (pr.isFailing()) {
            this.log.debug((Object)("Read LOB Fail:" + pr.getMessage()));
        }
        return pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ProcessResult<String> updateBLob(String table, List<PkColumnObject> pks, String fieldName, File file) {
        ProcessResult<String> processResult;
        ProcessResult<String> pr = new ProcessResult<String>(false);
        String where = "";
        for (PkColumnObject pk : pks) {
            if (where.length() > 0) {
                where = where + " and ";
            }
            where = where + pk.getPk() + "=?";
        }
        String sql = "update " + table + " SET " + fieldName;
        sql = sql + "=? where (" + where + ")";
        this.log.debug((Object)("updateCLob.sql:" + sql));
        FileInputStream input = null;
        try {
            FileInputStream finput = input = new FileInputStream(file);
            PreparedStatement pstmt = this.service.getDBConnection().prepareStatement(sql);
            pstmt.setBinaryStream(1, (InputStream)finput, (int)file.length());
            int idx = 2;
            for (PkColumnObject pk : pks) {
                pstmt.setObject(idx++, pk.getPkValueObject());
            }
            pstmt.executeUpdate();
            pr.setSuccess(true);
            pr.setData("{success:true,file:'" + file.getName() + "'}");
            processResult = pr;
        }
        catch (FileNotFoundException e) {
            pr.setMessage("updateBLob Error:" + e.getMessage());
            this.log.error((Object)pr.getMessage());
            ProcessResult<String> processResult2 = pr;
            IOUtils.closeQuietly((InputStream)input);
            return processResult2;
        }
        catch (SQLException e2) {
            pr.setMessage("updateBLob Error:" + e2.getMessage());
            this.log.error((Object)pr.getMessage());
            ProcessResult<String> processResult3 = pr;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            return processResult3;
        }
        IOUtils.closeQuietly((InputStream)input);
        return processResult;
    }

    public ProcessResult<String> updateCLob(String table, List<PkColumnObject> pks, String field, String clob) {
        ProcessResult<String> pr = new ProcessResult<String>(false);
        String where = "";
        for (PkColumnObject pk : pks) {
            if (where.length() > 0) {
                where = where + " and ";
            }
            where = where + pk.getPk() + "=?";
        }
        String sql = "update " + table + " SET " + field;
        sql = sql + "=? where (" + where + ")";
        this.log.debug((Object)("updateCLob.sql:" + sql));
        try {
            PreparedStatement pstmt = this.service.getDBConnection().prepareStatement(sql);
            pstmt.setString(1, clob);
            int idx = 2;
            for (PkColumnObject pk : pks) {
                pstmt.setObject(idx++, pk.getPkValueObject());
            }
            pstmt.executeUpdate();
            pr.setSuccess(true);
            pr.setData("{success:true}");
            return pr;
        }
        catch (Throwable e) {
            pr.setMessage("updateCLob Error:" + e.getMessage());
            this.log.error((Object)pr.getMessage());
            return pr;
        }
    }
}

