/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.FieldDataType;
import cn.com.qimingx.dbe.LobObject;
import cn.com.qimingx.dbe.TableColumnInfo;
import cn.com.qimingx.dbe.TableDataInfo;
import cn.com.qimingx.dbe.TableInfo;
import cn.com.qimingx.dbe.action.bean.PkColumnObject;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.dbe.service.WorkDirectory;
import cn.com.qimingx.dbe.service.impl.HelperDBInfoServiceBase;
import cn.com.qimingx.dbe.service.impl.HelperDBInfoServiceLob;
import cn.com.qimingx.dbe.service.impl.HelperDBInfoServiceTable;
import cn.com.qimingx.utils.sql.SQLExec;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDBInfoService
implements DBInfoService {
    private static final Log log = LogFactory.getLog(AbstractDBInfoService.class);
    protected Connection conn;
    protected DatabaseMetaData meta;
    protected HelperDBInfoServiceBase baseHelper;
    protected HelperDBInfoServiceTable tableHelper;
    protected HelperDBInfoServiceLob lobHelper;

    @Override
    public void setDBConnection(Connection conn) {
        this.conn = conn;
        try {
            this.meta = conn.getMetaData();
        }
        catch (SQLException e) {
            String msg = "set Connection to DBInfoService Error:";
            msg = msg + e.getMessage();
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        this.baseHelper = new HelperDBInfoServiceBase(this, log);
        this.tableHelper = new HelperDBInfoServiceTable(this, log);
        this.lobHelper = new HelperDBInfoServiceLob(this, log);
    }

    @Override
    public Connection getDBConnection() {
        return this.conn;
    }

    @Override
    public String getDatabaseName() {
        return this.baseHelper.getDatabaseName();
    }

    @Override
    public List<String> getSchemas() {
        return this.baseHelper.getSchemas();
    }

    @Override
    public List<String> getElementTypes() {
        return this.baseHelper.getElementTypes();
    }

    @Override
    public List<String> getElements(String schema, String ... types) {
        return this.baseHelper.getElements(schema, types);
    }

    @Override
    public boolean supportScrollableResultSet() {
        return this.baseHelper.supportScrollableResultSet();
    }

    @Override
    public ProcessResult<String> executeUpdate(String sql, Map<String, Object> params) {
        return this.tableHelper.executeUpdate(sql, params);
    }

    @Override
    public ProcessResult<TableInfo> executeQuery(String sql, int start, int limit, String condition) {
        return this.tableHelper.executeQuery(sql, start, limit, condition);
    }

    @Override
    public ProcessResult<List<TableColumnInfo>> getTableColumnInfo(String schema, String name) {
        return this.tableHelper.getTableColumnInfo(schema, name);
    }

    @Override
    public ProcessResult<String> getPrimaryKeys(String schema, String name) {
        return this.tableHelper.getPrimaryKeys(schema, name);
    }

    @Override
    public ProcessResult<TableInfo> getTableInfo(String schema, String name) {
        return this.tableHelper.getTableInfo(schema, name);
    }

    @Override
    public ProcessResult<TableDataInfo> getTableData(String schema, String name, int start, int limit, String condition) {
        return this.tableHelper.getTableData(schema, name, start, limit, condition);
    }

    @Override
    public ProcessResult<LobObject> readLob(String table, List<PkColumnObject> pks, String fieldName, WorkDirectory work) {
        return this.lobHelper.readLob(table, pks, fieldName, work);
    }

    @Override
    public ProcessResult<String> updateBLob(String table, List<PkColumnObject> pks, String fieldName, File file) {
        return this.lobHelper.updateBLob(table, pks, fieldName, file);
    }

    @Override
    public ProcessResult<String> updateCLob(String table, List<PkColumnObject> pks, String field, String clob) {
        return this.lobHelper.updateCLob(table, pks, field, clob);
    }

    @Override
    public ProcessResult<String> executeByFile(File file) {
        ProcessResult<String> pr = new ProcessResult<String>();
        SQLExec sqlexec = new SQLExec();
        sqlexec.setSrc(file);
        sqlexec.setPrint(true);
        try {
            sqlexec.execute(this.getDBConnection(), false);
            String data = sqlexec.getResult();
            pr.setData(data);
        }
        catch (Exception e) {
            log.debug((Object)("\u6267\u884c\u6570\u636e\u811a\u672c\u51fa\u9519" + e.getMessage()));
            pr.setMessage("executeByFile \u6267\u884c\u6570\u636e\u811a\u672c\u51fa\u9519~~!");
            pr.setFailing(true);
        }
        pr.setSuccess(true);
        return pr;
    }

    @Override
    public List<FieldDataType> getDataTypes() {
        ArrayList<FieldDataType> fdts = new ArrayList<FieldDataType>();
        fdts.add(new FieldDataType("INTEGER"));
        fdts.add(new FieldDataType("SMALLINT"));
        fdts.add(new FieldDataType("NUMERIC"));
        fdts.add(new FieldDataType("DECIMAL"));
        fdts.add(new FieldDataType("CHAR"));
        fdts.add(new FieldDataType("VARCHAR"));
        fdts.add(new FieldDataType("DATE"));
        fdts.add(new FieldDataType("TIMESTAMP"));
        fdts.add(new FieldDataType("CLOB"));
        fdts.add(new FieldDataType("BLOB"));
        return fdts;
    }
}

