/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.action;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.DBConnectionState;
import cn.com.qimingx.dbe.GridOperator;
import cn.com.qimingx.dbe.action.AbstractDbeActionController;
import cn.com.qimingx.dbe.action.bean.DataExportBean;
import cn.com.qimingx.dbe.action.bean.GridTableFieldInfoBean;
import cn.com.qimingx.dbe.action.bean.GridTableLoadBean;
import cn.com.qimingx.dbe.action.bean.GridTableLongFieldInfoBean;
import cn.com.qimingx.dbe.action.bean.GridTableUpdateBean;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.dbe.service.WorkDirectory;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSON;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.base.util.FileUtil;
import org.ofbiz.base.util.UtilGenerics;

public class DbeGridActionController
extends AbstractDbeActionController {
    private static final Log log = LogFactory.getLog(DbeGridActionController.class);
    private static GridOperator gridOperator = new GridOperator();

    public static void load(HttpServletRequest req, HttpServletResponse resp) {
        GridTableLoadBean param = DbeGridActionController.getGridTableLoadBean(req);
        DbeGridActionController.load(req, resp, param);
    }

    public static void load(HttpServletRequest req, HttpServletResponse resp, GridTableLoadBean param) {
        log.debug((Object)("call dbeGridAction.load,param:" + param));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<JSON> pr = gridOperator.load(service, param);
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, pr.getData().toString());
        } else {
            DbeGridActionController.sendJSON(resp, pr.toJSON());
        }
    }

    public static void update(HttpServletRequest req, HttpServletResponse resp) {
        GridTableUpdateBean param = DbeGridActionController.getGridTableUpdateBean(req);
        DbeGridActionController.update(req, resp, param);
    }

    public static void update(HttpServletRequest req, HttpServletResponse resp, GridTableUpdateBean param) {
        log.debug((Object)("call dbeGridAction.update,param:" + param));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<String> pr = gridOperator.update(service, param);
        if (pr.isFailing()) {
            DbeGridActionController.sendErrorJSON(resp, pr.toJSON());
        } else {
            DbeGridActionController.sendJSON(resp, pr.toJSON());
        }
    }

    public static void remove(HttpServletRequest req, HttpServletResponse resp) {
        GridTableUpdateBean param = DbeGridActionController.getGridTableUpdateBean(req);
        DbeGridActionController.remove(req, resp, param);
    }

    public static void remove(HttpServletRequest req, HttpServletResponse resp, GridTableUpdateBean params) {
        log.debug((Object)("call dbeGridAction.remove,param:" + params));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<String> pr = gridOperator.remove(service, params);
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, pr.toJSON());
        } else {
            DbeGridActionController.sendErrorJSON(resp, pr.toJSON());
        }
    }

    public static void fkvalue(HttpServletRequest req, HttpServletResponse resp) {
        String t = req.getParameter("table");
        String f = req.getParameter("field");
        log.debug((Object)("call dbeGridAction.fkvalue," + t + "." + f));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<JSON> pr = gridOperator.getFKValues(service, t, f);
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, pr.getData().toString());
        } else {
            DbeGridActionController.sendJSON(resp, pr.toJSON());
        }
    }

    public static void export(HttpServletRequest req, HttpServletResponse resp) {
        DataExportBean param = DbeGridActionController.getDataExportBean(req);
        DbeGridActionController.export(req, resp, param);
    }

    public static void export(HttpServletRequest req, HttpServletResponse resp, DataExportBean param) {
        WorkDirectory wd;
        log.debug((Object)("call dbeGridAction.export.params:" + param));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<JSON> pr = gridOperator.export(service, param, wd = DbeGridActionController.workDirectory(req));
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, pr.getData().toString());
        } else {
            DbeGridActionController.sendError(resp, 500, pr.toJSON());
        }
    }

    public static void readlob(HttpServletRequest req, HttpServletResponse resp) {
        GridTableFieldInfoBean param = DbeGridActionController.getGridTableFieldInfoBean(req);
        DbeGridActionController.readlob(req, resp, param);
    }

    public static void readlob(HttpServletRequest req, HttpServletResponse resp, GridTableFieldInfoBean param) {
        WorkDirectory wd;
        log.debug((Object)("call dbeGridAction.readlob:" + param));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<JSON> pr = gridOperator.readLob(service, param, wd = DbeGridActionController.workDirectory(req));
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, pr.getData().toString());
        } else {
            DbeGridActionController.sendError(resp, 500, pr.toJSON());
        }
    }

    public static void updateblob(HttpServletRequest req, HttpServletResponse resp) {
        GridTableLongFieldInfoBean param = DbeGridActionController.getGridTableLongFieldInfoBean(req);
        DbeGridActionController.updateblob(req, resp, param);
    }

    public static void updateblob(HttpServletRequest req, HttpServletResponse resp, GridTableLongFieldInfoBean bean) {
        log.debug((Object)("call dbeGridAction.updateblob,param:" + bean.getName()));
        ServletFileUpload dfu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, FileUtil.getFile((String)"runtime/tmp")));
        List lst = null;
        try {
            lst = UtilGenerics.checkList((Object)dfu.parseRequest(req));
        }
        catch (FileUploadException e) {
            log.debug((Object)("check file error:" + e.getMessage()));
            DbeGridActionController.sendError(resp, 500, "{success:false,msg:'create file error!'}");
            return;
        }
        if (lst.size() == 0) {
            log.debug((Object)"no file error");
            DbeGridActionController.sendError(resp, 500, "{success:false,msg:'No files uploaded!'}");
            return;
        }
        FileItem fi = null;
        String fileName = null;
        for (int i = 0; i < lst.size(); ++i) {
            fi = (FileItem)lst.get(i);
            if (fi.isFormField()) {
                if (fi.getFieldName().equals("field")) {
                    bean.setField(fi.getString());
                    continue;
                }
                if (fi.getFieldName().equals("pkInfo")) {
                    bean.setPkInfo(fi.getString());
                    continue;
                }
                if (!fi.getFieldName().equals("tablename")) continue;
                bean.setTablename(fi.getString());
                continue;
            }
            String fieldName = fi.getFieldName();
            fileName = fi.getName();
            String contentType = fi.getContentType();
            boolean isInMemory = fi.isInMemory();
            long sizeInBytes = fi.getSize();
            break;
        }
        File file = DbeGridActionController.workDirectory(req).newFile(fileName, null);
        try {
            fi.write(file);
        }
        catch (Exception e) {
            log.debug((Object)("create temporary file error:" + e.getMessage()));
            DbeGridActionController.sendError(resp, 500, "{success:false,msg:'create file error!'}");
            return;
        }
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<String> pr = gridOperator.updateBlob(service, bean, file);
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, pr.getData());
        } else {
            DbeGridActionController.sendError(resp, 500, pr.toJSON());
        }
    }

    public static void updateclob(HttpServletRequest req, HttpServletResponse resp) {
        GridTableFieldInfoBean param = DbeGridActionController.getGridTableFieldInfoBean(req);
        DbeGridActionController.updateclob(req, resp, param);
    }

    public static void updateclob(HttpServletRequest req, HttpServletResponse resp, GridTableFieldInfoBean param) {
        log.debug((Object)("call dbeGridAction.updateclob,param:" + param));
        ProcessResult<DBConnectionState> prDBCS = DbeGridActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeGridActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        ProcessResult<Object> pr = null;
        String clob = req.getParameter("clob");
        if (clob == null) {
            pr = new ProcessResult(false);
            pr.setMessage("updateclob Error:clob is null~~!");
            log.error((Object)pr.getMessage());
        } else {
            log.debug((Object)("call dbeGridAction.upload,clob:" + clob));
            DBInfoService service = prDBCS.getData().getDBInfoService();
            pr = gridOperator.updateClob(service, param, clob);
        }
        if (pr.isSuccess()) {
            DbeGridActionController.sendJSON(resp, (CharSequence)pr.getData());
        } else {
            DbeGridActionController.sendError(resp, 500, pr.toJSON());
        }
    }

    private static GridTableLoadBean getGridTableLoadBean(HttpServletRequest req) {
        GridTableLoadBean param = new GridTableLoadBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }

    private static GridTableUpdateBean getGridTableUpdateBean(HttpServletRequest req) {
        GridTableUpdateBean param = new GridTableUpdateBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }

    private static GridTableFieldInfoBean getGridTableFieldInfoBean(HttpServletRequest req) {
        GridTableFieldInfoBean param = new GridTableFieldInfoBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }

    private static GridTableLongFieldInfoBean getGridTableLongFieldInfoBean(HttpServletRequest req) {
        GridTableLongFieldInfoBean param = new GridTableLongFieldInfoBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }

    private static DataExportBean getDataExportBean(HttpServletRequest req) {
        DataExportBean param = new DataExportBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }
}

