/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.FieldDataType;
import cn.com.qimingx.dbe.TableColumnInfo;
import cn.com.qimingx.dbe.TableInfo;
import cn.com.qimingx.dbe.action.bean.TreeNodeBean;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.json.MyJSONUtils;
import cn.com.qimingx.utils.SQLTypeUtils;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeOperator {
    private static final Log log = LogFactory.getLog(TreeOperator.class);

    public ProcessResult<JSON> tree(DBInfoService service, TreeNodeBean node) {
        if (node.getDepth() < 0) {
            return this.getDatabaseName(service);
        }
        if (node.getDepth() == 0) {
            return this.getDBSchemas(service);
        }
        if (node.getDepth() == 1) {
            return this.getDBElementTypes(service);
        }
        if (node.getDepth() == 2) {
            String schema = node.getSchema();
            String type = node.getType();
            return this.getDBElements(service, schema, type);
        }
        if (node.getDepth() == 3) {
            String schema = node.getSchema();
            String name = node.getElementName();
            return this.getTableColumns(service, schema, name);
        }
        log.debug((Object)("not sub nodes:" + node));
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)new JSONArray());
        return pr;
    }

    public ProcessResult<String> drop(DBInfoService service, TreeNodeBean node) {
        ProcessResult<String> pr = new ProcessResult<String>(false);
        String type = node.getType();
        if (!type.equalsIgnoreCase("TABLE") && !type.equalsIgnoreCase("VIEW")) {
            pr.setMessage("\u4e0d\u652f\u6301\u7684dbelement\u7c7b\u578b\uff1a" + type);
            log.error((Object)pr.getMessage());
            return pr;
        }
        String sql = "drop " + type + " " + node.getElementName();
        log.debug((Object)("drop.sql:" + sql));
        return service.executeUpdate(sql, null);
    }

    public ProcessResult<JSON> open(DBInfoService service, TreeNodeBean node) {
        String name = node.getNodeName();
        String type = node.getType();
        if (type.equalsIgnoreCase("table") || type.equalsIgnoreCase("view")) {
            String schema = node.getSchema();
            return TreeOperator.getTableInfo(service, schema, name);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)new JSONArray());
        return pr;
    }

    public static ProcessResult<JSON> getTableInfo(DBInfoService service, String schema, String name) {
        ProcessResult<JSON> pr = new ProcessResult<JSON>();
        ProcessResult<TableInfo> prTableInfo = service.getTableInfo(schema, name);
        if (prTableInfo.isFailing()) {
            pr.setSuccess(false);
            pr.setMessage(prTableInfo.getMessage());
            return pr;
        }
        TableInfo tableInfo = prTableInfo.getData();
        JSON jsont = MyJSONUtils.toJsonExclude(tableInfo, new String[0]);
        JSONObject json = new JSONObject();
        json.element("succeed", true);
        json.element("table", (Object)jsont);
        pr.setSuccess(true);
        pr.setData((JSON)json);
        return pr;
    }

    public ProcessResult<JSON> getTableColumns(DBInfoService service, String schema, String name) {
        ProcessResult<TableInfo> prTableInfo = service.getTableInfo(schema, name);
        List<TableColumnInfo> list = prTableInfo.getData().getColumns();
        JSONArray jsons = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            JSONObject json = new JSONObject();
            TableColumnInfo tci = list.get(i);
            json.element("text", (Object)tci.getName());
            if (tci.isPkColumn()) {
                json.element("icon", (Object)"images/field_key.png");
            } else if (tci.isFkColumn()) {
                json.element("icon", (Object)"images/field_link.png");
            } else {
                json.element("icon", (Object)"images/field.png");
            }
            json.element("leaf", (Object)"true");
            jsons.add((Object)json);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)jsons);
        return pr;
    }

    public ProcessResult<JSON> getDBElements(DBInfoService service, String schema, String type) {
        List<String> list = service.getElements(schema, type);
        JSONArray jsons = new JSONArray();
        for (String element : list) {
            JSONObject json = new JSONObject();
            json.element("text", (Object)element);
            json.element("icon", (Object)"images/table.png");
            jsons.add((Object)json);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)jsons);
        return pr;
    }

    public ProcessResult<JSON> getDBElementTypes(DBInfoService service) {
        List<String> list = service.getElementTypes();
        JSONArray jsons = new JSONArray();
        for (String type : list) {
            JSONObject json = new JSONObject();
            json.element("text", (Object)type);
            json.element("icon", (Object)"images/type.png");
            jsons.add((Object)json);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)jsons);
        return pr;
    }

    public ProcessResult<JSON> getDBSchemas(DBInfoService service) {
        List<String> list = service.getSchemas();
        JSONArray jsons = new JSONArray();
        for (String schema : list) {
            JSONObject json = new JSONObject();
            json.element("text", (Object)schema);
            json.element("icon", (Object)"images/schema.png");
            jsons.add((Object)json);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)jsons);
        return pr;
    }

    public ProcessResult<JSON> getDatabaseName(DBInfoService service) {
        String name = service.getDatabaseName();
        JSONObject json = new JSONObject();
        json.element("text", (Object)name);
        json.element("icon", (Object)"images/database.png");
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)json);
        return pr;
    }

    public ProcessResult<JSON> getDataTypes(DBInfoService service) {
        List<FieldDataType> fdts = service.getDataTypes();
        JSONArray jsonArray = new JSONArray();
        for (FieldDataType fdt : fdts) {
            jsonArray.add((Object)fdt.toJSON());
        }
        JSONObject json = new JSONObject();
        json.element("types", (Collection)jsonArray);
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)json);
        return pr;
    }

    public ProcessResult<JSON> loadColumn(DBInfoService service, TreeNodeBean param) {
        ProcessResult<TableInfo> prData = service.getTableInfo(param.getSchema(), param.getText());
        List<TableColumnInfo> columns = prData.getData().getColumns();
        JSONArray jsonArray = new JSONArray();
        for (TableColumnInfo column : columns) {
            JSONObject jsonData = new JSONObject();
            jsonData.put((Object)"columName", (Object)column.getName());
            jsonData.put((Object)"dataType", (Object)SQLTypeUtils.getJdbcTypeName(column.getType()));
            jsonData.put((Object)"maxlength", (Object)column.getSize());
            jsonData.put((Object)"isNull", (Object)column.isNullable());
            jsonArray.add((Object)jsonData);
        }
        JSONObject json = new JSONObject();
        json.element("columns", (Collection)jsonArray);
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)json);
        return pr;
    }
}

