/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.TableColumnInfo;
import cn.com.qimingx.dbe.TableDataInfo;
import cn.com.qimingx.dbe.service.WorkDirectory;
import cn.com.qimingx.utils.ExtTypeInfo;
import cn.com.qimingx.utils.PDFUtils;
import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableInfo {
    private static final Log log = LogFactory.getLog(TableDataInfo.class);
    private String tableName;
    private String pkColumnName;
    private List<TableColumnInfo> columns;
    private TableDataInfo data;
    private boolean readOnly = true;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TableInfo() {
    }

    public TableInfo(String pkColumnName, List<TableColumnInfo> columns) {
        this.pkColumnName = pkColumnName;
        this.columns = columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult<File> makeDataFile(String fileType, WorkDirectory wd) {
        ProcessResult<File> pr = new ProcessResult<File>();
        if (!this.isSupportType(fileType)) {
            pr.setMessage("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\u7c7b\u578b\uff1a" + fileType);
            return pr;
        }
        File file = wd.newFile(fileType, ".tmp");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            BufferedWriter buffer = new BufferedWriter(writer);
            if (fileType.equalsIgnoreCase("CSV")) {
                this.makeCSVContent(buffer);
            } else if (fileType.equalsIgnoreCase("HTML")) {
                this.makeHTMLContent(buffer);
            } else if (fileType.equalsIgnoreCase("PDF")) {
                this.makePDFContent(stream);
            } else {
                this.makeSQLContent(buffer);
            }
            pr.setSuccess(true);
            pr.setData(file);
        }
        catch (IOException e) {
            try {
                pr.setMessage("\u5199\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
                log.error((Object)pr.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        IOUtils.closeQuietly((OutputStream)stream);
        return pr;
    }

    private void makeSQLContent(BufferedWriter writer) throws IOException {
        List<Map<String, Object>> rows = this.data.getRows();
        if (rows.size() < 1) {
            return;
        }
        String insert = "";
        for (TableColumnInfo tableColumnInfo : this.getColumns()) {
            String name = tableColumnInfo.getName();
            if (insert.length() > 0) {
                insert = insert + ",";
            }
            insert = insert + name;
        }
        insert = "insert to " + this.getTableName() + "(" + insert + ") values(";
        for (Map map : rows) {
            String row = "";
            for (TableColumnInfo column : this.getColumns()) {
                Object value = map.get(column.getName());
                String col = "NULL";
                if (value != null) {
                    col = value.toString();
                    ExtTypeInfo type = column.getExtType();
                    if (type.isDateType()) {
                        col = "toDate('" + col + "' HH24:mm)";
                    } else if (!type.isBooleanType() || !type.isNumberType()) {
                        col = "'" + col + "'";
                    }
                }
                if (row.length() > 0) {
                    row = row + ",";
                }
                row = row + col;
            }
            writer.write(insert + row + ")");
            writer.newLine();
        }
        writer.flush();
    }

    private void makePDFContent(OutputStream stream) throws IOException {
        List<Map<String, Object>> rows = this.data.getRows();
        if (rows.size() < 1) {
            return;
        }
        Document pdfDoc = new Document();
        try {
            PdfWriter.getInstance((Document)pdfDoc, (OutputStream)stream);
            Map<String, Object> row = rows.get(0);
            Set<String> columns = row.keySet();
            Table table = new Table(columns.size());
            table.setWidth(90.0f);
            table.setAutoFillEmptyCells(true);
            table.setPadding(3.0f);
            table.setSpacing(0.0f);
            table.setBorder(1);
            for (TableColumnInfo tableColumnInfo : this.getColumns()) {
                String name = tableColumnInfo.getName();
                Phrase phe = new Phrase(name, PDFUtils.createChineseFont());
                Cell cell = new Cell((Element)phe);
                cell.setHorizontalAlignment(0);
                cell.setVerticalAlignment(5);
                table.addCell(new Cell((Element)phe));
            }
            for (Map map : rows) {
                for (TableColumnInfo column : this.getColumns()) {
                    Object value = map.get(column.getName());
                    String col = "\u3000";
                    if (value != null) {
                        col = value.toString();
                    }
                    Phrase phe = new Phrase(col, PDFUtils.createChineseFont());
                    Cell cell = new Cell((Element)phe);
                    cell.setHorizontalAlignment(0);
                    cell.setVerticalAlignment(5);
                    table.addCell(new Cell((Element)phe));
                }
            }
            pdfDoc.open();
            pdfDoc.add((Element)table);
        }
        catch (DocumentException e) {
            log.error((Object)("create PDFDocument error:" + e.getMessage()));
            throw new IOException("create PDFDocument Error");
        }
        finally {
            if (pdfDoc.isOpen()) {
                pdfDoc.close();
            }
        }
    }

    private void makeHTMLContent(BufferedWriter writer) throws IOException {
        List<Map<String, Object>> rows = this.data.getRows();
        writer.write("<html><head>");
        writer.write("<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'/>");
        writer.write("</head><body><table border='1' width='95%'>");
        String header = "";
        for (TableColumnInfo tableColumnInfo : this.getColumns()) {
            String name = tableColumnInfo.getName();
            header = header + "<td>" + name + "</td>";
        }
        writer.write("<tr>" + header + "</tr>");
        for (Map map : rows) {
            String row = "";
            for (TableColumnInfo column : this.getColumns()) {
                Object value = map.get(column.getName());
                String col = value == null ? "<NULL>" : value.toString();
                row = row + "<td>" + col + "</td>";
            }
            writer.write("<tr>" + row + "</tr>");
        }
        writer.write("</table></body></html>");
        writer.flush();
    }

    private void makeCSVContent(BufferedWriter writer) throws IOException {
        List<Map<String, Object>> rows = this.data.getRows();
        for (Map<String, Object> map : rows) {
            String row = "";
            for (TableColumnInfo column : this.getColumns()) {
                row = row + map.get(column.getName()) + ";";
            }
            writer.write(row);
            writer.newLine();
        }
        writer.flush();
    }

    private boolean isSupportType(String type) {
        return (type = type.toUpperCase()).equals("CSV") || type.equals("HTML") || type.equals("PDF") || type.equals("SQL");
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public void setPkColumnName(String pkColumnName) {
        this.pkColumnName = pkColumnName;
    }

    public List<TableColumnInfo> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<TableColumnInfo>();
        }
        return this.columns;
    }

    public void setColumns(List<TableColumnInfo> columns) {
        this.columns = columns;
    }

    public TableDataInfo getData() {
        return this.data;
    }

    public void setData(TableDataInfo data) {
        this.data = data;
    }
}

