/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.TableColumnInfo;
import cn.com.qimingx.dbe.TableDataInfo;
import cn.com.qimingx.dbe.TableInfo;
import cn.com.qimingx.dbe.action.bean.GridQueryLoadBean;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.json.MyJSONUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONFunction;
import net.sf.json.JSONObject;

public class SQLQueryOperator {
    public ProcessResult<JSON> execute(DBInfoService service, GridQueryLoadBean param) {
        String sql = param.getSql();
        if (sql != null || sql.length() > 0) {
            if (sql.startsWith("SELECT") || sql.startsWith("select")) {
                return this.executeQuery(sql, service, param);
            }
            return this.executeUpdate(sql, service, param);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>();
        pr.setMessage("sql sentence invalid~!");
        return pr;
    }

    private ProcessResult<JSON> executeUpdate(String sql, DBInfoService service, GridQueryLoadBean param) {
        ProcessResult<String> pr = service.executeUpdate(sql, null);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>(1);
        columns.add(new TableColumnInfo("Result", 12, 100, true));
        HashMap<String, String> row = new HashMap<String, String>(1);
        row.put("Result", pr.getMessage());
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(1);
        rows.add(row);
        TableDataInfo data = new TableDataInfo(1L, rows);
        TableInfo tableInfo = new TableInfo();
        tableInfo.setColumns(columns);
        tableInfo.setData(data);
        ProcessResult<JSON> ppr = new ProcessResult<JSON>(pr.isSuccess());
        if (ppr.isSuccess()) {
            ppr.setData(this.makeQueryResult(tableInfo));
        } else {
            ppr.setMessage(pr.getMessage());
        }
        return ppr;
    }

    private ProcessResult<JSON> executeQuery(String sql, DBInfoService service, GridQueryLoadBean param) {
        int start = param.getStart();
        int limit = param.getLimit();
        String condition = param.getSearchCondition();
        ProcessResult<TableInfo> prtInfo = service.executeQuery(sql, start, limit, condition);
        ProcessResult<JSON> pr = new ProcessResult<JSON>();
        if (prtInfo.isFailing()) {
            pr.setFailing(true);
            pr.setMessage(prtInfo.getMessage());
        } else {
            pr.setSuccess(true);
            pr.setData(this.makeQueryResult(prtInfo.getData()));
        }
        return pr;
    }

    private JSON makeQueryResult(TableInfo tableInfo) {
        JSONArray jsonFields = new JSONArray();
        for (TableColumnInfo column : tableInfo.getColumns()) {
            JSON jsonExtType = MyJSONUtils.toJsonExclude(column.getExtType(), new String[0]);
            JSONObject jsonField = new JSONObject();
            jsonField.element("name", (Object)column.getName());
            jsonField.element("type", (Object)column.getExtType().getType());
            jsonField.element("extType", (Object)jsonExtType);
            if (column.getExtType().isDateType()) {
                String[] args = new String[]{"value", "record"};
                String script = "if (value.time) return new Date(value.time);";
                script = script + "else return value;";
                JSONFunction jsonFun = new JSONFunction(args, script);
                jsonField.element("convert", (Object)jsonFun);
            }
            jsonFields.add((Object)jsonField);
        }
        JSONObject metaData = new JSONObject();
        metaData.element("totalProperty", (Object)"total");
        metaData.element("root", (Object)"rows");
        metaData.element("fields", (Collection)jsonFields);
        JSONArray rows = new JSONArray();
        for (Map<String, Object> row : tableInfo.getData().getRows()) {
            JSONObject jsonData = new JSONObject();
            for (String key : row.keySet()) {
                jsonData.element(key, row.get(key));
            }
            rows.add((Object)jsonData);
        }
        JSONObject json = new JSONObject();
        json.element("metaData", (Map)metaData);
        json.element("total", tableInfo.getData().getTotal());
        json.element("rows", (Collection)rows);
        return json;
    }
}

