/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.dbe.DBTypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBEConfig {
    private static final Log log = LogFactory.getLog(DBEConfig.class);
    public static final String CONF_FILE = "/dbe_config.js";
    private static final DBEConfig config = new DBEConfig();
    private Map<String, DBTypeInfo> dbtypes;
    private String dbtypeOptions;

    public static void main(String[] args) {
        DBEConfig.getInstance();
    }

    public static DBEConfig getInstance() {
        return config;
    }

    public DBTypeInfo getDBTypeInfo(String name) {
        return this.dbtypes.get(name);
    }

    public String getDBTypeOptions() {
        return this.dbtypeOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBEConfig() {
        JSONObject json;
        InputStream input;
        block5: {
            input = null;
            json = null;
            try {
                input = this.getClass().getResourceAsStream(CONF_FILE);
                if (input == null) break block5;
                StringWriter output = new StringWriter();
                IOUtils.copy((InputStream)input, (Writer)output, (String)"utf-8");
                json = JSONObject.fromObject((Object)output.toString());
            }
            catch (IOException e) {
                try {
                    log.error((Object)("DBConfig file Error:" + e.getMessage()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        JSONArray jsonDBTypes = json.getJSONArray("dbtypes");
        Collection typeList = JSONArray.toCollection((JSONArray)jsonDBTypes, DBTypeInfo.class);
        this.dbtypes = new HashMap<String, DBTypeInfo>(typeList.size());
        JSONArray jsonOptions = new JSONArray();
        for (DBTypeInfo type : typeList) {
            this.dbtypes.put(type.getName(), type);
            JSONObject jsonOpt = new JSONObject();
            jsonOpt.element("key", (Object)type.getName());
            jsonOpt.element("value", (Object)type.getUrl());
            jsonOptions.add((Object)jsonOpt);
        }
        JSONObject jsonDBTypeOptions = new JSONObject();
        jsonDBTypeOptions.element("types", (Collection)jsonOptions);
        this.dbtypeOptions = jsonDBTypeOptions.toString();
    }

    public Iterator<String> getDbTypeNames() {
        Iterator<String> it = this.dbtypes.keySet().iterator();
        return it;
    }
}

