/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.DBEConfig;
import cn.com.qimingx.dbe.DBTypeInfo;
import cn.com.qimingx.dbe.action.bean.ConnectParamBean;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.dbe.service.impl.DefaultDBInfoService;
import cn.com.qimingx.utils.MyUtils;
import cn.com.qimingx.utils.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.entity.GenericDelegator;
import org.ofbiz.entity.GenericEntityException;
import org.ofbiz.entity.jdbc.ConnectionFactory;

public class DBConnectionState
implements Serializable {
    private static final Log log = LogFactory.getLog(DBConnectionState.class);
    private static final long serialVersionUID = 8886397095815863532L;
    private static final String KEY_CURRENT_STATE = "cn.com.qimingx.dbe.DBConnectionState.KEY";
    private transient Connection dbConnection;
    private transient DBTypeInfo dbType;
    private transient DBInfoService service;

    private DBConnectionState(Connection conn, DBTypeInfo dbtype) {
        this.dbConnection = conn;
        this.dbType = dbtype;
    }

    public static DBConnectionState current(HttpSession sess) {
        Object obj = sess.getAttribute(KEY_CURRENT_STATE);
        if (obj == null) {
            return null;
        }
        return (DBConnectionState)obj;
    }

    public static boolean isConnection(HttpSession sess) {
        if (sess == null) {
            return false;
        }
        DBConnectionState dbcs = DBConnectionState.current(sess);
        return dbcs == null ? false : dbcs.isConnection();
    }

    public static ProcessResult<String> connect(ConnectParamBean param, HttpSession sess) {
        String typeName = param.getDbtype();
        DBTypeInfo type = DBEConfig.getInstance().getDBTypeInfo(typeName);
        ProcessResult<String> pr = new ProcessResult<String>();
        try {
            String url = param.getUrl();
            String user = param.getUser();
            String passwd = param.getPassword();
            GenericDelegator delegator = (GenericDelegator)sess.getServletContext().getAttribute("delegator");
            String helperName = delegator.getGroupHelperName("org.ofbiz");
            Connection conn = ConnectionFactory.getConnection((String)helperName);
            DBConnectionState dbcs = new DBConnectionState(conn, type);
            sess.setAttribute(KEY_CURRENT_STATE, (Object)dbcs);
            pr.setSuccess(true);
            return pr;
        }
        catch (GenericEntityException e) {
            String msg = "OFbiz connection Error:" + e.getMessage();
            log.error((Object)msg);
            pr.setMessage(msg);
            return pr;
        }
        catch (SQLException e) {
            String msg = "Database connection Error:" + e.getMessage();
            log.error((Object)msg);
            pr.setMessage(msg);
            return pr;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy(HttpSession sess) {
        if (this.dbConnection != null) {
            try {
                if (this.dbConnection.isClosed()) {
                    // empty if block
                }
            }
            catch (SQLException e) {
                log.error((Object)("Close DB Connect Error:" + e.getMessage()));
            }
        }
        sess.removeAttribute(KEY_CURRENT_STATE);
    }

    public JSON getDBProperties(Locale locale) {
        try {
            DatabaseMetaData dbmd = this.dbConnection.getMetaData();
            JSONArray items = new JSONArray();
            Map<String, String> map = SQLUtils.getDBInfos(dbmd, locale);
            for (String name : map.keySet()) {
                JSONObject data = new JSONObject();
                data.element("name", (Object)name);
                data.element("value", (Object)map.get(name));
                items.add((Object)data);
            }
            JSONArray fields = new JSONArray();
            JSONObject field = new JSONObject();
            field.element("name", (Object)"name");
            fields.add((Object)field);
            field = new JSONObject();
            field.element("name", (Object)"value");
            fields.add((Object)field);
            JSONObject meta = new JSONObject();
            meta.element("totalProperty", (Object)"total");
            meta.element("root", (Object)"items");
            meta.element("fields", (Collection)fields);
            JSONObject json = new JSONObject();
            json.element("metaData", (Map)meta);
            json.element("total", 100);
            json.element("items", (Collection)items);
            return json;
        }
        catch (SQLException e) {
            String msg = "getDBProperties Error:" + e.getMessage();
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    public DBInfoService getDBInfoService() {
        if (this.service == null) {
            String clsName = this.dbType.getService();
            Object o = MyUtils.newObjectOfClassName(clsName);
            this.service = o != null ? (DBInfoService)o : new DefaultDBInfoService();
            this.service.setDBConnection(this.dbConnection);
            log.debug((Object)("use " + this.service.getClass().getName() + " instance"));
        }
        return this.service;
    }

    public boolean isConnection() {
        boolean bool;
        boolean bl = bool = this.dbConnection != null;
        if (bool) {
            try {
                return !this.dbConnection.isClosed();
            }
            catch (SQLException e) {
                log.error((Object)("call isConnection.isClosed.error:" + e.getMessage()));
                return false;
            }
        }
        return false;
    }
}

