#pragma once
#ifdef _DEBUG
//
//IuVFNg[N`FbJ[ hacked by rti
//
//
#include <windows.h>
#include <process.h>
#include <imagehlp.h>
#include <process.h>
#include <tlhelp32.h>
#include <stdio.h>
#pragma comment(lib,"dbghelp.lib")

//VC++6 ̃JNbVƂ̂Ŏ߂ɂ
//#pragma comment(linker, "/MAPINFO:EXPORTS") // }bvt@CɃGNX|[gꂽ֐܂߂
//#pragma comment(linker, "/MAPINFO:FIXUPS")  // }bvt@CɃx[XP[V܂߂
//#pragma comment(linker, "/MAPINFO:LINES")   // }bvt@Cɍsԍ܂߂


//ǂ̂ƒɂ TRACE
static void OBCHECK_TRACE(const char* Format,...)
{
	char buffer[1024];
	_vsnprintf(buffer,1024,Format,(char*)(&Format+1));
	OutputDebugString( buffer );
}

//u[N
#define OBCHECK_BREAKPOINT() \
	{ \
		MSG msg;	\
		BOOL quit = PeekMessage(&msg, NULL, WM_QUIT, WM_QUIT, PM_REMOVE);	\
		if (quit)	PostQuitMessage(msg.wParam);	\
		__asm { int 3 }; \
	} 

//ASSERT
#define OBCHECK_ASSERT(f) \
	if (!(f) ) \
	{ \
		OBCHECK_BREAKPOINT();\
	} 


/*
*
*ʓ|Ȓ`ȒPɋLq邽߂̉}N(ד)
*[[ד̓RRɂˁB
*
*/

//IWi̊֐
#define OBCHECK_ORIGNAL_FUNCTION(NAME) Orignal##NAME
//IWi̊֐Ăяo
#define OBCHECK_ORIGNAL_CALL(NAME) (Orignal##NAME == NULL ? NAME : Orignal##NAME)

//API tbN   "NAME" }NWJȂ VC̓Az
#define OBCHECK_APIHOOK(DLL,NAMESTRING,NAME,IS_HOOK) \
if (IS_HOOK){ \
APIHookFunction(DLL , NAMESTRING , (PROC)HookFunction##NAME , (PROC*) &Orignal##NAME ); \
}else{ \
APIUnHookFunction(DLL , (PROC)HookFunction##NAME , (PROC)Orignal##NAME , (PROC*) &Orignal##NAME ); \
}

//0
#define OBCHECK_HOOK_METHOD_0(RET,NAME)\
typedef RET (WINAPI * Hook##NAME##Def)(); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##()

//1
#define OBCHECK_HOOK_METHOD_1(RET,NAME,A1) \
typedef RET (WINAPI * Hook##NAME##Def)(A1); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1)

//2
#define OBCHECK_HOOK_METHOD_2(RET,NAME,A1,A2) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2)

//3
#define OBCHECK_HOOK_METHOD_3(RET,NAME,A1,A2,A3) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3)

//4
#define OBCHECK_HOOK_METHOD_4(RET,NAME,A1,A2,A3,A4) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4)

//5
#define OBCHECK_HOOK_METHOD_5(RET,NAME,A1,A2,A3,A4,A5) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4,A5); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4,A5)

//6
#define OBCHECK_HOOK_METHOD_6(RET,NAME,A1,A2,A3,A4,A5,A6) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4,A5,A6); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4,A5,A6)

//7
#define OBCHECK_HOOK_METHOD_7(RET,NAME,A1,A2,A3,A4,A5,A6,A7) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4,A5,A6,A7); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4,A5,A6,A7)

//8
#define OBCHECK_HOOK_METHOD_8(RET,NAME,A1,A2,A3,A4,A5,A6,A7,A8) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4,A5,A6,A7,A8); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4,A5,A6,A7,A8)

//9
#define OBCHECK_HOOK_METHOD_9(RET,NAME,A1,A2,A3,A4,A5,A6,A7,A8,A9) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4,A5,A6,A7,A8,A9); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4,A5,A6,A7,A8,A9)

//10
#define OBCHECK_HOOK_METHOD_10(RET,NAME,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10) \
typedef RET (WINAPI * Hook##NAME##Def)(A1,A2,A3,A4,A5,A6,A7,A8,A9,A10); \
static Hook##NAME##Def Orignal##NAME = NULL ; \
static RET WINAPI HookFunction##NAME##(A1,A2,A3,A4,A5,A6,A7,A8,A9,A10)


enum AllocType
{
	Method_HeapCreate,	//s[v
	Method_HeapAlloc,	//s[v
	Method_Handle,		//enhn CloseHandleŕ
	Method_Reg,			//WXg
	Method_FindFirst,	//FindFirst
};

//IuWFNgmۂƂL^.
struct ObCheckAutoAllocObject
{
	void*		ObjectHandle;
	AllocType	AllocType;
	char		Filename[MAX_PATH];
	int			LineNumber;
	int			Count;
	ObCheckAutoAllocObject*	Next;
};

//ĎXgɍ폜
extern void Obcheck_Add(void* inObjectHandle , AllocType inAllocType);
//ĎXg폜
extern void Obcheck_Del(void* inObjectHandle , AllocType inAllocType);



OBCHECK_HOOK_METHOD_1(BOOL,CloseHandle,HANDLE hObject)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(CloseHandle)(hObject);
	if (r)
	{
		Obcheck_Del( hObject , Method_Handle );
	}
	return r;	
}

//q[v
OBCHECK_HOOK_METHOD_3(LPVOID,HeapAlloc,HANDLE hHeap,DWORD dwFlags,SIZE_T dwBytes)
{
	LPVOID r = OBCHECK_ORIGNAL_FUNCTION(HeapAlloc)(hHeap,dwFlags,dwBytes);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_HeapAlloc );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(BOOL,HeapFree,HANDLE hHeap,DWORD dwFlags,LPVOID lpMem)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(HeapFree)(hHeap,dwFlags,lpMem);
	if (r)
	{
		Obcheck_Del( lpMem , Method_HeapAlloc );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_4(LPVOID,HeapReAlloc,HANDLE hHeap,DWORD dwFlags,LPVOID lpMem,SIZE_T dwBytes)
{
	LPVOID r = OBCHECK_ORIGNAL_FUNCTION(HeapReAlloc)(hHeap,dwFlags,lpMem,dwBytes);
	if (r != NULL)
	{
		Obcheck_Del( lpMem , Method_HeapAlloc );
		Obcheck_Add( r , Method_HeapAlloc );
	}
	return r;	
}

OBCHECK_HOOK_METHOD_3(HANDLE,HeapCreate,DWORD flOptions,SIZE_T dwInitialSize,SIZE_T dwMaximumSize)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(HeapCreate)(flOptions,dwInitialSize,dwMaximumSize);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_HeapCreate );
	}
	return r;
}

OBCHECK_HOOK_METHOD_1(BOOL,HeapDestroy,HANDLE hHeap)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(HeapDestroy)(hHeap);
	if (r)
	{
		Obcheck_Del( hHeap , Method_HeapCreate );
	}
	return r;	
}

//DuplicateHandle
OBCHECK_HOOK_METHOD_7(BOOL,DuplicateHandle,HANDLE hSourceProcessHandle,HANDLE hSourceHandle,HANDLE hTargetProcessHandle,LPHANDLE lpTargetHandle,DWORD dwDesiredAccess,BOOL bInheritHandle,DWORD dwOptions)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(DuplicateHandle)(hSourceProcessHandle, hSourceHandle, hTargetProcessHandle, lpTargetHandle, dwDesiredAccess, bInheritHandle, dwOptions);
	if (r)
	{
		Obcheck_Add( *lpTargetHandle , Method_Handle );
	}
	return r;	
}
//Cxg
OBCHECK_HOOK_METHOD_3(HANDLE,OpenEventA,DWORD dwDesiredAccess,BOOL bInheritHandle,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(OpenEventA)(dwDesiredAccess,bInheritHandle,lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_4(HANDLE,CreateEventA,LPSECURITY_ATTRIBUTES lpEventAttributes,BOOL bManualReset,BOOL bInitialState,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateEventA)(lpEventAttributes,bManualReset,bInitialState,lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
//vZX
OBCHECK_HOOK_METHOD_10(BOOL,CreateProcessA,LPCTSTR lpApplicationName,LPTSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,LPVOID lpEnvironment,LPCTSTR lpCurrentDirectory,LPSTARTUPINFO lpStartupInfo,LPPROCESS_INFORMATION lpProcessInformation)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(CreateProcessA)(lpApplicationName,lpCommandLine,lpProcessAttributes,lpThreadAttributes,bInheritHandles,dwCreationFlags,lpEnvironment,lpCurrentDirectory,lpStartupInfo,lpProcessInformation);
	if (r)
	{
		if (lpProcessInformation != NULL)
		{
			Obcheck_Add( lpProcessInformation->hThread  , Method_Handle );
			Obcheck_Add( lpProcessInformation->hProcess , Method_Handle );
		}
	}
	return r;	
}
//t@C
OBCHECK_HOOK_METHOD_7(HANDLE,CreateFileA,LPCTSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateFileA)(lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
	if (r != INVALID_HANDLE_VALUE)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
//t@C}bsO
OBCHECK_HOOK_METHOD_6(HANDLE,CreateFileMappingA,HANDLE hFile,LPSECURITY_ATTRIBUTES lpAttributes,DWORD flProtect,DWORD dwMaximumSizeHigh,DWORD dwMaximumSizeLow,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateFileMappingA)(hFile,lpAttributes,flProtect,dwMaximumSizeHigh,dwMaximumSizeLow,lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(HANDLE,OpenFileMappingA,DWORD dwDesiredAccess,BOOL bInheritHandle,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(OpenFileMappingA)(dwDesiredAccess,bInheritHandle,lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
//Xbh
OBCHECK_HOOK_METHOD_6(HANDLE,CreateThread,LPSECURITY_ATTRIBUTES lpThreadAttributes,DWORD dwStackSize,LPTHREAD_START_ROUTINE lpStartAddress,LPVOID lpParameter,DWORD dwCreationFlags,LPDWORD lpThreadId)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateThread)(lpThreadAttributes,dwStackSize,lpStartAddress,lpParameter,dwCreationFlags,lpThreadId);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
//~[eBbNX
OBCHECK_HOOK_METHOD_3(HANDLE,CreateMutexA,LPSECURITY_ATTRIBUTES lpMutexAttributes,BOOL bInitialOwner,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateMutexA)(lpMutexAttributes,bInitialOwner,lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(HANDLE,OpenMutexA,DWORD dwDesiredAccess,BOOL bInheritHandle,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(OpenMutexA)(dwDesiredAccess,bInheritHandle,lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
//Z}tH
OBCHECK_HOOK_METHOD_4(HANDLE,CreateSemaphoreA,LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,LONG lInitialCount,LONG lMaximumCount,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateSemaphoreA)(lpSemaphoreAttributes, lInitialCount, lMaximumCount, lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(HANDLE,OpenSemaphoreA,DWORD dwDesiredAccess,BOOL bInheritHandle,LPCTSTR lpName)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(OpenSemaphoreA)(dwDesiredAccess, bInheritHandle, lpName);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}
//pCv
OBCHECK_HOOK_METHOD_8(HANDLE,CreateNamedPipeA,LPCTSTR lpName,DWORD dwOpenMode,DWORD dwPipeMode,DWORD nMaxInstances,DWORD nOutBufferSize,DWORD nInBufferSize,DWORD nDefaultTimeOut,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateNamedPipeA)(lpName, dwOpenMode, dwPipeMode, nMaxInstances, nOutBufferSize, nInBufferSize, nDefaultTimeOut, lpSecurityAttributes);
	if (r != NULL)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;	
}

OBCHECK_HOOK_METHOD_4(BOOL,CreatePipe,PHANDLE hReadPipe,PHANDLE hWritePipe,LPSECURITY_ATTRIBUTES lpPipeAttributes,DWORD nSize)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(CreatePipe)(hReadPipe, hWritePipe, lpPipeAttributes, nSize);
	if (r != NULL)
	{
		Obcheck_Add( *hReadPipe , Method_Handle );
		Obcheck_Add( *hWritePipe , Method_Handle );
	}
	return r;	
}


//WXg
OBCHECK_HOOK_METHOD_5(LONG,RegOpenKeyExA,HKEY hKey,LPCTSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult)
{
	LONG r = OBCHECK_ORIGNAL_FUNCTION(RegOpenKeyExA)(hKey, lpSubKey, ulOptions, samDesired, phkResult);
	if (r == ERROR_SUCCESS )
	{
		Obcheck_Add( *phkResult , Method_Reg );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(LONG,RegOpenKeyA,HKEY hKey,LPCSTR lpSubKey,PHKEY phkResult)
{
	LONG r = OBCHECK_ORIGNAL_FUNCTION(RegOpenKeyA)(hKey,lpSubKey,phkResult);
	if (r == ERROR_SUCCESS )
	{
		Obcheck_Add( *phkResult , Method_Reg );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(LONG,RegConnectRegistryA,LPCTSTR lpMachineName,HKEY hKey,PHKEY phkResult)
{
	LONG r = OBCHECK_ORIGNAL_FUNCTION(RegConnectRegistryA)( lpMachineName, hKey, phkResult);
	if (r == ERROR_SUCCESS )
	{
		Obcheck_Add( *phkResult , Method_Reg );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_1(LONG,RegCloseKey,HKEY hKey)
{
	LONG r = OBCHECK_ORIGNAL_FUNCTION(RegCloseKey)( hKey );
	if (r == ERROR_SUCCESS )
	{
		Obcheck_Del( hKey , Method_Reg );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_9(LONG,RegCreateKeyExA,HKEY hKey,LPCTSTR lpSubKey,DWORD Reserved,LPTSTR lpClass,DWORD dwOptions,REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,PHKEY phkResult,LPDWORD lpdwDisposition)
{
	LONG r = OBCHECK_ORIGNAL_FUNCTION(RegCreateKeyExA)( hKey, lpSubKey, Reserved, lpClass, dwOptions, samDesired, lpSecurityAttributes, phkResult, lpdwDisposition );
	if (r == ERROR_SUCCESS )
	{
		Obcheck_Add( *phkResult , Method_Reg );
	}
	return r;	
}
OBCHECK_HOOK_METHOD_3(LONG,RegCreateKeyA,HKEY hKey,LPCSTR lpSubKey,PHKEY phkResult)
{
	LONG r = OBCHECK_ORIGNAL_FUNCTION(RegCreateKeyA)(  hKey, lpSubKey, phkResult);
	if (r == ERROR_SUCCESS )
	{
		Obcheck_Add( *phkResult , Method_Reg );
	}
	return r;	
}
//FindFirst
OBCHECK_HOOK_METHOD_2(HANDLE,FindFirstFileA,LPCSTR lpFileName,LPWIN32_FIND_DATAA lpFindFileData)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(FindFirstFileA)( lpFileName, lpFindFileData);
	if (r != INVALID_HANDLE_VALUE )
	{
		Obcheck_Add( r , Method_FindFirst );
	}
	return r;
}
OBCHECK_HOOK_METHOD_1(BOOL,FindClose,HANDLE hFindFile)
{
	BOOL r = OBCHECK_ORIGNAL_FUNCTION(FindClose)( hFindFile );
	if (r)
	{
		Obcheck_Del( hFindFile , Method_FindFirst );
	}
	return r;
}
//CreateToolhelp32Snapshot
OBCHECK_HOOK_METHOD_2(HANDLE,CreateToolhelp32Snapshot,DWORD Flags, DWORD ProcessID)
{
	HANDLE r = OBCHECK_ORIGNAL_FUNCTION(CreateToolhelp32Snapshot)( Flags , ProcessID );
	if (r != INVALID_HANDLE_VALUE)
	{
		Obcheck_Add( r , Method_Handle );
	}
	return r;
}

//X^bNg[X
class StackTrace
{
public:
	StackTrace()
	{
		this->CurrentProccessHandle = NULL;
		this->CurrentThreadHandle = NULL;

		this->BaseAddress = 0;
		this->FunctionName[0] = '\0';
		this->Filename[0] = '\0';
		this->LineNumber = 0;
	}
	~StackTrace()
	{
		//͕ȂĂ.
		this->CurrentProccessHandle = NULL;

		//͕
		if (this->CurrentThreadHandle)
		{
			OBCHECK_ORIGNAL_CALL(CloseHandle)(this->CurrentThreadHandle);
			this->CurrentThreadHandle = NULL;
		}
	}

	//֐
	const char* GetFunctionName() const
	{
		return this->FunctionName;
	}
	//擾t@C
	const char* GetFilename() const
	{
		return this->Filename;
	}
	//擾sԍ
	int GetLineNumber() const
	{
		return this->LineNumber;
	}
	//x[XAhX
	int GetBaseAddress() const
	{
		return this->BaseAddress;
	}
	

private:
	//݂̃vZXnh
	HANDLE CurrentProccessHandle;
	//݂̃Xbhnh
	HANDLE CurrentThreadHandle;

	//֐
	char FunctionName[MAX_PATH];
	//擾t@C
	char Filename[MAX_PATH];
	//擾sԍ
	int  LineNumber;
	//x[XAhX
	DWORD	BaseAddress;

private:
//	static unsigned long __stdcall _Start(void* inThis)
	static unsigned int __stdcall _Start(void* inThis)
	{
		return ((StackTrace*)inThis)->Run();
	}


	//X^bN擾Xbh̒
	unsigned int Run()
	{
		OBCHECK_ASSERT(this->CurrentThreadHandle != NULL);

		//܂AXbh~.
		::SuspendThread(this->CurrentThreadHandle);

		StackDump();

		//̂ŕA.
		::ResumeThread(this->CurrentThreadHandle);

		return 0;
	}

	//X^bNg[X
	void StackDump()
	{
		OBCHECK_ASSERT(this->CurrentThreadHandle != NULL);

		this->CurrentProccessHandle = ::GetCurrentProcess();

		BOOL r;

		//Xbh̃ReLXgQbg
		CONTEXT threadContext = {0};
		threadContext.ContextFlags = CONTEXT_FULL;
		r = ::GetThreadContext(this->CurrentThreadHandle , &threadContext);
		if (!r)
		{
			OBCHECK_ASSERT(0);
			return ;
		}

		//Xbh̃X^bN̏͂Ȋ.
		STACKFRAME stackFrame = {0};
		stackFrame.AddrPC.Offset    = threadContext.Eip;
		stackFrame.AddrStack.Offset = threadContext.Esp;
		stackFrame.AddrFrame.Offset = threadContext.Ebp;

		stackFrame.AddrPC.Mode      = AddrModeFlat;
		stackFrame.AddrStack.Mode   = AddrModeFlat;
		stackFrame.AddrFrame.Mode   = AddrModeFlat;
		stackFrame.AddrReturn.Mode  = AddrModeFlat;
		stackFrame.AddrBStore.Mode  = AddrModeFlat;

		DWORD baseOfImage = 0;
		char moduleName[MAX_PATH] = {0};
		char functionName[MAX_PATH] = {0};
		char filename[MAX_PATH] = {0};
		int  line = 0;

		while(true)
		{
			//X^bN܂.
			r =	StackWalk(IMAGE_FILE_MACHINE_I386 , 
					this->CurrentProccessHandle , this->CurrentThreadHandle ,
					&stackFrame, &threadContext , NULL, 
					SymFunctionTableAccess, SymGetModuleBase, NULL);
			if (!r)
			{
				break;
			}
			if ( stackFrame.AddrPC.Offset == 0 )
			{
				break;
			}
			//AhX擾
			r = AddressMapping(stackFrame.AddrPC.Offset ,&baseOfImage,
									moduleName , functionName , filename , &line);
			if (!r)
			{
				continue;
			}
			//\[XR[h܂Ŏ擾ł̂ňꉞL^Ă.
			this->BaseAddress = baseOfImage;
			strncpy( this->FunctionName , functionName, MAX_PATH);
			strncpy( this->Filename , filename, MAX_PATH);
			this->LineNumber = line;

			//[U[̃\[XR[h?
			r = IsUserSourceCode( filename );
			if (r)
			{
				break;
			}
		}
	}

	//AhXo܂.
	BOOL AddressMapping(DWORD stackAdderPCOffset , 
		DWORD * outBaseOfImage , char * outModulename ,
		char * outFunctionname ,char * outFilename ,int * outLineNumber ) const
	{
		IMAGEHLP_MODULE imageModule = { sizeof(IMAGEHLP_MODULE) };
		BOOL r = SymGetModuleInfo(this->CurrentProccessHandle , stackAdderPCOffset , &imageModule);
		if (!r)
		{
			//printf("%p:no module:no symbol\r\n" , stackFrame.AddrPC.Offset );
			*outBaseOfImage = 0;
			outModulename[0] = '\0';
			outFunctionname[0] = '\0';
			outFilename[0] = '0';
			*outLineNumber = 0;

			return FALSE;
		}
		else
		{
			//V{i[obt@.
			IMAGEHLP_SYMBOL * imageSymbol;
			char buffer[6000 + sizeof(IMAGEHLP_SYMBOL) ] = {0};
			imageSymbol = (IMAGEHLP_SYMBOL*)buffer;
			imageSymbol->SizeOfStruct = sizeof(IMAGEHLP_SYMBOL);
			imageSymbol->MaxNameLength = 6000 - sizeof(IMAGEHLP_SYMBOL);

			//֐̎擾...
			DWORD disp = 0;
			r = ::SymGetSymFromAddr(this->CurrentProccessHandle , stackAdderPCOffset , &disp , imageSymbol );
			if (!r)
			{//֐킩܂.
				//printf("%p:%s:no symbol\r\n" , stackFrame.AddrPC.Offset , imageModule.ModuleName );
				*outBaseOfImage = imageModule.BaseOfImage;
				strncpy(outModulename , imageModule.ModuleName , MAX_PATH);
				outFunctionname[0] = '\0';
				outFilename[0] = '\0';
				*outLineNumber = 0;

				return FALSE;
			}
			else
			{
				//sԍ̎擾
				IMAGEHLP_LINE line ={sizeof(IMAGEHLP_LINE)};
				r = ::SymGetLineFromAddr
					(this->CurrentProccessHandle , stackAdderPCOffset , &disp , &line);
				if (!r)
				{//sԍ܂
					//printf("%p:%s:%s\r\n" , stackFrame.AddrPC.Offset , imageModule.ModuleName , imageSymbol->Name);
					*outBaseOfImage = imageModule.BaseOfImage;
					strncpy(outModulename , imageModule.ModuleName , MAX_PATH);
					strncpy(outFunctionname , imageSymbol->Name , MAX_PATH);
					outFilename[0] = '\0';
					*outLineNumber = 0;

					return FALSE;
				}
				else
				{//sԍ킩܂.
					//printf("%p:%s:%s %s:%d\r\n" , stackFrame.AddrPC.Offset , 
					//				imageModule.ModuleName , imageSymbol->Name , 
					//				line.FileName , line.LineNumber	);
					*outBaseOfImage = imageModule.BaseOfImage;
					strncpy(outModulename , imageModule.ModuleName , MAX_PATH);
					strncpy(outFunctionname , imageSymbol->Name , MAX_PATH);
					strncpy( outFilename , line.FileName , MAX_PATH);
					*outLineNumber = line.LineNumber;

					return TRUE;	//ɃZbg!
				}
			}
		}
	}
	//[U[̃\[XR[hȂł傤?
	BOOL IsUserSourceCode(char * outFilename ) const
	{
		//[U[̃\[XR[hƁA C:\\Ȃǂ̂悤 hCu^[܂܂Ă
		if ( outFilename[1] != ':' )
		{
			return FALSE;
		}
		if ( strstr(outFilename , "obcheck.h") != NULL)
		{
			return FALSE;	//obcheck  obcheck.h.cpp ƂŌ댟o邯ǁACɂȂŁB
		}
		//[U[̃\[XR[hł.
		return TRUE;
	}

public:
	void Here()
	{
		OBCHECK_ASSERT(this->CurrentProccessHandle == NULL);
		OBCHECK_ASSERT(this->CurrentThreadHandle == NULL);

		HANDLE currentProccessHandle = ::GetCurrentProcess();

		//݂̃Xbh̃nh擾...
		//łA GetCurrentThread Ŏ擾ł̂́ÃvZXŗLȃ_~[
		//͂Ƃق񂾂
		//́A DuplicateHandle ŕƎɓ!!
		HANDLE currentThreadHandleDummy = ::GetCurrentThread();
		HANDLE currentThreadHandle;
		BOOL dup = OBCHECK_ORIGNAL_CALL(DuplicateHandle)
							(	currentProccessHandle , currentThreadHandleDummy , 
								currentProccessHandle , &currentThreadHandle , 
								0 , FALSE , DUPLICATE_SAME_ACCESS);
		if (!dup)
		{
			OBCHECK_TRACE("StackTrace::Here:DuplicateHandle error:%d\r\n" , ::GetLastError() );
			OBCHECK_ASSERT(0);
			return ;
		}
		//ÕXbhnhɓꂽ!!
		this->CurrentProccessHandle = currentProccessHandle;
		this->CurrentThreadHandle = currentThreadHandle;

		//݂̃Xbh̃X^bNg̃XbhŌ邱Ƃ͏o܂
		//āAX^bN擾̏𑖂点AX^bNɗ]vɉוl܂邵
		//āAʃXbh쐬܂.
		unsigned int threadID = 0;
		HANDLE stackTrackerThread = (HANDLE)_beginthreadex(NULL , 0 , _Start , (void*) this ,  0 , &threadID);
//		unsigned long threadID = 0;
//		HANDLE stackTrackerThread = OBCHECK_ORIGNAL_CALL(CreateThread)(NULL , 0 ,_Start , (VOID*) this , 0 , &threadID);
		if (stackTrackerThread == NULL)
		{
			OBCHECK_TRACE("StackTrace::Here:_beginthreadex error:%d\r\n" , ::GetLastError() );
			OBCHECK_ASSERT(0);

			return ;
		}

		//X^bN擾XbhI܂őҋ@.
		while( WaitForSingleObject(stackTrackerThread , 0 ) != WAIT_OBJECT_0 )
		{
		}

		//X^bN擾Xbh~Al
		OBCHECK_ORIGNAL_CALL(CloseHandle)(stackTrackerThread);
		stackTrackerThread = NULL;
	}
};

//APItbN
//http://ruffnex.oc.to/kenji/text/api_hook/ex2.cpp
//http://jackseven.s22.xrea.com/programming/apihook.html
// ЂƂ̃W[ɑ΂APItbNs֐
static bool ReplaceAPI(const char * inModuleName , PROC inSearchProc , PROC inOverraideProc , HMODULE inMoudleTop)
{
	//.idata ZbV̐擪擾
    ULONG size = 0;
	PIMAGE_IMPORT_DESCRIPTOR  imgDesc = (PIMAGE_IMPORT_DESCRIPTOR)ImageDirectoryEntryToData(
		inMoudleTop,TRUE,IMAGE_DIRECTORY_ENTRY_IMPORT,&size);
	if (imgDesc == NULL)
	{
		return false;
	}

	//tbNW[
	for( ; imgDesc->Name ; imgDesc++)
	{
		const char * moduleName = (const char*)((PBYTE)inMoudleTop + imgDesc->Name);
		if(lstrcmpiA(inModuleName,moduleName) == 0)
		{	//TĂW[
			break;
		}
	}
	if(imgDesc->Name == NULL)
	{
		return false; //Ȃ
	}

	//W[̃AhXe[ȕ
	PIMAGE_THUNK_DATA iat = (PIMAGE_THUNK_DATA)((PBYTE)inMoudleTop+imgDesc->FirstThunk);
	for(	; iat->u1.Function; iat++ )
	{
		PROC * function = (PROC*) &iat->u1.Function;
		if (  *function == inSearchProc )
		{	//TĂ֐Ȃ̂ŏ.
			DWORD oldProtect = 0;
			VirtualProtect( function , sizeof(function) , PAGE_EXECUTE_READWRITE , &oldProtect);
			*function = inOverraideProc;
			VirtualProtect( function , sizeof(function) , oldProtect , &oldProtect);
			return true;
		}
	}
	return false;
}
//APItbNJn.
static void APIHookFunction(const char * inDLLName , const char * inFunctionName , PROC inHookProc, PROC * outOrignalProc)
{
	HMODULE mod = GetModuleHandleA(inDLLName);
	if (mod == NULL)
	{
		OBCHECK_TRACE("DLL(%s)ǂݍ܂Ă܂!\r\n" , inDLLName);
	}
	PROC orignalProc = GetProcAddress(mod , inFunctionName );
	if (orignalProc == NULL)
	{
		OBCHECK_TRACE("DLL(%s)ɂ͊֐(%s)C|[gĂ܂!\r\n" , inDLLName,inFunctionName);
	}
	//IWiۑ
	*outOrignalProc = orignalProc;

	ReplaceAPI(inDLLName, orignalProc, inHookProc, GetModuleHandle(NULL) );
	return ;
}

//APItbN~߂
static void APIUnHookFunction(const char * inDLLName , PROC inHookProc, PROC inOrignalProc, PROC * outOrignalProc)
{
	ReplaceAPI(inDLLName, inHookProc, inOrignalProc, GetModuleHandle(NULL));

	*outOrignalProc = NULL;
}

//LastError̒l󂳂Ȃ悤ɂ
class ObcheckLastErrorKeeper
{
	DWORD LastErrorValue;
public:
	ObcheckLastErrorKeeper()
	{
		this->LastErrorValue = ::GetLastError();
	}
	virtual ~ObcheckLastErrorKeeper()
	{
		::SetLastError(this->LastErrorValue);
	}
};



static void ApiHook(bool isHook)
{
	//q[v͖ ^CʂɌĂяoĂ̂ŁBBB
//	OBCHECK_APIHOOK("kernel32.dll","HeapAlloc",HeapAlloc,isHook);
//	OBCHECK_APIHOOK("kernel32.dll","HeapFree",HeapFree,isHook);
//	OBCHECK_APIHOOK("kernel32.dll","HeapReAlloc",HeapReAlloc,isHook);
//	OBCHECK_APIHOOK("kernel32.dll","HeapCreate",HeapCreate,isHook);
//	OBCHECK_APIHOOK("kernel32.dll","HeapDestroy",HeapDestroy,isHook);
	OBCHECK_APIHOOK("kernel32.dll","OpenEventA",OpenEventA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateEventA",CreateEventA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateProcessA",CreateProcessA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateFileA",CreateFileA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateFileMappingA",CreateFileMappingA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","OpenFileMappingA",OpenFileMappingA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateThread",CreateThread,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateMutexA",CreateMutexA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","OpenMutexA",OpenMutexA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateSemaphoreA",CreateSemaphoreA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","OpenSemaphoreA",OpenSemaphoreA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateNamedPipeA",CreateNamedPipeA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreatePipe",CreatePipe,isHook);
	OBCHECK_APIHOOK("kernel32.dll","FindFirstFileA",FindFirstFileA,isHook);
	OBCHECK_APIHOOK("kernel32.dll","FindClose",FindClose,isHook);
	OBCHECK_APIHOOK("kernel32.dll","CreateToolhelp32Snapshot",CreateToolhelp32Snapshot,isHook);

	OBCHECK_APIHOOK("advapi32.dll","RegOpenKeyExA",RegOpenKeyExA,isHook);
	OBCHECK_APIHOOK("advapi32.dll","RegOpenKeyA",RegOpenKeyA,isHook);
	OBCHECK_APIHOOK("advapi32.dll","RegConnectRegistryA",RegConnectRegistryA,isHook);
	OBCHECK_APIHOOK("advapi32.dll","RegCloseKey",RegCloseKey,isHook);
	OBCHECK_APIHOOK("advapi32.dll","RegCreateKeyExA",RegCreateKeyExA,isHook);
	OBCHECK_APIHOOK("advapi32.dll","RegCreateKeyA",RegCreateKeyA,isHook);


	OBCHECK_APIHOOK("kernel32.dll","CloseHandle",CloseHandle,isHook);



}

//bN
class ObcheckLock  
{
private:
	CRITICAL_SECTION CriticalSection;
public:
	ObcheckLock()
	{
		InitializeCriticalSection(&this->CriticalSection);
	}
	~ObcheckLock()	//p֎~
	{
		DeleteCriticalSection(&this->CriticalSection);
	}
	//fbhbNɂȂ?
	bool IsDeadLock()
	{
		HANDLE a = ::GetCurrentThread();
		if ( this->CriticalSection.LockCount >= 0 && 
			(unsigned int)this->CriticalSection.OwningThread == ::GetCurrentThreadId()
			)
		{
			return true;
		}
		return false;
	}

	//NeBJZNVɓ
	void Lock()
	{
		EnterCriticalSection(&this->CriticalSection);
	}

	//NeBJZNV甲
	void UnLock()
	{
		 LeaveCriticalSection(&this->CriticalSection);
	}
};

//bN.
//̃NX͎bN!
//āAǂłL~BbN!
class ObcheckAutoLock
{
public:
	ObcheckAutoLock(ObcheckLock * l)
	{
		this->Lock = l;
		this->Lock->Lock();
	}
	~ObcheckAutoLock()	//p֎~
	{
		this->Lock->UnLock();
	}
private:
	ObcheckLock*	Lock;
};

//Pt@Cœ̂ŁA std::list ͎g킸ō
class OBCheckWatchList
{
private:

//Xg mۊ֌WtbNĂ܂̂ std::list gȂ̂Ŏō
	ObCheckAutoAllocObject*		ObcheckListTop;
	ObCheckAutoAllocObject*		ObcheckListLast;
	HANDLE				ObcheckListHeapHandle;
	ObcheckLock			Lock;
	unsigned int		AllocCount;
	unsigned int		BreakCount;

	DWORD				BaseAddress;

	//singleton
	OBCheckWatchList::OBCheckWatchList()
	{
		this->AllocCount = 1;	//1JEg
		this->BreakCount = 0;

		//x[XAhX̋L^
		this->BaseAddress = (DWORD)::GetModuleHandle(NULL);

		//q[v̍쐬
		this->ObcheckListTop = NULL;
		this->ObcheckListLast = NULL;
		this->ObcheckListHeapHandle = OBCHECK_ORIGNAL_CALL(HeapCreate)
			(HEAP_GENERATE_EXCEPTIONS,sizeof(ObCheckAutoAllocObject) * 256, 0);


		//sԍ܂Ń[hĂقȁ[
		DWORD option = ::SymGetOptions();
		option |= SYMOPT_LOAD_LINES;
		option &= ~SYMOPT_UNDNAME;
		::SymSetOptions(option);

		//V{GW̏
		::SymInitialize(::GetCurrentProcess(), NULL , TRUE);
		//APItbN
		ApiHook(true);
	}

public:

	virtual OBCheckWatchList::~OBCheckWatchList()
	{
		//APItbN߂
		ApiHook(false);

		//V{GW̒~
		::SymCleanup(::GetCurrentProcess());

		//[Nꏊ̎wE
		this->ShowLeak();
		//Xg̃NA
		Clear();

		//q[ṽNA
		if (this->ObcheckListHeapHandle)
		{
			OBCHECK_ORIGNAL_CALL(HeapDestroy)(this->ObcheckListHeapHandle);
			this->ObcheckListHeapHandle = NULL;
		}
	}


	void OBCheckWatchList::Clear()
	{
		ObCheckAutoAllocObject * old = NULL;
		ObCheckAutoAllocObject * p   = NULL;

		//bN
		ObcheckAutoLock autoLock(&this->Lock);

		p = this->ObcheckListTop;
		this->ObcheckListTop = NULL;
		this->ObcheckListLast = NULL;
		this->AllocCount = 1;
		this->BreakCount = 0;

		while(p)
		{
			old = p;
			p = p->Next;

			OBCHECK_ORIGNAL_CALL(HeapFree)(this->ObcheckListHeapHandle , 0 , old );
		}
	}

	void OBCheckWatchList::ShowLeak()
	{
		//bN
		ObcheckAutoLock autoLock(&this->Lock);

		bool firstLeak = true;

		ObCheckAutoAllocObject * p   = NULL;
		p = this->ObcheckListTop;
		while(p)
		{
			if ( firstLeak)
			{
				OBCHECK_TRACE("---------- object leak!! --------------\r\n");
				firstLeak = false;
			}
			OBCHECK_TRACE("%s(%d) : {%d} Object:%p\r\n" ,  p->Filename , p->LineNumber , p->Count , p->ObjectHandle);
			p = p->Next;
		}

		if (firstLeak == false)
		{
			OBCHECK_TRACE("---------------------------------------\r\n");
		}
	}

	//Xgɒǉ
	void OBCheckWatchList::Add(void* inObjectHandle , AllocType inAllocType)
	{
		//LastError̒lۑ
		ObcheckLastErrorKeeper lastErrorKeeper;
		//fbhbNɂȂ\Ȃ牽Ȃ!
		if ( this->Lock.IsDeadLock() )
		{
			return ;
		}

		{
			//bN
			ObcheckAutoLock autoLock(&this->Lock);

			//X^bNg[XŌĂяosc
			StackTrace st;
			st.Here();

			ObCheckAutoAllocObject * p = (ObCheckAutoAllocObject *)
				OBCHECK_ORIGNAL_CALL(HeapAlloc)(this->ObcheckListHeapHandle , 0 ,sizeof(ObCheckAutoAllocObject));
			if (p == NULL)
			{//s!
				OBCHECK_TRACE("obcheck:\ȃmۂłȂ̂ŁAǐՃXg\쐬ł܂\r\n");
				return ;
			}

			p->ObjectHandle = inObjectHandle;
			p->AllocType = inAllocType;
			strncpy(p->Filename , st.GetFilename() , MAX_PATH);
			p->LineNumber = st.GetLineNumber();
			p->Next = NULL;

			if (this->AllocCount == this->BreakCount)
			{//v[N|Cg
				OBCHECK_BREAKPOINT();
			}
			p->Count = this->AllocCount++;

//OBCHECK_TRACE("-->Add %p:%d\r\n" , p->ObjectHandle , p->Count);

			if (this->ObcheckListTop == NULL)
			{//ԕC
				OBCHECK_ASSERT(this->ObcheckListLast == NULL);

				this->ObcheckListTop = p;
				this->ObcheckListLast = p;
			}
			else
			{
				OBCHECK_ASSERT(this->ObcheckListLast != NULL);
				this->ObcheckListLast->Next = p;
				this->ObcheckListLast = p;
			}
		}
	}

	void OBCheckWatchList::SetBreakCount(int inCount)
	{
		//bN
		ObcheckAutoLock autoLock(&this->Lock);

		this->BreakCount = inCount;
	}

	//Xg폜
	void OBCheckWatchList::Del(void* inObjectHandle , AllocType inAllocType)
	{
		//LastError̒lۑ
		ObcheckLastErrorKeeper lastErrorKeeper;
		//fbhbNɂȂ\Ȃ牽Ȃ!
		if ( this->Lock.IsDeadLock() )
		{
			return ;
		}

		{
			ObCheckAutoAllocObject * old = NULL;
			ObCheckAutoAllocObject * p   = NULL;
	
			//bN
			ObcheckAutoLock autoLock(&this->Lock);

			p = this->ObcheckListTop;
			while(p)
			{
				if ( p->ObjectHandle == inObjectHandle && p->AllocType == inAllocType )
				{
					break;
				}

				old = p;
				p = p->Next;
			}
			if (p == NULL )
			{
//				OBCHECK_TRACE("obcheck:mۂĂȂnhJ悤Ƃ܂\r\n");
				return ;
			}
			
			if (old == NULL)
			{//擪m[h
				OBCHECK_ASSERT (this->ObcheckListTop == p);	//擪Ȃ̂ŃgbvƓ͂!
				this->ObcheckListTop = p->Next;

				if (p == this->ObcheckListLast)
				{
					this->ObcheckListLast = p->Next;
				}
			}
			else
			{
				old->Next = p->Next;

				if (p->Next == NULL)
				{
					OBCHECK_ASSERT(p == this->ObcheckListLast);
					this->ObcheckListLast = old;
				}
			}
//OBCHECK_TRACE("-->Del %p:%d\r\n" , p->ObjectHandle , p->Count);

			//q[v̊J
			OBCHECK_ORIGNAL_CALL(HeapFree)(this->ObcheckListHeapHandle , 0 ,p );
		}
	}

	static OBCheckWatchList* GetInst()
	{
		static volatile OBCheckWatchList  a;
		return (OBCheckWatchList *) &a;
	}
	volatile void WarmingUp()
	{
	}
};

/////////////////////////////////////////////////////////////
//IuWFNg[N`FbJ[ŊJn. ?
/////////////////////////////////////////////////////////////
class ObCheckAuto
{
public:
	ObCheckAuto()
	{
		OBCheckWatchList::GetInst()->WarmingUp();
	}
	~ObCheckAuto()
	{
	}
};
static ObCheckAuto g_ObCheckAuto;


//ĎXgɍ폜
static void Obcheck_Add(void* inObjectHandle , AllocType inAllocType)
{
	OBCheckWatchList::GetInst()->Add(inObjectHandle,inAllocType);
}
//ĎXg폜
static void Obcheck_Del(void* inObjectHandle , AllocType inAllocType)
{
	OBCheckWatchList::GetInst()->Del(inObjectHandle,inAllocType);
}


////////////////////////////
//JAPI
////////////////////////////
//̃IuWFNgmۉ񐔂Ńu[N.
static void Obcheck_SetBreakCount(unsigned int inCount)
{
	OBCHECK_ASSERT(inCount >= 1);

	OBCheckWatchList::GetInst()->SetBreakCount(inCount);
}
//[N`FbNXgNA
static void Obcheck_Clear()
{
	OBCheckWatchList::GetInst()->Clear();
}
//[N\
static void Obcheck_ShowLeak()
{
	OBCheckWatchList::GetInst()->ShowLeak();
}

#else

//JAPI𖳗͉.
#define Obcheck_SetBreakCount
#define Obcheck_Clear
#define Obcheck_ShowLeak

#endif
